/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import tdg.draw.OctreeQuantizer;

class OctreeNode {
    private static final int _TRANSPARENCY_MASK = -16777216;
    private static final int _RGB_MASK = 0xFFFFFF;
    private static final int _BYTE_MASK = 255;
    private OctreeQuantizer _tree;
    private int _children;
    private OctreeNode[] _leaf;
    private int _pixels;
    private OctreeNode _parent;
    private int _level;
    private OctreeNode _next;
    private int _maxLevel;
    private long _totalRed;
    private long _totalGreen;
    private long _totalBlue;
    private int _color;
    private boolean _colorSet;

    public OctreeNode(OctreeQuantizer tree) {
        this._tree = tree;
        this._leaf = new OctreeNode[8];
        this._level = 0;
        this._maxLevel = 8;
        this._children = 0;
        this._colorSet = false;
    }

    public void addColor(int rgb) {
        int index = this._setColorVals(rgb, true);
        if (this._getLevel() < this._maxLevel && this._getLevel() < this._tree._getMaxDepth()) {
            if (this._leaf[index] == null) {
                OctreeNode newNode;
                this._leaf[index] = newNode = new OctreeNode(this);
                if (newNode._getLevel() == this._tree._getMaxDepth()) {
                    this._tree._incColors();
                }
                if (this._tree._getListHead(this._getLevel()) == null) {
                    this._tree._setListHead(this._getLevel(), newNode);
                } else {
                    this._tree._setListEnd(this._getLevel(), newNode);
                }
            }
            this._leaf[index].addColor(rgb);
        } else if (!this._colorSet) {
            this._computeColor();
        }
    }

    public int mapColor(int rgb) {
        if (this._colorSet) {
            return rgb & 0xFF000000 | this._color & 0xFFFFFF;
        }
        int index = this._setColorVals(rgb, false);
        if (this._leaf[index] == null) {
            return rgb;
        }
        return this._leaf[index].mapColor(rgb);
    }

    int _getChildren() {
        return this._children;
    }

    int _getLevel() {
        return this._level;
    }

    OctreeNode _getNext() {
        return this._next;
    }

    void _setChildren(int i) {
        if (i <= 8) {
            this._children = i;
        }
    }

    void _computeColor() {
        this._color = (int)((this._totalRed / (long)this._pixels << 16) + (this._totalGreen / (long)this._pixels << 8) + this._totalBlue / (long)this._pixels);
        this._colorSet = true;
    }

    void _setMaxLevel(int i) {
        if (i < this._maxLevel) {
            this._maxLevel = i;
        }
    }

    void _setNext(OctreeNode n) {
        this._next = n;
    }

    private OctreeNode(OctreeNode p) {
        this(p._getTree());
        this._parent = p;
        this._level = p._getLevel() + 1;
        p._incChildren();
    }

    private OctreeQuantizer _getTree() {
        return this._tree;
    }

    private void _incChildren() {
        ++this._children;
    }

    private int _setColorVals(int rgb, boolean isNew) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        int index = 0;
        if (isNew) {
            this._totalBlue += (long)blue;
            this._totalGreen += (long)green;
            this._totalRed += (long)red;
            ++this._pixels;
        }
        green <<= this._getLevel();
        blue <<= this._getLevel();
        if ((byte)(red <<= this._getLevel()) < 0) {
            index += 4;
        }
        if ((byte)green < 0) {
            index += 2;
        }
        if ((byte)blue < 0) {
            ++index;
        }
        return index;
    }
}

