/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Rectangle;
import java.io.Serializable;
import tdg.Perspective;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLabel;
import tdg.draw.DetRect;
import tdg.draw.IdentObj;
import tdg.draw.TextStyleObj;

public class DataScroller
implements Serializable {
    public static final int SCROLLER_THICKNESS = 8;
    public static final int SCROLLER_THICKNESS_HORZ = 12;
    public static final int EDITBOX_PIXELS = 60;
    public static final int PRESENCE_NEVER = 0;
    public static final int PRESENCE_SOMETIMES = 1;
    public static final int PRESENCE_ALWAYS = 2;
    protected Perspective m_Perspective;
    protected Rectangle m_rFrame;
    protected Rectangle m_rScroller;
    protected Rectangle m_rEditBox;
    protected boolean m_bVert;
    protected boolean m_bGroups;
    protected int m_nTotal;
    protected int m_nViewable;
    protected int m_nOffset;

    public DataScroller(Perspective perspective, Rectangle rFrame, boolean bVert, boolean bGroups) {
        this.m_Perspective = perspective;
        this.m_rFrame = rFrame;
        this.m_bVert = bVert;
        this.m_bGroups = bGroups;
        if (bGroups) {
            this.m_nTotal = this.m_Perspective.getNumTotalGroups();
            this.m_nViewable = this.m_Perspective.getNumGroups();
            this.m_nOffset = this.m_Perspective.getEffectiveGroupOffset();
        } else {
            this.m_nTotal = this.m_Perspective.getNumTotalSeries();
            this.m_nViewable = this.m_Perspective.getNumSeries();
            this.m_nOffset = this.m_Perspective.getEffectiveSeriesOffset();
        }
    }

    public void calc() {
        Rectangle rEditRight;
        Rectangle rEditThumb;
        Rectangle rEditLeft;
        Rectangle rEditBox;
        Rectangle rThumb;
        Rectangle rScroller;
        int nWidth;
        int nHeight;
        IdentObj idEditRight;
        IdentObj idEditThumb;
        IdentObj idEditLeft;
        IdentObj idEditBox;
        IdentObj idThumb;
        IdentObj idScroller;
        int nWidthEditBox = this.m_Perspective.m_VC.destToVirtWidth(60);
        int nHeightEditBox = this.m_Perspective.m_VC.destToVirtHeight(60);
        if (!this.isPresent()) {
            return;
        }
        if (this.m_rFrame == null) {
            return;
        }
        if (this.m_bGroups) {
            idScroller = this.m_Perspective.getGroupScroller();
            idThumb = this.m_Perspective.getGroupScrollerThumb();
            idEditBox = this.m_Perspective.getGroupScrollerEditBox();
            idEditLeft = this.m_Perspective.getGroupScrollerEditLeft();
            idEditThumb = this.m_Perspective.getGroupScrollerEditThumb();
            idEditRight = this.m_Perspective.getGroupScrollerEditRight();
        } else {
            idScroller = this.m_Perspective.getSeriesScroller();
            idThumb = this.m_Perspective.getSeriesScrollerThumb();
            idEditBox = this.m_Perspective.getSeriesScrollerEditBox();
            idEditLeft = this.m_Perspective.getSeriesScrollerEditLeft();
            idEditThumb = this.m_Perspective.getSeriesScrollerEditThumb();
            idEditRight = this.m_Perspective.getSeriesScrollerEditRight();
        }
        BlackBoxObj bbScroller = new BlackBoxObj(this.m_Perspective, idScroller);
        BlackBoxObj bbThumb = new BlackBoxObj(this.m_Perspective, idThumb);
        BlackBoxObj bbEditBox = new BlackBoxObj(this.m_Perspective, idEditBox);
        BlackBoxObj bbEditLeft = new BlackBoxObj(this.m_Perspective, idEditLeft);
        BlackBoxObj bbEditThumb = new BlackBoxObj(this.m_Perspective, idEditThumb);
        BlackBoxObj bbEditRight = new BlackBoxObj(this.m_Perspective, idEditRight);
        int nHigh = this.m_nTotal - (this.m_nOffset + this.m_nViewable);
        String sEditLeft = String.valueOf(this.m_nOffset);
        String sEditThumb = String.valueOf(this.m_nViewable);
        String sEditRight = String.valueOf(nHigh);
        if (this.m_bVert) {
            nHeight = this.m_rFrame.height - nHeightEditBox;
            nWidth = this.m_Perspective.m_VC.destToVirtWidth(12);
            rScroller = new Rectangle(this.m_rFrame.x, this.m_rFrame.y + nHeightEditBox, nWidth, nHeight);
        } else {
            nHeight = this.m_Perspective.m_VC.destToVirtHeight(8);
            nWidth = this.m_rFrame.width - nWidthEditBox;
            rScroller = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, nWidth, nHeight);
        }
        new DetRect(this.m_Perspective.m_Detectiv, idScroller, rScroller, bbScroller, null);
        if (this.m_bGroups) {
            this.m_Perspective.setRect(this.m_Perspective.getGroupScroller(), rScroller);
        } else {
            this.m_Perspective.setRect(this.m_Perspective.getSeriesScroller(), rScroller);
        }
        int nExtra = this.m_nTotal - this.m_nViewable;
        if (this.m_bVert) {
            int nThumbHeight = rScroller.height * this.m_nViewable / this.m_nTotal;
            if (nThumbHeight < this.m_Perspective.m_VC.destToVirtHeight(12)) {
                nThumbHeight = this.m_Perspective.m_VC.destToVirtHeight(12);
            }
            int nThumbCenter = nExtra == 0 ? rScroller.y + rScroller.height - nThumbHeight / 2 : rScroller.y + rScroller.height - nThumbHeight / 2 - this.m_nOffset * (rScroller.height - nThumbHeight) / nExtra;
            rThumb = new Rectangle(rScroller.x, nThumbCenter - nThumbHeight / 2, nWidth, nThumbHeight);
        } else {
            int nThumbWidth = rScroller.width * this.m_nViewable / this.m_nTotal;
            if (nThumbWidth < this.m_Perspective.m_VC.destToVirtWidth(8)) {
                nThumbWidth = this.m_Perspective.m_VC.destToVirtWidth(8);
            }
            int nThumbCenter = nExtra == 0 ? rScroller.x + nThumbWidth / 2 : rScroller.x + nThumbWidth / 2 + this.m_nOffset * (rScroller.width - nThumbWidth) / nExtra;
            rThumb = new Rectangle(nThumbCenter - nThumbWidth / 2, rScroller.y, nThumbWidth, nHeight);
        }
        new DetRect(this.m_Perspective.m_Detectiv, idThumb, rThumb, bbThumb, rScroller);
        if (this.m_bVert) {
            rEditBox = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, nWidth, nHeightEditBox);
            rEditLeft = new Rectangle(rEditBox.x, rEditBox.y + 2 * nHeightEditBox / 3, nWidth, nHeightEditBox / 3);
            rEditThumb = new Rectangle(rEditBox.x, rEditBox.y + nHeightEditBox / 3, nWidth, nHeightEditBox / 3);
            rEditRight = new Rectangle(rEditBox.x, rEditBox.y, nWidth, nHeightEditBox / 3);
        } else {
            rEditBox = new Rectangle(this.m_rFrame.x + nWidth, this.m_rFrame.y, nWidthEditBox, nHeight);
            rEditLeft = new Rectangle(rEditBox.x, rEditBox.y, nWidthEditBox / 3, nHeight);
            rEditThumb = new Rectangle(rEditBox.x + nWidthEditBox / 3, rEditBox.y, nWidthEditBox / 3, nHeight);
            rEditRight = new Rectangle(rEditBox.x + 2 * nWidthEditBox / 3, rEditBox.y, nWidthEditBox / 3, nHeight);
        }
        new DetRect(this.m_Perspective.m_Detectiv, idEditBox, rEditBox, bbEditBox, null);
        TextStyleObj tsoEditLeft = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(idEditLeft), this.m_Perspective.getFontStyle(idEditLeft), this.m_Perspective.getFontSizeAbsolute(), this.m_Perspective.getFontSize(idEditLeft), this.m_Perspective.getFontSizeVC(idEditLeft), this.m_Perspective.getTextRotation(idEditLeft), this.m_Perspective.getTextJustHoriz(idEditLeft), this.m_Perspective.getTextJustVert(idEditLeft), false, false, false);
        new DetLabel(this.m_Perspective.m_Detectiv, idEditLeft, sEditLeft, rEditLeft, tsoEditLeft, (BlackBoxIF)bbEditLeft, false, rScroller);
        TextStyleObj tsoEditThumb = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(idEditThumb), this.m_Perspective.getFontStyle(idEditThumb), this.m_Perspective.getFontSizeAbsolute(), this.m_Perspective.getFontSize(idEditThumb), this.m_Perspective.getFontSizeVC(idEditThumb), this.m_Perspective.getTextRotation(idEditThumb), this.m_Perspective.getTextJustHoriz(idEditThumb), this.m_Perspective.getTextJustVert(idEditThumb), false, false, false);
        new DetLabel(this.m_Perspective.m_Detectiv, idEditThumb, sEditThumb, rEditThumb, tsoEditThumb, (BlackBoxIF)bbEditThumb, false, rScroller);
        TextStyleObj tsoEditRight = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(idEditRight), this.m_Perspective.getFontStyle(idEditRight), this.m_Perspective.getFontSizeAbsolute(), this.m_Perspective.getFontSize(idEditRight), this.m_Perspective.getFontSizeVC(idEditRight), this.m_Perspective.getTextRotation(idEditRight), this.m_Perspective.getTextJustHoriz(idEditRight), this.m_Perspective.getTextJustVert(idEditRight), false, false, false);
        new DetLabel(this.m_Perspective.m_Detectiv, idEditRight, sEditRight, rEditRight, tsoEditRight, (BlackBoxIF)bbEditRight, false, rScroller);
    }

    public int getScrollerHeightVC() {
        int nHeight = this.m_Perspective.m_VC.destToVirtHeight(8);
        return nHeight;
    }

    public int getScrollerWidthVC() {
        int nWidth = this.m_Perspective.m_VC.destToVirtWidth(12);
        return nWidth;
    }

    public boolean isPresent() {
        int nPresence = this.m_bGroups ? this.m_Perspective.getDataScrollerPresenceGroups() : this.m_Perspective.getDataScrollerPresenceSeries();
        return nPresence != 0 && (nPresence != 1 || this.m_nViewable < this.m_nTotal);
    }

    public boolean isVertScroller() {
        return this.m_bVert;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public String toString() {
        return super.toString();
    }
}

