/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DrawingUtil;
import org.krysalis.barcode4j.output.Canvas;

public class DefaultCanvasLogicHandler
implements ClassicBarcodeLogicHandler {
    private AbstractBarcodeBean bcBean;
    private Canvas canvas;
    private double x = 0.0;
    private String formattedMsg;
    private String lastgroup;

    public DefaultCanvasLogicHandler(AbstractBarcodeBean bcBean, Canvas canvas) {
        this.bcBean = bcBean;
        this.canvas = canvas;
    }

    private double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    public void startBarcode(String msg, String formattedMsg) {
        this.formattedMsg = formattedMsg;
        BarcodeDimension dim = this.bcBean.calcDimensions(msg);
        this.canvas.establishDimensions(dim);
        this.x = this.getStartX();
    }

    public void startBarGroup(BarGroup type, String submsg) {
        this.lastgroup = submsg;
    }

    public void addBar(boolean black, int width) {
        double w = this.bcBean.getBarWidth(width);
        if (black) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_NONE) {
                this.canvas.drawRectWH(this.x, 0.0, w, this.bcBean.getHeight());
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                this.canvas.drawRectWH(this.x, this.bcBean.getHumanReadableHeight(), w, this.bcBean.getBarHeight());
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                this.canvas.drawRectWH(this.x, 0.0, w, this.bcBean.getBarHeight());
            }
        }
        this.x += w;
    }

    public void endBarGroup() {
    }

    public void endBarcode() {
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
                DrawingUtil.drawCenteredText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, this.bcBean.getHumanReadableHeight());
            } else if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
                DrawingUtil.drawCenteredText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, this.bcBean.getHeight());
            }
        }
    }
}

