/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.transport.iiop;

import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.logging.EJBIiopMessages;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.spi.HandleDelegate;
import javax.naming.Context;
import javax.rmi.CORBA.Stub;
import oracle.j2ee.corba.iiop.IIOPMessages;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.corba.ORBConfigurationException;
import oracle.oc4j.corba.ORBInitializationException;
import oracle.oc4j.corba.ServerOrbManager;
import oracle.oc4j.corba.naming.ApplicationClientNamingContext;
import oracle.oc4j.corba.transport.CorbaEJBHome;
import oracle.oc4j.corba.transport.CorbaTransportManager;
import oracle.oc4j.transport.ApplicationTransportConfig;
import oracle.oc4j.transport.TransportManager;
import oracle.oc4j.transport.iiop.HandleDelegateImpl;
import oracle.oc4j.transport.iiop.HandleImpl;
import oracle.oc4j.transport.iiop.HomeHandleImpl;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class IiopTransportManager
extends TransportManager {
    private int m_port;
    private String m_host;

    public IiopTransportManager(String host, int port) {
        this.m_host = host;
        this.m_port = port;
    }

    public String getProviderUrl(String applicationName) {
        return "corbaname::" + this.getHost() + ":" + this.getPort() + "#/" + applicationName;
    }

    private String getPort() {
        return Integer.toString(this.m_port);
    }

    private String getHost() {
        return this.m_host;
    }

    public boolean supports(ApplicationTransportConfig config) {
        return (IiopTransportManager.isIIOPInvocation() || this.isDeploymentThread()) && config.isIiopEnabled();
    }

    private boolean isDeploymentThread() {
        return Thread.currentThread().getName().startsWith("DeployerRunnable");
    }

    public boolean supports(Thread thread) {
        return !(thread instanceof ApplicationServerThread);
    }

    public HomeHandle getHomeHandle(AbstractEJBHome home) {
        return new HomeHandleImpl((EJBHome)home);
    }

    public boolean isRmiCall() {
        return true;
    }

    protected ORB doGetOrbInstance() {
        ORB orb = null;
        try {
            orb = ServerOrbManager.getOrb();
        }
        catch (ORBConfigurationException e) {
            IIOPMessages.severeUnableToGetOrb(e);
        }
        return orb;
    }

    public java.lang.Object cloneArray(java.lang.Object array, AbstractEJBHome home) throws RemoteException {
        return array;
    }

    public java.lang.Object exportObject(AbstractEJBObject ejbObject) {
        AbstractEJBHome ejbHome = ejbObject.getMyHome();
        if (!AbstractEJBObject.isIIOPConfigured(ejbHome) || !(ejbObject instanceof EJBObject)) {
            System.out.println("XXXXXX something is really wrong here. Please scream at the developers!");
            return null;
        }
        try {
            return CorbaTransportManager.getInstance().deployEjb(ejbHome, (EJBObject)ejbObject);
        }
        catch (ORBInitializationException e) {
            EJBIiopMessages.severeUnableToCreateObjectReference(ejbHome, e);
            throw new RuntimeException(e);
        }
    }

    public void exportDBEntityObjectCollection(Collection wrappers) {
        if (IiopTransportManager.isIIOPInvocation() && wrappers instanceof List) {
            List list = (List)wrappers;
            ListIterator<java.lang.Object> itor = list.listIterator();
            while (itor.hasNext()) {
                java.lang.Object stub = this.exportObject((AbstractEJBObject)itor.next());
                if (stub == null) continue;
                itor.set(stub);
            }
        }
    }

    public Enumeration exportDBEntityObjectEnumeration(Enumeration wrappers) {
        ArrayList wrappersCollection = Collections.list(wrappers);
        this.exportDBEntityObjectCollection(wrappersCollection);
        return Collections.enumeration(wrappersCollection);
    }

    public Handle getHandle(AbstractEJBObject ejbObject) {
        if (!(ejbObject instanceof Remote)) {
            return null;
        }
        return new HandleImpl((EJBObject)ejbObject.getStub());
    }

    public java.lang.Object getTransportSpecificResponseObject(java.lang.Object obj) {
        java.lang.Object response = obj;
        if (obj instanceof AbstractEJBObject) {
            response = ((AbstractEJBObject)obj).getCorbaReference();
        }
        if (obj instanceof CorbaEJBHome) {
            response = ((CorbaEJBHome)obj).getHomeReference();
        }
        return response;
    }

    public void createTransportApplicationContext(String appName, Context ctx) throws InstantiationException {
        NameComponent[] name = new NameComponent[]{new NameComponent(appName, "")};
        try {
            NamingContext rootContext = NamingContextHelper.narrow((Object)ServerOrbManager.getOrb().resolve_initial_references("NameService"));
            this.unbindExistingContext(rootContext, name);
            rootContext.bind_context(name, (NamingContext)new ApplicationClientNamingContext(ctx));
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw new InstantiationException(invalidName.toString());
        }
        catch (ORBConfigurationException e) {
            throw new InstantiationException(e.toString());
        }
        catch (NotFound notFound) {
            throw new InstantiationException(notFound.toString());
        }
        catch (CannotProceed cannotProceed) {
            throw new InstantiationException(cannotProceed.toString());
        }
        catch (InvalidName invalidName) {
            throw new InstantiationException(invalidName.toString());
        }
        catch (AlreadyBound alreadyBound) {
            // empty catch block
        }
    }

    private void unbindExistingContext(NamingContext rootContext, NameComponent[] name) throws CannotProceed, NotFound, InvalidName {
        NamingContext appContext = null;
        try {
            appContext = NamingContextHelper.narrow((Object)rootContext.resolve(name));
        }
        catch (NotFound notFound) {
        }
        catch (CannotProceed cannotProceed) {
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
        if (appContext != null) {
            rootContext.unbind(name);
        }
    }

    public boolean isIdentical(AbstractEJBObject ejbObject, Stub stub) {
        return ejbObject.getMyHome().getCorbaReferenceGenerator().isIdentical((EJBObject)stub, ejbObject);
    }

    protected HandleDelegate doGetHandleDelegate() {
        return new HandleDelegateImpl();
    }

    public static boolean isIIOPInvocation() {
        return !CommonThreadState.getCurrent().isApplicationThread();
    }

    public void undeployApplication(String name) {
        CorbaTransportManager.getInstance().undeployApplication(name);
    }
}

