/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.transport;

import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AbstractEJBObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.spi.HandleDelegate;
import javax.naming.Context;
import javax.rmi.CORBA.Stub;
import oracle.oc4j.transport.ApplicationTransportConfig;
import org.omg.CORBA.ORB;

public abstract class TransportManager {
    static TransportManager m_defaultTransportManager;
    static List m_transportManagers;

    public static void initialize(TransportManager defaultTransportManager) {
        m_defaultTransportManager = defaultTransportManager;
        m_transportManagers = new ArrayList();
    }

    public static void addManager(TransportManager transportManager) {
        m_transportManagers.add(transportManager);
    }

    public static TransportManager getInstance(ApplicationTransportConfig config) {
        for (int i = 0; i < m_transportManagers.size(); ++i) {
            TransportManager transportManager = (TransportManager)m_transportManagers.get(i);
            if (!transportManager.supports(config)) continue;
            return transportManager;
        }
        return m_defaultTransportManager;
    }

    public abstract String getProviderUrl(String var1);

    public abstract boolean supports(ApplicationTransportConfig var1);

    public abstract boolean supports(Thread var1);

    public abstract HomeHandle getHomeHandle(AbstractEJBHome var1);

    public abstract Handle getHandle(AbstractEJBObject var1) throws RemoteException;

    public abstract Object exportObject(AbstractEJBObject var1);

    public abstract void exportDBEntityObjectCollection(Collection var1);

    public abstract Enumeration exportDBEntityObjectEnumeration(Enumeration var1);

    public abstract boolean isIdentical(AbstractEJBObject var1, Stub var2);

    public abstract Object getTransportSpecificResponseObject(Object var1);

    public abstract void createTransportApplicationContext(String var1, Context var2) throws InstantiationException;

    public abstract boolean isRmiCall();

    public abstract Object cloneArray(Object var1, AbstractEJBHome var2) throws RemoteException;

    public static TransportManager getInstance() {
        Thread currentThread = Thread.currentThread();
        for (int i = 0; i < m_transportManagers.size(); ++i) {
            TransportManager transportManager = (TransportManager)m_transportManagers.get(i);
            if (!transportManager.supports(currentThread)) continue;
            return transportManager;
        }
        return m_defaultTransportManager;
    }

    public static HandleDelegate getHandleDelegate() {
        return TransportManager.getInstance().doGetHandleDelegate();
    }

    protected abstract HandleDelegate doGetHandleDelegate();

    public static ORB getORBInstance() {
        ORB orb = null;
        for (int i = 0; orb == null && i < m_transportManagers.size(); ++i) {
            orb = ((TransportManager)m_transportManagers.get(i)).doGetOrbInstance();
        }
        if (orb == null) {
            orb = ORB.init((String[])new String[0], null);
        }
        return orb;
    }

    protected ORB doGetOrbInstance() {
        return null;
    }

    public abstract void undeployApplication(String var1);

    static {
        m_transportManagers = new ArrayList();
    }
}

