/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.xa;

import com.evermind.server.RecoverableSinglePhaseResource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.xa.EmulatedXAConnection;
import oracle.oc4j.sql.xa.EmulatedXAResource;
import oracle.oc4j.sql.xa.RecoverableCommitStrategy;

public class RecoverableEmulatedXAResource
extends EmulatedXAResource
implements RecoverableSinglePhaseResource {
    private RecoverableCommitStrategy m_strategy;
    private boolean m_enableCommitRecord = false;
    private boolean m_exceptionOccurred;

    public RecoverableEmulatedXAResource(EmulatedXAConnection emulatedXAConnection, RecoverableCommitStrategy strategy) {
        super(emulatedXAConnection);
        this.m_strategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        Connection connection = null;
        try {
            connection = this.getPhysicalConnection();
            if (xid == null) {
                String msg = DataSourceMessages.warningEmulatedXAResourceCommitXidNull();
                this.ThrowXaErr(msg, -4);
            }
            this.m_strategy.commit(xid, connection, this.m_enableCommitRecord);
            Object var6_5 = null;
            this.m_enableCommitRecord = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_enableCommitRecord = false;
            if (this.getPreviousCommitOption() && connection != null) {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException e) {
                    DataSourceMessages.warningEmulatedXAResourceSetAutoCommitFailed(e);
                }
            }
            throw throwable;
        }
        if (this.getPreviousCommitOption() && connection != null) {
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                DataSourceMessages.warningEmulatedXAResourceSetAutoCommitFailed(e);
            }
        }
    }

    public Xid[] recover(int flag) throws XAException {
        if (this.m_exceptionOccurred) {
            XAException xae = new XAException("XAResource Connection is invalid");
            xae.errorCode = -7;
            throw xae;
        }
        return new Xid[0];
    }

    public boolean isCommitted(Xid xid) throws XAException {
        try {
            Connection connection = this.getPhysicalConnection();
            return this.m_strategy.isCommitted(xid, connection);
        }
        catch (XAException e) {
            this.m_exceptionOccurred = true;
            throw e;
        }
    }

    public void enableWriteCommitRecord() {
        this.m_enableCommitRecord = true;
    }

    public boolean purgeCommitRecords(Xid[] xids) {
        Connection connection = null;
        try {
            connection = this.getPhysicalConnection();
        }
        catch (XAException e) {
            return false;
        }
        return this.m_strategy.purgeCommitRecords(xids, connection);
    }

    public byte[][] recoverCommitted() throws XAException {
        Connection connection = this.getPhysicalConnection();
        return this.m_strategy.recoverCommitted(connection);
    }
}

