/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.xa;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import oracle.j2ee.datasource.DataSourceMessages;

public class ICCXAConnection
implements XAConnection {
    private DataSource m_iccXADataSource;
    private Connection m_iccConnection;
    private XAResource m_xaResource;

    private void init(DataSource iccXADataSource) throws IllegalArgumentException {
        if (iccXADataSource == null) {
            String msg = DataSourceMessages.severeICCOracleXADataSourceNull();
            throw new IllegalArgumentException(msg);
        }
        this.m_iccXADataSource = iccXADataSource;
    }

    public ICCXAConnection(DataSource iccXADataSource) throws IllegalArgumentException, SQLException {
        this.init(iccXADataSource);
        this.m_iccConnection = this.m_iccXADataSource.getConnection();
    }

    public ICCXAConnection(DataSource iccXADataSource, String user, String password) throws IllegalArgumentException, SQLException {
        this.init(iccXADataSource);
        this.m_iccConnection = this.m_iccXADataSource.getConnection(user, password);
    }

    public XAResource getXAResource() throws SQLException {
        if (this.m_xaResource == null) {
            Class[] params = new Class[]{};
            try {
                Class<?> oracleConnectionClass = Class.forName("oracle.jdbc.internal.OracleConnection", true, this.m_iccConnection.getClass().getClassLoader());
                Method method = oracleConnectionClass.getDeclaredMethod("getXAResource", params);
                this.m_xaResource = (XAResource)method.invoke((Object)this.m_iccConnection, null);
            }
            catch (NoSuchMethodException e) {
                String msg = DataSourceMessages.severeICCGetXAResource(e);
                throw new SQLException(msg);
            }
            catch (Exception e) {
                String msg = DataSourceMessages.severeICCExecuteXAResource(e);
                throw new SQLException(msg);
            }
        }
        return this.m_xaResource;
    }

    public Connection getConnection() throws SQLException {
        return this.m_iccConnection;
    }

    public void close() throws SQLException {
        this.m_iccConnection.close();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
    }

    public XADataSource getIccXADataSource() {
        return (XADataSource)((Object)this.m_iccXADataSource);
    }
}

