/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.xa;

import com.evermind.server.SinglePhaseResource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.xa.EmulatedXAConnection;

public class EmulatedXAResource
implements XAResource,
SinglePhaseResource {
    private EmulatedXAConnection m_emulatedXAConnection = null;
    private boolean m_previousCommitOption;

    public EmulatedXAResource(EmulatedXAConnection emulatedXAConnection) {
        if (emulatedXAConnection == null) {
            throw new IllegalArgumentException("The emulated XAConnection can not be null.");
        }
        this.m_emulatedXAConnection = emulatedXAConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        Connection connection = null;
        connection = this.getPhysicalConnection();
        if (xid == null) {
            String msg = DataSourceMessages.warningEmulatedXAResourceCommitXidNull();
            this.ThrowXaErr(msg, -4);
        }
        connection.commit();
        Object var7_6 = null;
        if (!this.m_previousCommitOption) return;
        if (connection == null) return;
        try {
            connection.setAutoCommit(true);
            return;
        }
        catch (SQLException e) {
            DataSourceMessages.warningEmulatedXAResourceSetAutoCommitFailed(e);
        }
        return;
        {
            catch (SQLException sqlException) {
                String msg = DataSourceMessages.warningEmulatedXAResourceCommitFailed();
                this.ThrowXaErr(msg, onePhase ? 100 : -3, sqlException);
                Object var7_7 = null;
                if (!this.m_previousCommitOption) return;
                if (connection == null) return;
                try {
                    connection.setAutoCommit(true);
                    return;
                }
                catch (SQLException e) {
                    DataSourceMessages.warningEmulatedXAResourceSetAutoCommitFailed(e);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!this.m_previousCommitOption || connection == null) throw throwable;
            try {
                connection.setAutoCommit(true);
                throw throwable;
            }
            catch (SQLException e) {
                DataSourceMessages.warningEmulatedXAResourceSetAutoCommitFailed(e);
            }
            throw throwable;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (xid == null) {
            String msg = DataSourceMessages.warningEmulatedXAResourceEndXidNull();
            this.ThrowXaErr(msg, -4);
        }
    }

    public void forget(Xid xid) throws XAException {
        String msg = DataSourceMessages.warningEmulatedXAResourceForget();
        this.ThrowXaErr(msg, -6);
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (!(xaResource instanceof EmulatedXAResource)) {
            return false;
        }
        return this.getPhysicalConnection().equals(((EmulatedXAResource)xaResource).getPhysicalConnection());
    }

    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            String msg = DataSourceMessages.warningEmulatedXAResourcePrepareXidNull();
            this.ThrowXaErr(msg, -4);
        }
        this.getPhysicalConnection();
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        String msg = DataSourceMessages.warningEmulatedXAResourceRecover();
        return new Xid[0];
    }

    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            String msg = DataSourceMessages.warningEmulatedXAResourceRollbackXidNull();
            this.ThrowXaErr(msg, -4);
        }
        try {
            Connection connection = this.getPhysicalConnection();
            connection.rollback();
            if (this.m_previousCommitOption) {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException sqlException) {
            String msg = DataSourceMessages.warningEmulatedXAResourceRollbackFailed(sqlException);
            this.ThrowXaErr(msg, -3, sqlException);
        }
    }

    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        return false;
    }

    protected boolean getPreviousCommitOption() {
        return this.m_previousCommitOption;
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            Connection connection = this.getPhysicalConnection();
            this.m_previousCommitOption = connection.getAutoCommit();
            if (this.m_previousCommitOption) {
                connection.setAutoCommit(false);
            }
        }
        catch (SQLException sqlException) {
            String msg = DataSourceMessages.warningEmulatedXAResourcePrepareCommitFailed(sqlException);
            this.ThrowXaErr(msg, -3, sqlException);
        }
        if (xid == null) {
            String msg = DataSourceMessages.warningEmulatedXAResourceStartXidNull();
            this.ThrowXaErr(msg, -4);
        }
    }

    protected void ThrowXaErr(String logMsg, int errCode) throws XAException {
        this.ThrowXaErr(logMsg, errCode, null);
    }

    private void ThrowXaErr(String logMsg, int errCode, Throwable t) throws XAException {
        XAException xaException = new XAException(logMsg);
        xaException.errorCode = errCode;
        if (t != null) {
            xaException.initCause(t);
        }
        throw xaException;
    }

    public XADataSource getXADataSource() {
        return this.m_emulatedXAConnection.getXADataSource();
    }

    protected Connection getPhysicalConnection() throws XAException {
        Connection connection = this.m_emulatedXAConnection.getCurrentLogicalConnection();
        if (connection == null) {
            String msg = DataSourceMessages.warningEmulatedXAResourcePhysicalConnectionNull();
            this.ThrowXaErr(msg, -3);
        }
        return connection;
    }
}

