/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.xa;

import java.io.PrintWriter;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.xa.EmulatedXAConnection;
import oracle.oc4j.sql.xa.EmulatedXAResource;
import oracle.oc4j.sql.xa.RecoverableCommitStrategy;
import oracle.oc4j.sql.xa.RecoverableEmulatedXAResource;

public class EmulatedXADataSource
implements XADataSource {
    private ConnectionPoolDataSource m_connectionPoolDataSource = null;
    private RecoverableCommitStrategy m_recoverableCommitStrategy;
    private boolean m_strategyChecked = false;

    public EmulatedXADataSource(ConnectionPoolDataSource cpds) {
        if (cpds == null) {
            throw new IllegalArgumentException("The ConnectionPoolDataSource can not be null.");
        }
        this.m_connectionPoolDataSource = cpds;
    }

    public EmulatedXADataSource(ConnectionPoolDataSource cpds, RecoverableCommitStrategy recoverableCommitStrategy) {
        this(cpds);
        this.m_recoverableCommitStrategy = recoverableCommitStrategy;
    }

    protected EmulatedXAResource createEmulatedXAResource(EmulatedXAConnection emulatedXAConnection) throws SQLException {
        if (!this.m_strategyChecked && this.m_recoverableCommitStrategy != null) {
            if (!emulatedXAConnection.isRecoverableCommitStrategyAvailable(this.m_recoverableCommitStrategy)) {
                this.m_recoverableCommitStrategy = null;
            }
            this.m_strategyChecked = true;
        }
        if (this.m_recoverableCommitStrategy != null) {
            return new RecoverableEmulatedXAResource(emulatedXAConnection, this.m_recoverableCommitStrategy);
        }
        return new EmulatedXAResource(emulatedXAConnection);
    }

    public XAConnection getXAConnection() throws SQLException {
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
            DataSourceMessages.debugBeforeGetConnection(this.m_connectionPoolDataSource);
        }
        PooledConnection pooledConnection = this.m_connectionPoolDataSource.getPooledConnection();
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
            DataSourceMessages.debugAfterGetConnection(this.m_connectionPoolDataSource);
        }
        return new EmulatedXAConnection(this, pooledConnection);
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
            DataSourceMessages.debugBeforeGetConnection(this.m_connectionPoolDataSource);
        }
        PooledConnection pooledConnection = this.m_connectionPoolDataSource.getPooledConnection(user, password);
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
            DataSourceMessages.debugAfterGetConnection(this.m_connectionPoolDataSource);
        }
        return new EmulatedXAConnection(this, pooledConnection);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_connectionPoolDataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_connectionPoolDataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_connectionPoolDataSource.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_connectionPoolDataSource.getLoginTimeout();
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.m_connectionPoolDataSource;
    }
}

