/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.proxy;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.j2ee.connector.proxy.BCELProxyClassLoader;
import oracle.j2ee.connector.proxy.BCELProxyFactory;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public abstract class ConstructionKey {
    private String m_interfaceName;
    private String m_methodName;
    private List m_values = new Vector();
    protected Object m_target;
    private boolean m_isValid = true;
    private static Map m_getterNames = new HashMap();

    public ConstructionKey(String interfaceName, String methodName) {
        this.m_interfaceName = interfaceName;
        this.m_methodName = methodName;
    }

    public int hashCode() {
        int result = 17;
        result = this.m_interfaceName == null ? result : 37 * result + this.m_interfaceName.hashCode();
        result = this.m_methodName == null ? result : 37 * result + this.m_methodName.hashCode();
        Iterator iterator = this.m_values.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            result = value == null ? result : 37 * result + value.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConstructionKey)) {
            return false;
        }
        ConstructionKey key = (ConstructionKey)obj;
        if (!key.m_interfaceName.equals(this.m_interfaceName) || !key.m_methodName.equals(this.m_methodName)) {
            return false;
        }
        return ((Object)key.m_values).equals(this.m_values);
    }

    public abstract Object invoke();

    public boolean isValid() {
        return this.m_isValid;
    }

    public final void setValid(boolean valid) {
        this.m_isValid = valid;
    }

    public void setTarget(Object target) {
        this.m_target = target;
    }

    public void setArg(Object value) {
        this.m_values.add(value);
    }

    public void setArg(boolean value) {
        this.m_values.add(new Boolean(value));
    }

    public void setArg(int value) {
        this.m_values.add(new Integer(value));
    }

    public void setArg(float value) {
        this.m_values.add(new Float(value));
    }

    public void setArg(double value) {
        this.m_values.add(new Double(value));
    }

    public void setArg(long value) {
        this.m_values.add(new Long(value));
    }

    public void setArg(short value) {
        this.m_values.add(new Short(value));
    }

    public void setArg(byte value) {
        this.m_values.add(new Byte(value));
    }

    public void setArg(char value) {
        this.m_values.add(new Character(value));
    }

    public Object getArg(int index) {
        return this.m_values.get(index);
    }

    public boolean getBooleanArg(int index) {
        return (Boolean)this.m_values.get(index);
    }

    public int getIntArg(int index) {
        return (Integer)this.m_values.get(index);
    }

    public float getFloatArg(int index) {
        return ((Float)this.m_values.get(index)).floatValue();
    }

    public double getDoubleArg(int index) {
        return (Double)this.m_values.get(index);
    }

    public long getLongArg(int index) {
        return (Long)this.m_values.get(index);
    }

    public short getShortArg(int index) {
        return (Short)this.m_values.get(index);
    }

    public byte getByteArg(int index) {
        return (Byte)this.m_values.get(index);
    }

    public char getCharArg(int index) {
        return ((Character)this.m_values.get(index)).charValue();
    }

    public static String getConstructionKeyClassName(String interfaceName, String methodName, String signature) {
        StringBuffer name = new StringBuffer(interfaceName + "-" + methodName + signature + "__BCELProxyKey");
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            name.setCharAt(i, '_');
        }
        return name.toString();
    }

    public static ConstructionKey createConstructionKey(String interfaceName, String methodName, String signature, BCELProxyClassLoader bcelProxyClassLoader) throws InstantiationException {
        String name = ConstructionKey.getConstructionKeyClassName(interfaceName, methodName, signature);
        return ConstructionKey.createConstructionKey(name, interfaceName, methodName, signature, bcelProxyClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstructionKey createConstructionKey(String name, String interfaceName, String methodName, String signature, BCELProxyClassLoader bcelProxyClassLoader) throws InstantiationException {
        BCELProxyClassLoader bCELProxyClassLoader = bcelProxyClassLoader;
        synchronized (bCELProxyClassLoader) {
            Class cl;
            if (bcelProxyClassLoader.isClassDefined(name)) {
                return (ConstructionKey)ConstructionKey.loadConstructionKey(name, interfaceName, methodName, bcelProxyClassLoader);
            }
            ClassGen classGen = new ClassGen(name, ConstructionKey.class.getName(), "", 1, new String[0]);
            ConstantPoolGen constantPool = classGen.getConstantPool();
            InstructionFactory instructionFactory = new InstructionFactory(classGen);
            ConstructionKey.addConstructionKeyConstructor(name, ConstructionKey.class, constantPool, classGen);
            ConstructionKey.addConstructionKeyMethod(name, methodName, signature, interfaceName, constantPool, instructionFactory, classGen);
            try {
                cl = BCELProxyFactory.defineClass(classGen, name, bcelProxyClassLoader);
            }
            catch (IOException e) {
                throw new InstantiationException(e.toString());
            }
            return (ConstructionKey)ConstructionKey.instantiateConstructionKey(cl, interfaceName, methodName);
        }
    }

    private static Object loadConstructionKey(String name, String interfaceName, String methodName, BCELProxyClassLoader bcelProxyClassLoader) throws InstantiationException {
        try {
            Class cl = bcelProxyClassLoader.loadClass(name);
            return ConstructionKey.instantiateConstructionKey(cl, interfaceName, methodName);
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException(e.toString());
        }
    }

    private static Object instantiateConstructionKey(Class cl, String interfaceName, String methodName) throws InstantiationException {
        try {
            Constructor constructor = cl.getConstructor(String.class, String.class);
            return constructor.newInstance(interfaceName, methodName);
        }
        catch (Exception e) {
            throw new InstantiationException(e.toString());
        }
    }

    private static void addConstructionKeyConstructor(String name, Class superClass, ConstantPoolGen constantPool, ClassGen classGenerator) {
        InstructionList il = new InstructionList();
        il.append((Instruction)InstructionConstants.THIS);
        il.append((Instruction)new ALOAD(1));
        il.append((Instruction)new ALOAD(2));
        il.append((Instruction)new INVOKESPECIAL(constantPool.addMethodref(superClass.getName(), "<init>", "(" + Type.STRING.getSignature() + Type.STRING.getSignature() + ")V")));
        il.append((Instruction)InstructionConstants.RETURN);
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, new Type[]{Type.STRING, Type.STRING}, null, "<init>", name, il, constantPool);
        mg.stripAttributes(true);
        mg.setMaxStack();
        mg.setMaxLocals();
        classGenerator.addMethod(mg.getMethod());
    }

    private static void addConstructionKeyMethod(String name, String methodName, String signature, String interfaceName, ConstantPoolGen constantPool, InstructionFactory instructionFactory, ClassGen classGenerator) {
        InstructionList il = new InstructionList();
        ObjectType returnType = Type.OBJECT;
        MethodGen mg = new MethodGen(1, (Type)returnType, new Type[0], null, "invoke", name, il, constantPool);
        il.append((Instruction)InstructionConstants.THIS);
        il.append((Instruction)instructionFactory.createGetField(ConstructionKey.class.getName(), "m_target", (Type)Type.OBJECT));
        Type[] argumentTypes = Type.getArgumentTypes((String)signature);
        for (int i = 0; i < argumentTypes.length; ++i) {
            il.append((Instruction)InstructionConstants.THIS);
            il.append((Instruction)new BIPUSH((byte)i));
            String getterName = (String)m_getterNames.get(argumentTypes[i]);
            if (getterName == null) {
                il.append((Instruction)instructionFactory.createInvoke((class$oracle$oc4j$sql$proxy$ConstructionKey == null ? ConstructionKey.class$("oracle.oc4j.sql.proxy.ConstructionKey") : class$oracle$oc4j$sql$proxy$ConstructionKey).getName(), "getArg", (Type)Type.OBJECT, new Type[]{Type.INT}, (short)182));
                if (argumentTypes[i] instanceof ObjectType) {
                    il.append((Instruction)new CHECKCAST(constantPool.addClass((ObjectType)argumentTypes[i])));
                    continue;
                }
                if (!(argumentTypes[i] instanceof ArrayType)) continue;
                il.append((Instruction)new CHECKCAST(constantPool.addArrayClass((ArrayType)argumentTypes[i])));
                continue;
            }
            il.append((Instruction)instructionFactory.createInvoke((class$oracle$oc4j$sql$proxy$ConstructionKey == null ? ConstructionKey.class$("oracle.oc4j.sql.proxy.ConstructionKey") : class$oracle$oc4j$sql$proxy$ConstructionKey).getName(), getterName, argumentTypes[i], new Type[]{Type.INT}, (short)182));
        }
        il.append((Instruction)instructionFactory.createInvoke(interfaceName, methodName, Type.getReturnType((String)signature), Type.getArgumentTypes((String)signature), (short)185));
        il.append((Instruction)InstructionFactory.createReturn((Type)returnType));
        mg.stripAttributes(true);
        mg.setMaxStack();
        mg.setMaxLocals();
        classGenerator.addMethod(mg.getMethod());
    }

    static {
        m_getterNames.put(Type.BOOLEAN, "getBooleanArg");
        m_getterNames.put(Type.INT, "getIntArg");
        m_getterNames.put(Type.FLOAT, "getFloatArg");
        m_getterNames.put(Type.DOUBLE, "getDoubleArg");
        m_getterNames.put(Type.LONG, "getLongArg");
        m_getterNames.put(Type.SHORT, "getShortArg");
        m_getterNames.put(Type.BYTE, "getByteArg");
        m_getterNames.put(Type.CHAR, "getCharArg");
    }
}

