/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.mbean;

import com.evermind.server.ApplicationServer;
import java.util.Locale;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.Sensor;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.shared.statistic.StatsLocalizationHelper;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSMetric;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSTimeStatistic;
import oracle.oc4j.sql.mbean.DMSUtils;

public class DMSJDBCConnectionStats {
    public static final String STAT_NAME_USE_TIME = "UseTime";
    public static final String STAT_NAME_WAIT_TIME = "WaitTime";
    public static final String DMS_NAME_JDBC = "jdbc";
    public static final String DEFAULT_DMS_TYPE = "jdbc_connection_stats";
    protected StatsLocalizationHelper m_statsLocalizationHelper = null;
    private NounIntf m_parentNoun;
    private String m_dmsStatName = null;
    private String m_dmsType = null;
    private NounIntf m_dmsNoun;
    private PhaseEventIntf m_waitTimeState;
    private PhaseEventIntf m_useTimeState;
    private long m_useStartTime;

    public DMSJDBCConnectionStats(NounIntf parentNoun, String dmsStatName) throws IllegalArgumentException {
        this(parentNoun, dmsStatName, DEFAULT_DMS_TYPE);
    }

    public DMSJDBCConnectionStats(NounIntf parentNoun, String dmsStatName, String dmsType) throws IllegalArgumentException {
        if (dmsStatName == null) {
            String msg = DataSourceMessages.warningDMSJDBCConnectionStatsStatNameNull();
            throw new IllegalArgumentException(msg);
        }
        this.m_dmsStatName = dmsStatName;
        if (dmsType == null) {
            String msg = DataSourceMessages.warningDMSJDBCConnectionStatsDMSTypNull();
            throw new IllegalArgumentException(msg);
        }
        this.m_dmsType = dmsType;
        this.m_parentNoun = parentNoun;
        this.m_statsLocalizationHelper = DMSUtils.isDMSActive() ? new StatsLocalizationHelper(J2EEManagedObjectBase.getLocaleForCall()) : new StatsLocalizationHelper(Locale.getDefault());
        this.createDMS();
    }

    public void setWaitTime(long waitTime) {
        if (this.m_waitTimeState != null) {
            this.m_waitTimeState.stop(0L, waitTime);
        }
    }

    public void incrementWaitTime(long waitTime) {
        if (this.m_waitTimeState != null) {
            this.m_waitTimeState.stop(0L, waitTime);
        }
    }

    public void startUseTime(long startUseTime) {
        this.m_useStartTime = startUseTime;
        if (this.m_useTimeState != null) {
            this.m_useTimeState.start(startUseTime);
        }
    }

    public void updateUseTime() {
        if (this.m_useTimeState != null) {
            this.m_useStartTime = this.m_useTimeState.stop2(this.m_useStartTime);
        }
    }

    public void incrementUseTime(long useTime) {
        if (this.m_useTimeState != null) {
            this.m_useTimeState.stop(0L, useTime);
        }
    }

    public DMSStatistic[] getDMSStatisticDefinitions() {
        if (this.m_dmsNoun != null) {
            DMSStatistic[] stats = new DMSStatistic[]{new DMSTimeStatistic(new DMSMetric((Sensor)((PhaseEvent)this.m_useTimeState), STAT_NAME_USE_TIME, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionstats_usetime"), null)), new DMSTimeStatistic(new DMSMetric((Sensor)((PhaseEvent)this.m_waitTimeState), STAT_NAME_WAIT_TIME, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionstats_waittime"), null))};
            return stats;
        }
        return new DMSStatistic[0];
    }

    private void createDMSNoun() {
        if (this.m_parentNoun != null) {
            this.m_dmsNoun = ApplicationServer.nounFactory().create(this.m_parentNoun, this.m_dmsStatName, this.m_dmsType);
        }
    }

    protected void createDMS() {
        if (DMSUtils.isDMSActive()) {
            this.createDMSNoun();
            this.createStats();
        }
    }

    protected void createStats() {
        if (this.m_dmsNoun != null) {
            this.m_waitTimeState = ApplicationServer.phaseEventFactory().create(this.m_dmsNoun, STAT_NAME_WAIT_TIME, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionstats_waittime"));
            this.m_waitTimeState.deriveMetric(1);
            this.m_useTimeState = ApplicationServer.phaseEventFactory().create(this.m_dmsNoun, STAT_NAME_USE_TIME, this.m_statsLocalizationHelper.getLocalizedMessage("stats_jdbcconnectionstats_usetime"));
            this.m_useTimeState.deriveMetric(1);
        }
    }

    public String getDmsStatName() {
        return this.m_dmsStatName;
    }

    public String getDmsType() {
        return this.m_dmsType;
    }

    public NounIntf getDmsNoun() {
        return this.m_dmsNoun;
    }

    public StatsLocalizationHelper getStatsLocalizationHelper() {
        return this.m_statsLocalizationHelper;
    }

    public NounIntf getParentNoun() {
        return this.m_parentNoun;
    }

    public long getUseStartTime() {
        return this.m_useStartTime;
    }
}

