/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import java.io.Serializable;
import oracle.oc4j.sql.config.ConfigObject;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyConfig
extends ConfigObject
implements Serializable {
    public static final String ROOT_NODE_NAME = "property";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String VALUE_ATTRIBUTE = "value";
    private String m_name;
    private String m_value;

    public PropertyConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        this.setName();
        this.setValue();
    }

    public PropertyConfig(String name, String value) throws DataSourceConfigException {
        super(ROOT_NODE_NAME);
        this.setName(name);
        this.setValue(value);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) throws DataSourceConfigException {
        if (name == null || name.length() == 0) {
            throw new DataSourceConfigException("The property name may not be empty.");
        }
        this.m_name = name;
    }

    private void setName() throws DataSourceConfigException {
        this.setName(DataSourceConfigUtils.getAttribute(this.getRootNode(), NAME_ATTRIBUTE));
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this.m_value = value;
    }

    private void setValue() {
        this.setValue(DataSourceConfigUtils.getAttribute(this.getRootNode(), VALUE_ATTRIBUTE));
    }

    protected Node createXML(Document document) throws Exception {
        Element element = document.createElement(ROOT_NODE_NAME);
        element.setAttribute(NAME_ATTRIBUTE, this.getName());
        element.setAttribute(VALUE_ATTRIBUTE, this.getValue());
        return element;
    }
}

