/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import java.io.Serializable;
import oracle.oc4j.sql.config.DataSourceBaseConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import oracle.oc4j.sql.config.PropertyConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NativeDataSourceConfig
extends DataSourceBaseConfig
implements Cloneable,
Serializable {
    public static final String ROOT_NODE_NAME = "native-data-source";
    public static final String DATA_SOURCE_CLASS_ATTRIBUTE = "data-source-class";
    public static final String URL_ATTRIBUTE = "url";
    private String m_dataSourceClass = "";
    private String m_url = null;
    private PropertyConfig[] m_properties = new PropertyConfig[0];

    public NativeDataSourceConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        this.setDataSourceClass();
        this.setUrl();
        this.setProperties();
    }

    public NativeDataSourceConfig(String user, String password, String dataSourceClass, String jndiName, String name, String url, int loginTimeout, PropertyConfig[] properties) throws DataSourceConfigException {
        super(ROOT_NODE_NAME, user, password, jndiName, name, loginTimeout);
        this.setDataSourceClass(dataSourceClass);
        this.setUrl(url);
        this.setProperties(properties);
    }

    public NativeDataSourceConfig(NativeDataSourceConfig nativeDataSourceConfig) throws DataSourceConfigException {
        this(nativeDataSourceConfig.getUser(), nativeDataSourceConfig.getPassword(), nativeDataSourceConfig.getDataSourceClass(), nativeDataSourceConfig.getJndiName(), nativeDataSourceConfig.getName(), nativeDataSourceConfig.getUrl(), nativeDataSourceConfig.getLoginTimeout(), null);
        PropertyConfig[] oldProperties = nativeDataSourceConfig.getProperties();
        PropertyConfig[] newProperties = new PropertyConfig[oldProperties.length];
        for (int i = 0; i < oldProperties.length; ++i) {
            try {
                newProperties[i] = new PropertyConfig(oldProperties[i].getName(), oldProperties[i].getValue());
                continue;
            }
            catch (DataSourceConfigException e) {
                // empty catch block
            }
        }
        this.setProperties(newProperties);
    }

    public String getDataSourceClass() {
        return this.m_dataSourceClass;
    }

    public void setDataSourceClass(String dataSourceClass) throws DataSourceConfigException {
        this.m_dataSourceClass = DataSourceConfigUtils.trimEmptyNotAllowed(dataSourceClass, DATA_SOURCE_CLASS_ATTRIBUTE);
    }

    private void setDataSourceClass() throws DataSourceConfigException {
        this.setDataSourceClass(DataSourceConfigUtils.getAttribute(this.getRootNode(), DATA_SOURCE_CLASS_ATTRIBUTE));
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) throws DataSourceConfigException {
        this.m_url = DataSourceConfigUtils.trimEmptyNotAllowed(url, URL_ATTRIBUTE);
    }

    private void setUrl() throws DataSourceConfigException {
        this.setUrl(DataSourceConfigUtils.getAttribute(this.getRootNode(), URL_ATTRIBUTE));
    }

    public void addPropertyConfig(PropertyConfig propertyConfig) {
        if (DataSourceConfigUtils.doesPropertyExist(this.m_properties, propertyConfig)) {
            return;
        }
        PropertyConfig[] curProperties = new PropertyConfig[this.m_properties.length + 1];
        for (int i = 0; i < this.m_properties.length; ++i) {
            curProperties[i] = this.m_properties[i];
        }
        curProperties[this.m_properties.length] = propertyConfig;
        this.m_properties = curProperties;
    }

    public void removePropertyConfig(String propertyConfigName) {
        this.m_properties = DataSourceConfigUtils.removePropertyConfig(this.m_properties, propertyConfigName);
    }

    public PropertyConfig[] getProperties() {
        return this.m_properties;
    }

    public void setProperties(PropertyConfig[] properties) {
        if (properties == null) {
            properties = new PropertyConfig[]{};
        }
        this.m_properties = properties;
    }

    private void setProperties() throws DataSourceConfigException {
        this.setProperties(DataSourceConfigUtils.getPropertyConfigs(this.getRootNode(), "property"));
    }

    protected Node createXML(Document document) throws Exception {
        Element element = document.createElement(ROOT_NODE_NAME);
        if (this.getUser() != null) {
            element.setAttribute("user", this.getUser());
        }
        if (this.getPassword() != null) {
            element.setAttribute("password", this.getPassword());
        }
        element.setAttribute(URL_ATTRIBUTE, this.m_url);
        if (this.getLoginTimeout() != 0) {
            element.setAttribute("login-timeout", new Integer(this.getLoginTimeout()).toString());
        }
        element.setAttribute(DATA_SOURCE_CLASS_ATTRIBUTE, this.m_dataSourceClass);
        element.setAttribute("jndi-name", this.getJndiName());
        element.setAttribute("name", this.getName());
        for (int i = 0; i < this.m_properties.length; ++i) {
            element.appendChild(this.m_properties[i].createXML(document));
        }
        return element;
    }
}

