/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import com.evermind.xml.XMLUtils;
import java.util.Vector;
import oracle.oc4j.sql.config.ConfigObject;
import oracle.oc4j.sql.config.ConnectionPropertiesConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import oracle.oc4j.sql.config.ErrorCodeConfig;
import oracle.oc4j.sql.config.FatalErrorCodesConfig;
import oracle.oc4j.sql.config.PropertyConfig;
import oracle.oc4j.sql.config.ProxyInterfaceConfig;
import oracle.oc4j.sql.config.XARecoveryConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectionFactoryConfig
extends ConfigObject {
    public static final int DEFAULT_LOGIN_TIMEOUT = 0;
    public static final String ROOT_NODE_NAME = "connection-factory";
    public static final String FACTORY_CLASS_ATTRIBUTE = "factory-class";
    public static final String USER_ATTRIBUTE = "user";
    public static final String PASSWORD_ATTRIBUTE = "password";
    public static final String URL_ATTRIBUTE = "url";
    public static final String CR_TABLE_NAME_ATTRIBUTE = "commit-record-table-name";
    public static final String LOGIN_TIMEOUT_ATTRIBUTE = "login-timeout";
    private String m_factoryClass;
    private String m_user = null;
    private String m_password = null;
    private String m_url = null;
    private String m_commitRecordTableName = null;
    private int m_loginTimeout = 0;
    private PropertyConfig[] m_properties = new PropertyConfig[0];
    private ProxyInterfaceConfig[] m_proxyInterfaces = new ProxyInterfaceConfig[0];
    private XARecoveryConfig m_xaRecoveryConfig = null;
    private String m_dbLinkPropertyValue = null;
    private FatalErrorCodesConfig m_fatalErrorCodesConfig = new FatalErrorCodesConfig(new ErrorCodeConfig[0]);
    private ConnectionPropertiesConfig m_connectionPropeertiesConfig = new ConnectionPropertiesConfig(new PropertyConfig[0]);

    public ConnectionFactoryConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        if (DataSourceConfigUtils.usernameAttributeExists(rootNode)) {
            throw new DataSourceConfigException("The 'username' attribute is invalid...use 'user' instead.");
        }
        this.setFactoryClass();
        this.setUser();
        this.setPassword();
        this.setUrl();
        this.setCommitRecordTableName();
        this.setLoginTimeout();
        this.setProperties();
        this.setProxyInterfaces();
        this.setXARecoveryConfig();
        this.setFatalErrorCodesConfig();
        this.setConnectionPropertiesConfig();
    }

    public ConnectionFactoryConfig(ConnectionFactoryConfig config) throws DataSourceConfigException {
        super(ROOT_NODE_NAME);
        this.setFactoryClass(config.getFactoryClass());
        this.setUser(config.getUser());
        this.setPassword(config.getPassword());
        this.setUrl(config.getUrl());
        this.setCommitRecordTableName(config.getCommitRecordTableName());
        this.setLoginTimeout(config.getLoginTimeout());
        PropertyConfig[] properties = config.getProperties();
        int numProperties = config.getProperties().length;
        PropertyConfig[] newProperties = new PropertyConfig[numProperties];
        for (int i = 0; i < properties.length; ++i) {
            newProperties[i] = new PropertyConfig(properties[i].getName(), properties[i].getValue());
        }
        this.setProperties(newProperties);
        ProxyInterfaceConfig[] proxies = config.getProxyInterfaces();
        int numProxies = config.getProxyInterfaces().length;
        ProxyInterfaceConfig[] newProxies = new ProxyInterfaceConfig[numProxies];
        for (int i = 0; i < proxies.length; ++i) {
            newProxies[i] = new ProxyInterfaceConfig(proxies[i].getSqlObject(), proxies[i].getInterface());
        }
        this.setProxyInterfaces(newProxies);
        XARecoveryConfig xaRecoveryConfig = config.getXARecoveryConfig();
        if (xaRecoveryConfig == null) {
            this.m_xaRecoveryConfig = null;
        } else {
            XARecoveryConfig copiedXARecoveryConfig = new XARecoveryConfig(xaRecoveryConfig);
            this.setXARecoveryConfig(copiedXARecoveryConfig);
        }
        ErrorCodeConfig[] errorCodes = config.getFatalErrorCodesConfig().getErrorCodes();
        int numErrorCodes = errorCodes.length;
        ErrorCodeConfig[] newErrorCodes = new ErrorCodeConfig[numErrorCodes];
        for (int i = 0; i < numErrorCodes; ++i) {
            newErrorCodes[i] = new ErrorCodeConfig(errorCodes[i].getCode());
        }
        this.setFatalErrorCodesConfig(new FatalErrorCodesConfig(newErrorCodes));
        PropertyConfig[] connectionProperties = config.getConnectionPropertiesConfig().getProperties();
        int numConnectionProperties = connectionProperties.length;
        PropertyConfig[] newconnectionProperties = new PropertyConfig[numConnectionProperties];
        for (int i = 0; i < numConnectionProperties; ++i) {
            newconnectionProperties[i] = new PropertyConfig(connectionProperties[i].getName(), connectionProperties[i].getValue());
        }
        PropertyConfig[] copiedConnectionProperties = new PropertyConfig[connectionProperties.length];
        for (int i = 0; i < connectionProperties.length; ++i) {
            copiedConnectionProperties[i] = new PropertyConfig(connectionProperties[i].getName(), connectionProperties[i].getValue());
        }
        this.setConnectionPropertiesConfig(new ConnectionPropertiesConfig(copiedConnectionProperties));
    }

    public ConnectionFactoryConfig(String factoryClass, String user, String password, String url, int loginTimeout, PropertyConfig[] properties, ProxyInterfaceConfig[] proxies, XARecoveryConfig xaRecoveryConfig, FatalErrorCodesConfig fatalErrorCodesConfig, ConnectionPropertiesConfig connectionPropertiesConfig) throws DataSourceConfigException {
        super(ROOT_NODE_NAME);
        this.setFactoryClass(factoryClass);
        this.setUser(user);
        this.setPassword(password);
        this.setUrl(url);
        this.setLoginTimeout(loginTimeout);
        this.setProperties(properties);
        this.setProxyInterfaces(proxies);
        this.setXARecoveryConfig(xaRecoveryConfig);
        this.setFatalErrorCodesConfig(fatalErrorCodesConfig);
        this.setConnectionPropertiesConfig(connectionPropertiesConfig);
    }

    public String getFactoryClass() {
        return this.m_factoryClass;
    }

    public void setFactoryClass(String factoryClass) throws DataSourceConfigException {
        this.m_factoryClass = DataSourceConfigUtils.trimEmptyNotAllowed(factoryClass, FACTORY_CLASS_ATTRIBUTE);
    }

    private void setFactoryClass() throws DataSourceConfigException {
        this.setFactoryClass(DataSourceConfigUtils.getAttribute(this.getRootNode(), FACTORY_CLASS_ATTRIBUTE));
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    private void setUser() {
        this.setUser(XMLUtils.getNodeAttribute(this.getRootNode(), USER_ATTRIBUTE));
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    private void setPassword() {
        this.setPassword(XMLUtils.getNodeAttribute(this.getRootNode(), PASSWORD_ATTRIBUTE));
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) throws DataSourceConfigException {
        this.m_url = DataSourceConfigUtils.trimEmptyNotAllowed(url, URL_ATTRIBUTE);
    }

    private void setUrl() throws DataSourceConfigException {
        this.setUrl(DataSourceConfigUtils.getAttribute(this.getRootNode(), URL_ATTRIBUTE));
    }

    public String getCommitRecordTableName() {
        return this.m_commitRecordTableName;
    }

    public void setCommitRecordTableName(String commitRecordTableName) throws DataSourceConfigException {
        this.m_commitRecordTableName = commitRecordTableName;
    }

    private void setCommitRecordTableName() throws DataSourceConfigException {
        this.setCommitRecordTableName(DataSourceConfigUtils.getAttribute(this.getRootNode(), CR_TABLE_NAME_ATTRIBUTE));
    }

    public int getLoginTimeout() {
        return this.m_loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.m_loginTimeout = loginTimeout;
    }

    private void setLoginTimeout() throws DataSourceConfigException {
        this.setLoginTimeout(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), LOGIN_TIMEOUT_ATTRIBUTE, 0));
    }

    public PropertyConfig[] getProperties() {
        return this.m_properties;
    }

    public void addPropertyConfig(PropertyConfig propertyConfig) {
        if (DataSourceConfigUtils.doesPropertyExist(this.m_properties, propertyConfig)) {
            return;
        }
        PropertyConfig[] curProperties = new PropertyConfig[this.m_properties.length + 1];
        for (int i = 0; i < this.m_properties.length; ++i) {
            curProperties[i] = this.m_properties[i];
        }
        curProperties[this.m_properties.length] = propertyConfig;
        this.m_properties = curProperties;
        if (propertyConfig.getName().equalsIgnoreCase("dblink")) {
            this.setDbLinkPropertyValue(propertyConfig.getValue());
        }
    }

    public void removePropertyConfig(String propertyConfigName) {
        this.m_properties = DataSourceConfigUtils.removePropertyConfig(this.m_properties, propertyConfigName);
        if (propertyConfigName != null && propertyConfigName.equalsIgnoreCase("dblink")) {
            this.setDbLinkPropertyValue(null);
        }
    }

    public void setProperties(PropertyConfig[] properties) {
        if (properties == null) {
            properties = new PropertyConfig[]{};
        }
        this.m_properties = properties;
        boolean found = false;
        for (int i = 0; i < this.m_properties.length && !found; ++i) {
            if (!this.m_properties[i].getName().equalsIgnoreCase("dblink")) continue;
            this.setDbLinkPropertyValue(this.m_properties[i].getValue());
            found = true;
        }
    }

    private void setProperties() throws DataSourceConfigException {
        this.setProperties(DataSourceConfigUtils.getPropertyConfigs(this.getRootNode(), "property"));
    }

    public synchronized void addProxyInterfaceConfig(ProxyInterfaceConfig proxyInterfaceConfig) {
        if (proxyInterfaceConfig == null) {
            return;
        }
        String sqlObject = proxyInterfaceConfig.getSqlObject();
        String theInterface = proxyInterfaceConfig.getInterface();
        for (int i = 0; i < this.m_proxyInterfaces.length; ++i) {
            if (!this.m_proxyInterfaces[i].getSqlObject().equals(sqlObject) || !this.m_proxyInterfaces[i].getInterface().equals(theInterface)) continue;
            return;
        }
        ProxyInterfaceConfig[] newProxyInterfaces = new ProxyInterfaceConfig[this.m_proxyInterfaces.length + 1];
        System.arraycopy(this.m_proxyInterfaces, 0, newProxyInterfaces, 0, this.m_proxyInterfaces.length);
        newProxyInterfaces[this.m_proxyInterfaces.length] = proxyInterfaceConfig;
        this.m_proxyInterfaces = newProxyInterfaces;
    }

    public synchronized void removeProxyInterfaceConfig(String sqlObject, String theInterface) {
        if (sqlObject == null || theInterface == null) {
            return;
        }
        Vector<ProxyInterfaceConfig> vector = new Vector<ProxyInterfaceConfig>();
        for (int i = 0; i < this.m_proxyInterfaces.length; ++i) {
            if (this.m_proxyInterfaces[i].getSqlObject().equals(sqlObject) && this.m_proxyInterfaces[i].getInterface().equals(theInterface)) continue;
            vector.add(this.m_proxyInterfaces[i]);
        }
        int vectorSize = vector.size();
        this.m_proxyInterfaces = new ProxyInterfaceConfig[vectorSize];
        for (int i = 0; i < vectorSize; ++i) {
            this.m_proxyInterfaces[i] = (ProxyInterfaceConfig)vector.get(i);
        }
    }

    public ProxyInterfaceConfig[] getProxyInterfaces() {
        return this.m_proxyInterfaces;
    }

    public void setProxyInterfaces(ProxyInterfaceConfig[] proxyInterfaces) {
        if (proxyInterfaces == null) {
            proxyInterfaces = new ProxyInterfaceConfig[]{};
        }
        this.m_proxyInterfaces = proxyInterfaces;
    }

    public String getDbLinkPropertyValue() {
        return this.m_dbLinkPropertyValue;
    }

    public void setDbLinkPropertyValue(String dbLinkPropertyValue) {
        this.m_dbLinkPropertyValue = dbLinkPropertyValue;
    }

    private ProxyInterfaceConfig[] getProxyInterfacConfigs() throws DataSourceConfigException {
        Node parentNode = this.getRootNode();
        if (parentNode == null) {
            return new ProxyInterfaceConfig[0];
        }
        Vector<ProxyInterfaceConfig> proxies = new Vector<ProxyInterfaceConfig>();
        NodeList nodes = parentNode.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("proxy-interface")) continue;
                proxies.add(new ProxyInterfaceConfig(node));
            }
        }
        int numProxies = proxies.size();
        ProxyInterfaceConfig[] proxyConfigs = new ProxyInterfaceConfig[numProxies];
        for (int i = 0; i < numProxies; ++i) {
            proxyConfigs[i] = (ProxyInterfaceConfig)proxies.get(i);
        }
        return proxyConfigs;
    }

    private void setProxyInterfaces() throws DataSourceConfigException {
        this.setProxyInterfaces(this.getProxyInterfacConfigs());
    }

    public XARecoveryConfig getXARecoveryConfig() {
        return this.m_xaRecoveryConfig;
    }

    public void setXARecoveryConfig(XARecoveryConfig xaRecoveryConfig) {
        this.m_xaRecoveryConfig = xaRecoveryConfig;
    }

    private void setXARecoveryConfig() throws DataSourceConfigException {
        Node node = XMLUtils.getSubnode(this.getRootNode(), "xa-recovery-config");
        if (node == null) {
            this.m_xaRecoveryConfig = null;
        } else {
            this.setXARecoveryConfig(new XARecoveryConfig(node));
        }
    }

    public FatalErrorCodesConfig getFatalErrorCodesConfig() {
        return this.m_fatalErrorCodesConfig;
    }

    public void setFatalErrorCodesConfig(FatalErrorCodesConfig fatalErrorCodesConfig) {
        if (fatalErrorCodesConfig == null) {
            try {
                fatalErrorCodesConfig = new FatalErrorCodesConfig(new ErrorCodeConfig[0]);
            }
            catch (DataSourceConfigException dataSourceConfigException) {
                // empty catch block
            }
        }
        this.m_fatalErrorCodesConfig = fatalErrorCodesConfig;
    }

    private void setFatalErrorCodesConfig() throws DataSourceConfigException {
        Node node = XMLUtils.getSubnode(this.getRootNode(), "fatal-error-codes");
        if (node == null) {
            this.setFatalErrorCodesConfig(null);
        } else {
            this.setFatalErrorCodesConfig(new FatalErrorCodesConfig(node));
        }
    }

    public ConnectionPropertiesConfig getConnectionPropertiesConfig() {
        return this.m_connectionPropeertiesConfig;
    }

    public void setConnectionPropertiesConfig(ConnectionPropertiesConfig connectionPropertiesConfig) {
        if (connectionPropertiesConfig == null) {
            try {
                connectionPropertiesConfig = new ConnectionPropertiesConfig(new PropertyConfig[0]);
            }
            catch (DataSourceConfigException dataSourceConfigException) {
                // empty catch block
            }
        }
        this.m_connectionPropeertiesConfig = connectionPropertiesConfig;
    }

    private void setConnectionPropertiesConfig() throws DataSourceConfigException {
        Node node = XMLUtils.getSubnode(this.getRootNode(), "connection-properties");
        if (node == null) {
            this.setConnectionPropertiesConfig(null);
        } else {
            this.setConnectionPropertiesConfig(new ConnectionPropertiesConfig(node));
        }
    }

    protected Node createXML(Document document) throws Exception {
        int i;
        Element element = document.createElement(ROOT_NODE_NAME);
        element.setAttribute(FACTORY_CLASS_ATTRIBUTE, this.m_factoryClass);
        if (this.m_user != null) {
            element.setAttribute(USER_ATTRIBUTE, this.m_user);
        }
        if (this.m_password != null) {
            element.setAttribute(PASSWORD_ATTRIBUTE, this.m_password);
        }
        element.setAttribute(URL_ATTRIBUTE, this.m_url);
        if (this.m_commitRecordTableName != null) {
            element.setAttribute(CR_TABLE_NAME_ATTRIBUTE, this.m_commitRecordTableName);
        }
        if (this.getLoginTimeout() != 0) {
            element.setAttribute(LOGIN_TIMEOUT_ATTRIBUTE, new Integer(this.getLoginTimeout()).toString());
        }
        for (i = 0; i < this.m_properties.length; ++i) {
            element.appendChild(this.m_properties[i].createXML(document));
        }
        for (i = 0; i < this.m_proxyInterfaces.length; ++i) {
            element.appendChild(this.m_proxyInterfaces[i].createXML(document));
        }
        if (this.m_xaRecoveryConfig != null) {
            element.appendChild(this.m_xaRecoveryConfig.createXML(document));
        }
        if (this.m_fatalErrorCodesConfig.getErrorCodes().length > 0) {
            element.appendChild(this.m_fatalErrorCodesConfig.createXML(document));
        }
        if (this.m_connectionPropeertiesConfig.getProperties().length > 0) {
            element.appendChild(this.m_connectionPropeertiesConfig.createXML(document));
        }
        return element;
    }
}

