/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import com.evermind.server.Application;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.spi.ApplicationServerInternalException;
import oracle.dms.instrument.NounIntf;
import oracle.j2ee.connector.ConnectionPool;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.DataSourceConnectionFactory;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.ManagedDataSource;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import oracle.oc4j.sql.config.PropertyConfig;
import oracle.oc4j.sql.mbean.DMSJDBCConnectionPoolStats;
import oracle.oc4j.sql.mbean.DMSUtils;
import oracle.oc4j.sql.spi.ManagedConnectionFactoryImpl;
import oracle.oc4j.sql.spi.ResourceAdapterImpl;

public class DataSourceConnectionPoolImpl
implements DataSourceConnectionPool {
    public static final String OCCM_PROPERTY_NAME_ABANDONED_CONNECTION_TIMEOUT = "AbandonedConnectionTimeout";
    public static final String OCCM_PROPERTY_NAME_CONNECTION_WAIT_TIMEOUT = "ConnectionWaitTimeout";
    public static final String OCCM_PROPERTY_NAME_INACTIVITY_TIMEOUT = "InactivityTimeout";
    public static final String OCCM_PROPERTY_NAME_INITIAL_LIMIT = "InitialLimit";
    public static final String OCCM_PROPERTY_NAME_LOWER_THRESHOLD_LIMIT = "LowerThresholdLimit";
    public static final String OCCM_PROPERTY_NAME_MAX_LIMIT = "MaxLimit";
    public static final String OCCM_PROPERTY_NAME_MAX_STATEMENTS_LIMIT = "MaxStatementsLimit";
    public static final String OCCM_PROPERTY_NAME_MIN_LIMIT = "MinLimit";
    public static final String OCCM_PROPERTY_NAME_PROPERTY_CHECK_INTERVAL = "PropertyCheckInterval";
    public static final String OCCM_PROPERTY_NAME_TIME_TO_LIVE_TIMEOUT = "TimeToLiveTimeout";
    public static final String OCCM_PROPERTY_NAME_VALIDATE_CONNECTION = "ValidateConnection";
    private ConnectionPoolConfig m_config;
    private transient DataSourceConnectionFactory m_connectionFactory;
    private transient Object m_cacheManager = null;
    private boolean m_icc = false;
    private ConnectionPool m_connectorConnectionPool = null;
    private ResourceAdapterImpl m_resourceAdapter = null;
    private String m_applicationName = null;
    private DMSJDBCConnectionPoolStats m_dmsConnectionPoolStats = null;

    public DataSourceConnectionPoolImpl(ResourceAdapterImpl resourceAdapter, ConnectionPoolConfig config, String applicationName) throws IllegalArgumentException, DataSourceException, DataSourceConfigException {
        if (resourceAdapter == null) {
            String msg = DataSourceMessages.severeDataSourceConnectionPoolConstructorResourceAdapterNull();
            throw new IllegalArgumentException(msg);
        }
        this.m_resourceAdapter = resourceAdapter;
        if (config == null) {
            String msg = DataSourceMessages.severeDataSourceConnectionPoolConstructorConfigurationNull();
            throw new IllegalArgumentException(msg);
        }
        if (applicationName == null) {
            DataSourceMessages.warningDataSourceConnectionPoolConstructorAppNameNull();
            applicationName = "";
        }
        this.m_applicationName = applicationName;
        this.m_config = config;
        this.m_connectionFactory = DataSourceConfigUtils.createConnectionFactory(config.getConnectionFactoryConfig(), this.m_resourceAdapter.getClassLoaderForProxyCreation());
        this.initConnectionCache();
        if (DMSUtils.isDMSActive()) {
            this.m_dmsConnectionPoolStats = new DMSJDBCConnectionPoolStats(Application.getApplicationNoun(applicationName), this);
        }
    }

    private void initConnectionCache() throws DataSourceException {
        block16: {
            Object object = this.getConnectionFactory().getConnectionFactory();
            if (DataSourceUtils.isClass(object.getClass(), "oracle.jdbc.pool.OracleDataSource")) {
                try {
                    if (!object.getClass().getField("isOracleDataSource").getBoolean(object)) break block16;
                    try {
                        PropertyConfig[] factoryProperties = this.m_config.getConnectionFactoryConfig().getProperties();
                        String propertyValue = DataSourceConfigUtils.getPropertyValue(factoryProperties, "connectionCachingEnabled", "true");
                        boolean connectionCachingEnabled = new Boolean(propertyValue);
                        if (!connectionCachingEnabled) {
                            return;
                        }
                        try {
                            Class[] paramTypes = new Class[]{Boolean.TYPE};
                            Object[] args = new Object[]{new Boolean(true)};
                            object.getClass().getMethod("setConnectionCachingEnabled", paramTypes).invoke(object, args);
                        }
                        catch (NoSuchMethodException sqlException) {
                            return;
                        }
                        Class[] paramTypes1 = new Class[]{};
                        Object[] args1 = new Object[]{};
                        if (((Boolean)object.getClass().getMethod("getConnectionCachingEnabled", paramTypes1).invoke(object, args1)).booleanValue()) {
                            Class<?> OracleConnectionCacheManagerClass = Class.forName("oracle.jdbc.pool.OracleConnectionCacheManager", true, object.getClass().getClassLoader());
                            Class[] paramTypes2 = new Class[]{};
                            Object[] args2 = new Object[]{};
                            this.m_cacheManager = OracleConnectionCacheManagerClass.getMethod("getConnectionCacheManagerInstance", paramTypes2).invoke(null, args2);
                            Properties properties = new Properties();
                            properties.setProperty(OCCM_PROPERTY_NAME_MAX_LIMIT, String.valueOf(this.m_config.getMaxConnections()));
                            properties.setProperty(OCCM_PROPERTY_NAME_MAX_STATEMENTS_LIMIT, String.valueOf(this.m_config.getNumCachedStatements()));
                            properties.setProperty(OCCM_PROPERTY_NAME_MIN_LIMIT, String.valueOf(this.m_config.getMinConnections()));
                            properties.setProperty(OCCM_PROPERTY_NAME_INACTIVITY_TIMEOUT, String.valueOf(this.m_config.getInactivityTimeout()));
                            properties.setProperty(OCCM_PROPERTY_NAME_LOWER_THRESHOLD_LIMIT, String.valueOf(this.m_config.getLowerThresholdLimit()));
                            properties.setProperty(OCCM_PROPERTY_NAME_TIME_TO_LIVE_TIMEOUT, String.valueOf(this.m_config.getTimeToLiveTimeout()));
                            properties.setProperty(OCCM_PROPERTY_NAME_ABANDONED_CONNECTION_TIMEOUT, String.valueOf(this.m_config.getAbandonedConnectionTimeout()));
                            properties.setProperty(OCCM_PROPERTY_NAME_PROPERTY_CHECK_INTERVAL, String.valueOf(this.m_config.getPropertyCheckInterval()));
                            properties.setProperty(OCCM_PROPERTY_NAME_CONNECTION_WAIT_TIMEOUT, String.valueOf(this.m_config.getUsedConnectionWaitTimeout()));
                            properties.setProperty(OCCM_PROPERTY_NAME_VALIDATE_CONNECTION, String.valueOf(this.m_config.isValidateConnection() && (this.m_config.getValidateConnectionStatement() == null || this.m_config.getValidateConnectionStatement().length() == 0)));
                            Class<?> OracleDataSourceClass = Class.forName("oracle.jdbc.pool.OracleDataSource", true, object.getClass().getClassLoader());
                            Class[] paramTypes = new Class[]{String.class, OracleDataSourceClass, Properties.class};
                            Object[] args = new Object[]{this.getCacheName(), object, properties};
                            this.m_cacheManager.getClass().getMethod("createCache", paramTypes).invoke(this.m_cacheManager, args);
                            this.m_icc = true;
                        }
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (IllegalAccessException e) {
                        throw new DataSourceException("Could not get/create instance of ConnectionCacheManager.  Exception: " + e.getMessage(), e);
                    }
                    catch (InvocationTargetException e) {
                        throw new DataSourceException("Could not get/create instance of ConnectionCacheManager.  Exception: " + e.getCause().getMessage(), e.getCause());
                    }
                    Properties properties = new Properties();
                    properties.setProperty(OCCM_PROPERTY_NAME_INITIAL_LIMIT, String.valueOf(this.m_config.getInitialLimit()));
                    Class[] paramTypes2 = new Class[]{String.class, Properties.class};
                    Object[] args2 = new Object[]{this.getCacheName(), properties};
                    try {
                        this.m_cacheManager.getClass().getMethod("reinitializeCache", paramTypes2).invoke(this.m_cacheManager, args2);
                    }
                    catch (Exception e) {
                        DataSourceMessages.warningDataSourceConnectionPoolSetCacheManagerProperty(OCCM_PROPERTY_NAME_INITIAL_LIMIT, e);
                    }
                }
                catch (DataSourceException e) {
                    throw e;
                }
                catch (IllegalAccessException e) {
                    throw new DataSourceException("Could not initialize Connection Cache.  Exception: " + e.getMessage(), e);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
    }

    public String getCacheName() {
        return this.m_config.getName() + "_" + this.m_applicationName;
    }

    public Object getCacheManager() {
        return this.m_cacheManager;
    }

    protected void setCacheMananger(Object cacheManager) {
        this.m_cacheManager = cacheManager;
    }

    public boolean isICC() {
        return this.m_icc;
    }

    public ConnectionPoolConfig getConfig() {
        return this.m_config;
    }

    public DataSourceConnectionFactory getConnectionFactory() {
        return this.m_connectionFactory;
    }

    public String getName() {
        return this.m_config.getName();
    }

    public int getMinConnections() throws DataSourceException {
        return this.m_config.getMinConnections();
    }

    public void setMinConnections(int minConnections) throws DataSourceException {
        if (this.m_icc) {
            this.setCacheManagerProperty(OCCM_PROPERTY_NAME_MIN_LIMIT, String.valueOf(minConnections));
        } else if (this.m_connectorConnectionPool != null) {
            try {
                this.m_connectorConnectionPool.setMinConnections(minConnections);
            }
            catch (ApplicationServerInternalException asie) {
                String msg = DataSourceMessages.warningDataSourceConnectionPoolSetMinConnections((Exception)((Object)asie));
                throw new DataSourceException(msg, asie);
            }
        }
        this.m_config.setMinConnections(minConnections);
    }

    public int getMaxConnections() throws DataSourceException {
        return this.m_config.getMaxConnections();
    }

    public void setMaxConnections(int maxConnections) throws DataSourceException {
        if (this.m_icc) {
            this.setCacheManagerProperty(OCCM_PROPERTY_NAME_MAX_LIMIT, String.valueOf(maxConnections));
        } else if (this.m_connectorConnectionPool != null) {
            try {
                this.m_connectorConnectionPool.setMaxConnections(maxConnections);
            }
            catch (ApplicationServerInternalException asie) {
                String msg = DataSourceMessages.warningDataSourceConnectionPoolSetMaxConnections((Exception)((Object)asie));
                throw new DataSourceException(msg, asie);
            }
        }
        this.m_config.setMaxConnections(maxConnections);
    }

    public int getInitialLimit() throws DataSourceException {
        return this.m_config.getInitialLimit();
    }

    public void setInitialLimit(int limit) throws DataSourceException {
        if (this.m_icc) {
            this.setCacheManagerProperty(OCCM_PROPERTY_NAME_INITIAL_LIMIT, String.valueOf(limit));
        } else if (this.m_connectorConnectionPool != null) {
            try {
                this.m_connectorConnectionPool.setInitialCapacity(limit);
            }
            catch (ApplicationServerInternalException asie) {
                String msg = DataSourceMessages.warningDataSourceConnectionPoolSetInitialCapacity((Exception)((Object)asie));
                throw new DataSourceException(msg, asie);
            }
        }
        this.m_config.setInitialLimit(limit);
    }

    public int getUsedConnectionWaitTimeout() throws DataSourceException {
        return this.m_config.getUsedConnectionWaitTimeout();
    }

    public void setUsedConnectionWaitTimeout(int timeout) throws DataSourceException {
        if (this.m_icc) {
            this.setCacheManagerProperty(OCCM_PROPERTY_NAME_CONNECTION_WAIT_TIMEOUT, String.valueOf(timeout));
        } else if (this.m_connectorConnectionPool != null) {
            try {
                this.m_connectorConnectionPool.setWaitTimeout(timeout);
            }
            catch (ApplicationServerInternalException e) {
                String msg = DataSourceMessages.warningDataSourceConnectionPoolSetUsedConnectionWaitTimeout((Exception)((Object)e));
                throw new DataSourceException(msg, e);
            }
        }
        this.m_config.setUsedConnectionWaitTimeout(timeout);
    }

    public int getInactivityTimeout() throws DataSourceException {
        return this.m_config.getInactivityTimeout();
    }

    public void setInactivityTimeout(int timeout) throws DataSourceException {
        if (this.m_icc) {
            this.setCacheManagerProperty(OCCM_PROPERTY_NAME_INACTIVITY_TIMEOUT, String.valueOf(timeout));
        } else if (this.m_connectorConnectionPool != null) {
            try {
                this.m_connectorConnectionPool.setInactivityTimeout(timeout);
            }
            catch (ApplicationServerInternalException e) {
                String msg = DataSourceMessages.warningDataSourceConnectionPoolSetInactivityTimeout((Exception)((Object)e));
                throw new DataSourceException(msg, e);
            }
        }
        this.m_config.setInactivityTimeout(timeout);
    }

    public int getLowerThresholdLimit() throws DataSourceException {
        return this.m_config.getLowerThresholdLimit();
    }

    public void setLowerThresholdLimit(int lowerThresholdLimit) throws DataSourceException {
        if (!this.m_icc) {
            throw new DataSourceException("This method is not supported.");
        }
        this.setCacheManagerProperty(OCCM_PROPERTY_NAME_LOWER_THRESHOLD_LIMIT, String.valueOf(lowerThresholdLimit));
        this.m_config.setLowerThresholdLimit(lowerThresholdLimit);
    }

    public int getConnectionRetryInterval() throws DataSourceException {
        return this.m_config.getConnectionRetryInterval();
    }

    public synchronized void setConnectionRetryInterval(int interval) throws DataSourceException {
        this.m_config.setConnectionRetryInterval(interval);
        ManagedConnectionFactoryImpl[] managedConnectionFactories = this.m_resourceAdapter.getConnectionPoolConnectionFactories(this.getName());
        for (int i = 0; i < managedConnectionFactories.length; ++i) {
            ManagedDataSource managedDataSource = managedConnectionFactories[i].getManagedDataSource();
            if (managedDataSource == null) continue;
            managedDataSource.setConnectionRetryInterval(interval);
        }
    }

    public int getMaxConnectAttempts() throws DataSourceException {
        return this.m_config.getMaxConnectAttempts();
    }

    public void setMaxConnectAttempts(int attempts) throws DataSourceException {
        this.m_config.setMaxConnectAttempts(attempts);
        ManagedConnectionFactoryImpl[] managedConnectionFactories = this.m_resourceAdapter.getConnectionPoolConnectionFactories(this.getName());
        for (int i = 0; i < managedConnectionFactories.length; ++i) {
            ManagedDataSource managedDataSource = managedConnectionFactories[i].getManagedDataSource();
            if (managedDataSource == null) continue;
            managedDataSource.setMaxConnectAttempts(attempts);
        }
    }

    public boolean getValidateConnection() throws DataSourceException {
        return this.m_config.isValidateConnection();
    }

    public void setValidateConnection(boolean validate) throws DataSourceException {
        if (!this.m_icc) {
            throw new DataSourceException("This method is not supported.");
        }
        this.setCacheManagerProperty(OCCM_PROPERTY_NAME_VALIDATE_CONNECTION, String.valueOf(validate));
        this.m_config.setValidateConnection(validate);
    }

    public int getNumCachedStatements() throws DataSourceException {
        return this.m_config.getNumCachedStatements();
    }

    public void setNumCachedStatements(int numStatements) throws DataSourceException {
        if (this.m_icc) {
            this.setCacheManagerProperty(OCCM_PROPERTY_NAME_MAX_STATEMENTS_LIMIT, String.valueOf(numStatements));
        }
        this.m_config.setNumCachedStatements(numStatements);
    }

    public int getTimeToLiveTimeout() throws DataSourceException {
        return this.m_config.getTimeToLiveTimeout();
    }

    public void setTimeToLiveTimeout(int timeout) throws DataSourceException {
        if (!this.m_icc) {
            throw new DataSourceException("This method is not supported.");
        }
        this.setCacheManagerProperty(OCCM_PROPERTY_NAME_TIME_TO_LIVE_TIMEOUT, String.valueOf(timeout));
        this.m_config.setTimeToLiveTimeout(timeout);
    }

    public int getAbandonedConnectionTimeout() throws DataSourceException {
        return this.m_config.getAbandonedConnectionTimeout();
    }

    public void setAbandonedConnectionTimeout(int timeout) throws DataSourceException {
        if (!this.m_icc) {
            throw new DataSourceException("This method is not supported.");
        }
        this.setCacheManagerProperty(OCCM_PROPERTY_NAME_ABANDONED_CONNECTION_TIMEOUT, String.valueOf(timeout));
        this.m_config.setAbandonedConnectionTimeout(timeout);
    }

    public int getPropertyCheckInterval() throws DataSourceException {
        return this.m_config.getPropertyCheckInterval();
    }

    public void setPropertyCheckInterval(int interval) throws DataSourceException {
        if (!this.m_icc) {
            throw new DataSourceException("This method is not supported.");
        }
        this.setCacheManagerProperty(OCCM_PROPERTY_NAME_PROPERTY_CHECK_INTERVAL, String.valueOf(interval));
        this.m_config.setPropertyCheckInterval(interval);
    }

    public String getFactoryClass() throws DataSourceException {
        return this.m_connectionFactory.getConnectionFactoryConfig().getFactoryClass();
    }

    public String getUser() throws DataSourceException {
        return this.m_connectionFactory.getConnectionFactoryConfig().getUser();
    }

    public void setUser(String user) throws DataSourceException {
        DataSourceUtils.setUser(this.m_connectionFactory.getConnectionFactory(), user);
        this.m_connectionFactory.getConnectionFactoryConfig().setUser(user);
    }

    public String getPassword() throws DataSourceException {
        return this.m_connectionFactory.getConnectionFactoryConfig().getPassword();
    }

    public void setPassword(String password) throws DataSourceException {
        DataSourceUtils.setPassword(this.m_connectionFactory.getConnectionFactory(), password);
        this.m_connectionFactory.getConnectionFactoryConfig().setPassword(password);
    }

    public String getUrl() throws DataSourceException {
        return this.m_connectionFactory.getConnectionFactoryConfig().getUrl();
    }

    public void setUrl(String url) throws DataSourceException, DataSourceConfigException {
        DataSourceUtils.setUrl(this.m_connectionFactory.getConnectionFactory(), url);
        this.m_connectionFactory.getConnectionFactoryConfig().setUrl(url);
    }

    private void setCacheManagerProperty(String key, String value) throws DataSourceException {
        Properties properties = new Properties();
        properties.setProperty(key, value);
        try {
            Class[] paramTypes = new Class[]{String.class, Properties.class};
            Object[] args = new Object[]{this.getCacheName(), properties};
            this.m_cacheManager.getClass().getMethod("reinitializeCache", paramTypes).invoke(this.m_cacheManager, args);
        }
        catch (Exception e) {
            String msg = DataSourceMessages.warningDataSourceConnectionPoolSetCacheManagerProperty(key, e);
            throw new DataSourceException(msg, e);
        }
    }

    public void refreshConnectionPool() throws DataSourceException {
        if (this.m_icc) {
            try {
                Class<?> OracleConnectionCacheManagerClass = Class.forName("oracle.jdbc.pool.OracleConnectionCacheManager", true, this.m_cacheManager.getClass().getClassLoader());
                int refreshAllConnections = OracleConnectionCacheManagerClass.getField("REFRESH_ALL_CONNECTIONS").getInt(null);
                Class[] paramTypes = new Class[]{String.class, Integer.TYPE};
                Object[] args = new Object[]{this.getCacheName(), new Integer(refreshAllConnections)};
                this.m_cacheManager.getClass().getMethod("refreshCache", paramTypes).invoke(this.m_cacheManager, args);
            }
            catch (Exception e) {
                String msg = DataSourceMessages.warningDataSourceConnectionPoolRefreshConnectionPool(e);
                throw new DataSourceException(msg, e);
            }
        } else if (this.m_connectorConnectionPool != null) {
            this.m_connectorConnectionPool.purgeCandidateSet();
        }
    }

    public String testConnection(String sqlStatement) {
        return this.m_connectionFactory.testConnection(sqlStatement);
    }

    public String testConnection(String sqlStatement, String user, String password) {
        return this.m_connectionFactory.testConnection(sqlStatement, user, password);
    }

    public ConnectionPool getConnectorConnectionPool() {
        return this.m_connectorConnectionPool;
    }

    public void setConnectorConnectionPool(ConnectionPool connectorConnectionPool) {
        this.m_connectorConnectionPool = connectorConnectionPool;
    }

    public ResourceAdapterImpl getResourceAdapter() {
        return this.m_resourceAdapter;
    }

    public void stop() {
        NounIntf noun;
        Object object = this.getConnectionFactory().getConnectionFactory();
        if (DataSourceUtils.isClass(object.getClass(), "oracle.jdbc.pool.OracleDataSource")) {
            try {
                Class[] paramTypes = new Class[]{};
                Object[] args = new Object[]{};
                object.getClass().getMethod("close", paramTypes).invoke(object, args);
            }
            catch (Exception e) {
                DataSourceMessages.warningDataSourceConnectionPoolStopOracleDataSource(e);
            }
        }
        if (this.m_dmsConnectionPoolStats != null && (noun = this.m_dmsConnectionPoolStats.getDmsNoun()) != null) {
            noun.destroy();
        }
    }

    public long getNumAvailableConnections() throws SQLException {
        if (this.isICC()) {
            try {
                Class[] paramTypes = new Class[]{String.class};
                Object[] args = new Object[]{this.getCacheName()};
                return ((Integer)this.m_cacheManager.getClass().getMethod("getNumberOfAvailableConnections", paramTypes).invoke(this.m_cacheManager, args)).longValue();
            }
            catch (Exception e) {
                SQLException se = new SQLException(e.toString());
                se.initCause(e);
                throw se;
            }
        }
        if (this.m_connectorConnectionPool != null) {
            return this.m_connectorConnectionPool.getFreePoolSize();
        }
        return 0L;
    }

    public long getNumUsedConnections() throws SQLException {
        if (this.isICC()) {
            try {
                Class[] paramTypes = new Class[]{String.class};
                Object[] args = new Object[]{this.getCacheName()};
                return ((Integer)this.m_cacheManager.getClass().getMethod("getNumberOfActiveConnections", paramTypes).invoke(this.m_cacheManager, args)).longValue();
            }
            catch (Exception e) {
                SQLException se = new SQLException(e.toString());
                se.initCause(e);
                throw se;
            }
        }
        if (this.m_connectorConnectionPool != null) {
            return this.m_connectorConnectionPool.getInUsePoolSize();
        }
        return 0L;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public void connectionCreated() {
        if (this.m_dmsConnectionPoolStats != null && !this.m_icc) {
            this.m_dmsConnectionPoolStats.connectionCreated();
        }
    }

    public void connectionClosed() {
        if (this.m_dmsConnectionPoolStats != null && !this.m_icc) {
            this.m_dmsConnectionPoolStats.connectionClosed();
        }
    }

    public void updateDMSStats() {
        if (this.m_dmsConnectionPoolStats != null) {
            this.m_dmsConnectionPoolStats.updateDMSStats();
        }
    }

    public void incrementUseTime(long useTime) {
        if (this.m_dmsConnectionPoolStats != null) {
            this.m_dmsConnectionPoolStats.incrementUseTime(useTime);
        }
    }

    public DMSJDBCConnectionPoolStats getDMSStats() {
        return this.m_dmsConnectionPoolStats;
    }

    public String getGlobalInstanceName() {
        return this.m_config.getGlobalInstanceName();
    }
}

