/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.PooledConnectionImpl;

public class DataSourceConnectionPoolDataSource
implements ConnectionPoolDataSource {
    private DataSource m_dataSource = null;

    public DataSourceConnectionPoolDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("The DataSource can not be null.");
        }
        this.m_dataSource = dataSource;
    }

    public PooledConnection getPooledConnection() throws SQLException {
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
            DataSourceMessages.debugBeforeGetConnection(this.m_dataSource);
        }
        Connection connection = this.m_dataSource.getConnection();
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
            DataSourceMessages.debugAfterGetConnection(this.m_dataSource);
        }
        if (connection == null) {
            throw new SQLException("Unable to get a physical connection from the database...there are no connections available.");
        }
        return new PooledConnectionImpl(connection);
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
            DataSourceMessages.debugBeforeGetConnection(this.m_dataSource);
        }
        Connection connection = this.m_dataSource.getConnection(user, password);
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
            DataSourceMessages.debugAfterGetConnection(this.m_dataSource);
        }
        if (connection == null) {
            throw new SQLException("The data source returned null from getConnection(user,password).");
        }
        return new PooledConnectionImpl(connection);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.m_dataSource.setLogWriter(logWriter);
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.m_dataSource.setLoginTimeout(loginTimeout);
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_dataSource.getLoginTimeout();
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }
}

