/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import javax.security.auth.Subject;

public abstract class Security {
    private static Security s_instance;

    protected static Security getImpl() throws SecurityException {
        if (null == s_instance) {
            Security.internalError();
        }
        return s_instance;
    }

    protected static void setImpl(Security impl) throws SecurityException {
        s_instance = impl;
    }

    static void internalError() throws SecurityException {
        throw new SecurityException("security sub-system not available");
    }

    protected abstract Subject getSubject_() throws SecurityException;

    protected abstract void setSubject_(Subject var1, Longevity var2) throws SecurityException;

    public static Subject getSubject() throws SecurityException {
        return Security.getImpl().getSubject_();
    }

    public static void setSubject(Subject subject) throws SecurityException {
        Security.setSubject(subject, Longevity.REQUEST);
    }

    public static void setSubject(Subject subject, Longevity longevity) throws SecurityException {
        Security.getImpl().setSubject_(subject, longevity);
    }

    public static class Longevity {
        public static final Longevity REQUEST = new Longevity(1, "REQUEST");
        public static final Longevity SESSION = new Longevity(2, "SESSION");
        private final int m_longevity;
        private final String m_name;

        private Longevity(int longevity, String name) {
            this.m_longevity = longevity;
            this.m_name = name;
        }

        public int getValue() {
            return this.m_longevity;
        }

        public String toString() {
            return this.m_name;
        }

        public int hashCode() {
            return this.getValue();
        }

        public boolean equals(Object another) {
            if (!(another instanceof Longevity)) {
                return false;
            }
            return this.getValue() == ((Longevity)another).getValue();
        }
    }
}

