/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import com.evermind.util.SecurityProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import oracle.oc4j.security.DelegatingSecurityManager;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JRuntimePermission;
import oracle.oc4j.security.OC4JSecurityStrategy;
import oracle.oc4j.security.OC4JSecurityStrategyInternalCaller;
import oracle.oc4j.security.OC4JSecurityStrategyInternalPermissions;

public final class OC4JSecurity
implements OC4JSecurityStrategy {
    public static final int SECURITY_LEVEL_LOW = 0;
    public static final int SECURITY_LEVEL_MEDIUM = 1;
    public static final int SECURITY_LEVEL_HIGH = 2;
    public static final String TAG_SECURITY_LEVEL_LOW = "low";
    public static final String TAG_SECURITY_LEVEL_MEDIUM = "medium";
    public static final String TAG_SECURITY_LEVEL_HIGH = "high";
    static final Logger s_logger = Logger.getLogger(OC4JSecurity.class.toString());
    private static final Permission INTERNAL_PERMISSION = OC4JSecurity.getRuntimePermission("OC4JOnly");
    private static final DelegatingSecurityManager s_dsm = new DelegatingSecurityManager(null);
    private static final OC4JSecurityStrategy s_strategyInternalCaller = new OC4JSecurityStrategyInternalCaller(s_dsm, OC4JSecurity.class);
    private static final OC4JSecurityStrategy s_strategyInternalPermissions = new OC4JSecurityStrategyInternalPermissions(OC4JSecurity.s_shouldDefaultToUseAccessController());
    private static final int s_securityLevel = OC4JSecurity.getSystemSecurityLevel();
    private static final OC4JSecurity s_singleton = new OC4JSecurity(s_strategyInternalCaller, s_strategyInternalPermissions, s_securityLevel);
    private OC4JSecurityStrategy m_strategyInternalCaller = s_strategyInternalCaller;
    private OC4JSecurityStrategy m_strategyInternalPermissions = s_strategyInternalPermissions;
    private int m_securityLevel = 0;
    private final boolean m_isSecurityOn = OC4JSecurity.determineIsSecurityOn();

    public OC4JSecurity(OC4JSecurityStrategy strategyInternalCaller, OC4JSecurityStrategy strategyInternalPermissions, int securityLevel) {
        this.m_strategyInternalCaller = strategyInternalCaller;
        this.m_strategyInternalPermissions = strategyInternalPermissions;
        this.m_securityLevel = securityLevel;
    }

    public static OC4JSecurity getInstance() {
        return s_singleton;
    }

    static SecurityManager getSecurityManager() {
        return System.getSecurityManager();
    }

    static int getSystemSecurityLevel() {
        String systemPropVal = SecurityProperties.getOracleOc4jSecurityLevel();
        if (null != systemPropVal) {
            if (systemPropVal.equalsIgnoreCase(TAG_SECURITY_LEVEL_HIGH)) {
                return 2;
            }
            if (systemPropVal.equalsIgnoreCase(TAG_SECURITY_LEVEL_MEDIUM)) {
                return 1;
            }
        }
        return 0;
    }

    public int getSecurityLevel() {
        return this.m_securityLevel;
    }

    static boolean s_shouldDefaultToUseAccessController() {
        int secLevel = 2;
        if (OC4JSecurity.determineIsSecurityOn()) {
            try {
                Object obj = OC4JSecurity.internalDoPrivileged(new OC4JPrivilegedAction(){

                    public Object oc4jRun() {
                        return new Integer(OC4JSecurity.getSystemSecurityLevel());
                    }
                });
                secLevel = (Integer)obj;
            }
            catch (Exception e) {
                s_logger.throwing(OC4JSecurity.class.getName(), "s_shouldDefaultToUseAccessController()", e);
            }
        } else {
            secLevel = OC4JSecurity.getSystemSecurityLevel();
        }
        return secLevel >= 1;
    }

    boolean shouldCheckCallStackContext() {
        return this.getSecurityLevel() >= 1;
    }

    static SecurityManager getEnforcingSecurityManager() {
        SecurityManager sm = OC4JSecurity.getSecurityManager();
        if (null == sm) {
            return null;
        }
        if (sm instanceof DelegatingSecurityManager) {
            return ((DelegatingSecurityManager)sm).getUnderlying();
        }
        return sm;
    }

    public static OC4JRuntimePermission getRuntimePermission(String name) {
        return new OC4JRuntimePermission("oracle.oc4j." + name);
    }

    public static void checkInternalPermissions() {
        OC4JSecurity.checkPermission(INTERNAL_PERMISSION);
    }

    public static void checkPermission(Permission permission) {
        OC4JSecurity.checkPermission(permission, false);
    }

    static void checkPermission(Permission permission, boolean defaultToUseAccessController) {
        SecurityManager sm = OC4JSecurity.getEnforcingSecurityManager();
        if (null != sm) {
            OC4JSecurity.checkSecurityManagerPermission(sm, permission);
        } else if (defaultToUseAccessController) {
            OC4JSecurity.checkAccessControllerPermission(permission);
        }
    }

    static void checkSecurityManagerPermission(SecurityManager sm, Permission permission) {
        sm.checkPermission(permission);
    }

    static void checkAccessControllerPermission(Permission permission) {
        AccessController.checkPermission(permission);
    }

    public static boolean isSecurityOn() {
        return OC4JSecurity.getInstance().getIsSecurityOn();
    }

    private boolean getIsSecurityOn() {
        return this.m_isSecurityOn;
    }

    public static boolean determineIsSecurityOn() {
        return null != OC4JSecurity.getEnforcingSecurityManager();
    }

    boolean isSecurityChecksApplicable() {
        if (this.getIsSecurityOn()) {
            return true;
        }
        return this.shouldCheckCallStackContext();
    }

    public static boolean isUnsafe() {
        boolean safe = OC4JSecurity.getInstance().isSafeContext();
        return !safe;
    }

    public static void assertIsSafe() {
        OC4JSecurity.getInstance().assertIsSafeContext();
    }

    private static Object internalDoPrivileged(OC4JPrivilegedAction action) throws Exception {
        return AccessController.doPrivileged(action);
    }

    public static Object doPrivileged(OC4JPrivilegedAction action) throws Exception {
        if (!OC4JSecurity.isSecurityOn()) {
            return action.oc4jRun();
        }
        OC4JSecurity.assertIsSafe();
        return OC4JSecurity.internalDoPrivileged(action);
    }

    public static Object doPrivileged(OC4JPrivilegedAction.NoException action) {
        try {
            return OC4JSecurity.doPrivileged((OC4JPrivilegedAction)action);
        }
        catch (Throwable t) {
            s_logger.throwing(OC4JSecurity.class.toString(), "doPrivileged()", t);
            return null;
        }
    }

    public static Object doPrivileged(OC4JPrivilegedAction.WithIOException action) {
        try {
            return OC4JSecurity.doPrivileged((OC4JPrivilegedAction)action);
        }
        catch (Throwable t) {
            s_logger.throwing(OC4JSecurity.class.toString(), "doPrivileged()", t);
            return null;
        }
    }

    public static Object doUnprivileged(PrivilegedExceptionAction action) throws PrivilegedActionException {
        Object result;
        try {
            result = action.run();
        }
        catch (Exception ex) {
            throw new PrivilegedActionException(ex);
        }
        return result;
    }

    public static FileOutputStream newFileOutputStream(File file) throws IOException {
        return OC4JSecurity.newFileOutputStream(file, false);
    }

    public static FileOutputStream newFileOutputStream(final File file, final boolean append) throws FileNotFoundException {
        if (!OC4JSecurity.isSecurityOn()) {
            return new FileOutputStream(file, append);
        }
        OC4JSecurity.assertIsSafe();
        return (FileOutputStream)OC4JSecurity.doPrivileged(new OC4JPrivilegedAction.WithIOException(){

            public Object oc4jRun() throws IOException {
                return new FileOutputStream(file, append);
            }
        });
    }

    public static FileInputStream newFileInputStream(final File file) throws IOException {
        if (!OC4JSecurity.isSecurityOn()) {
            return new FileInputStream(file);
        }
        OC4JSecurity.assertIsSafe();
        return (FileInputStream)OC4JSecurity.doPrivileged(new OC4JPrivilegedAction.WithIOException(){

            public Object oc4jRun() throws IOException {
                return new FileInputStream(file);
            }
        });
    }

    public static OutputStream getOutputStream(final URLConnection connection) throws IOException {
        if (!OC4JSecurity.isSecurityOn()) {
            return connection.getOutputStream();
        }
        OC4JSecurity.assertIsSafe();
        return (OutputStream)OC4JSecurity.doPrivileged(new OC4JPrivilegedAction.WithIOException(){

            public Object oc4jRun() throws IOException {
                return connection.getOutputStream();
            }
        });
    }

    public static boolean exists(final File file) throws IOException {
        if (!OC4JSecurity.isSecurityOn()) {
            return file.exists();
        }
        OC4JSecurity.assertIsSafe();
        return (Boolean)OC4JSecurity.doPrivileged(new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                return file.exists();
            }
        });
    }

    public static String getProperty(final String key) {
        if (OC4JSecurity.isSecurityOn()) {
            try {
                String val = (String)OC4JSecurity.internalDoPrivileged(new OC4JPrivilegedAction(){

                    public Object oc4jRun() {
                        return System.getProperty(key);
                    }
                });
                return val;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return System.getProperty(key);
    }

    public void assertIsSafeContext() {
        boolean safe = this.isSafeContext();
        if (!safe) {
            this.m_strategyInternalPermissions.assertIsSafeContext();
        }
    }

    public boolean isSafeContext() {
        if (!this.isSecurityChecksApplicable()) {
            return true;
        }
        return this.m_strategyInternalCaller.isSafeContext();
    }
}

