/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.runtime;

import com.evermind.server.ServerExtensionProvider;
import java.util.Map;

public class ServerExtensionProviderSpec {
    private String m_providerName;
    private String m_providerClassName;
    private Map m_properties;
    private ServerExtensionProvider m_provider;

    public ServerExtensionProviderSpec(String providerName, String providerClassName, Map properties) {
        this.m_providerName = providerName;
        this.m_providerClassName = providerClassName;
        this.m_properties = properties;
    }

    public String getProviderName() {
        return this.m_providerName;
    }

    public Map getProperties() {
        return this.m_properties;
    }

    public ServerExtensionProvider getProvider() throws InstantiationException {
        if (this.m_provider == null) {
            this.m_provider = ServerExtensionProviderSpec.instantiateServiceExceptionProvider(this.m_providerClassName);
        }
        return this.m_provider;
    }

    public static ServerExtensionProvider instantiateServiceExceptionProvider(String providerClassName) throws InstantiationException {
        try {
            Object genericInstance = Class.forName(providerClassName).newInstance();
            if (!(genericInstance instanceof ServerExtensionProvider)) {
                throw new InstantiationException("Service-extension-provider class '" + providerClassName + "' was not an instance of a com.evermind.server.ServiceExtensionProvider");
            }
            return (ServerExtensionProvider)genericInstance;
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("server-extension-provider class '" + providerClassName + "' not found");
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Error accessing server-extension-provider class '" + providerClassName + "', make sure access is public");
        }
    }
}

