/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi.tunnelling;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.net.NetworkConnection;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIClientInputStream;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RMIProtocol;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.ClientRmiTransport;
import oracle.oc4j.rmi.tunnelling.AuthenticationRequiredException;
import oracle.oc4j.rmi.tunnelling.RmiHttpClient;

public class TunnelledRmiTransport
extends ClientRmiTransport {
    private static Logger m_logger = TraceLogger.getLogger(TunnelledRmiTransport.class);
    private URL m_url;
    private ByteArrayOutputStream m_output;
    private PluggableInputStream m_input;
    private RmiHttpClient m_client;

    public static String getRequestPath(String domain) {
        return "/" + (domain == null ? "" : domain) + ".rmiTunnel";
    }

    public static String getDomain(String requestPath) {
        int lastSlash = requestPath.lastIndexOf(47);
        String path2 = requestPath.substring(lastSlash + 1);
        return path2.substring(0, path2.lastIndexOf(46));
    }

    public TunnelledRmiTransport(String urlString) throws MalformedURLException {
        this.m_url = new URL(urlString);
    }

    public ClientRmiTransport cloneTransport() {
        return new TunnelledRmiTransport(this);
    }

    private TunnelledRmiTransport(TunnelledRmiTransport other) {
        super(other);
        this.m_url = other.m_url;
    }

    public void connectToServer(RMIClientConnection connection, RMIProtocol protocol, String username, String password, String initialDomain) throws IOException, RMILoginFailedException, AuthenticationException {
        try {
            this.m_output = new ByteArrayOutputStream();
            this.m_input = new PluggableInputStream();
            this.openConnection(this.createNetworkConnection());
            this.m_client = new RmiHttpClient(this.m_url, username, password);
            protocol.writeConnectionHeader(this.m_output);
            this.m_output.flush();
            byte[] bytes = this.m_output.toByteArray();
            this.m_output.reset();
            this.sendRequest(bytes);
            protocol.readConnectionHeader(this.m_input, new RMIProtocol.ConnectionTypeValidation(){

                public void validateConnectionType(int type) throws RMILoginFailedException {
                    throw new RMILoginFailedException("Server was not a tunneled ORMI server");
                }
            });
            this.createObjectInputStream(connection);
        }
        catch (AuthenticationRequiredException e) {
            throw new AuthenticationException("Not authorized");
        }
    }

    public ClassLoaderObjectInputStream createObjectInputStream(InputStream in, RMIConnection connection) throws IOException {
        return new RMIClientInputStream(in, (RMIClientConnection)connection){

            protected void readStreamHeader() {
            }
        };
    }

    public NetworkConnection createNetworkConnection() throws IOException {
        return new TunnelledRmiNetworkConnection();
    }

    public String getLocation() {
        return null;
    }

    protected void sendRequest(byte[] requestContents) throws IOException {
        this.m_input.setInputStream(this.m_client.post(requestContents));
    }

    public boolean equals(Object obj) {
        return this.equalsClass(obj) && this.equals((TunnelledRmiTransport)obj);
    }

    private boolean equals(TunnelledRmiTransport other) {
        return this.m_url.equals(other.m_url);
    }

    public int hashCode() {
        return this.m_url.hashCode();
    }

    public String toString() {
        return "TunnelledRmiTransport [" + this.m_url + "]";
    }

    class TunnelledRmiNetworkConnection
    implements NetworkConnection {
        private InetAddress m_address;

        public TunnelledRmiNetworkConnection() throws IOException {
            this.m_address = InetAddress.getByName(TunnelledRmiTransport.this.m_url.getHost());
        }

        public void close() throws IOException {
            TunnelledRmiTransport.this.m_input.close();
            TunnelledRmiTransport.this.m_output.close();
        }

        public InputStream getInputStream() throws IOException {
            return TunnelledRmiTransport.this.m_input;
        }

        public OutputStream getOutputStream() throws IOException {
            return TunnelledRmiTransport.this.m_output;
        }

        public int getPort() {
            return TunnelledRmiTransport.this.m_url.getPort();
        }

        public String getTypeDescription() {
            return "ormi over http";
        }

        public void setTimeout(int timeout) throws IOException {
        }

        public InetAddress getInetAddress() {
            return this.m_address;
        }
    }

    static class PluggableInputStream
    extends InputStream {
        LinkedQueue m_inputStreamQueue = new LinkedQueue();
        InputStream current = null;
        private boolean m_closed;

        PluggableInputStream() {
        }

        void setInputStream(InputStream inputStream) {
            PluggableInputStreamThread ist = new PluggableInputStreamThread(inputStream, this.m_inputStreamQueue);
            new Thread(ist).start();
            this.m_closed = false;
        }

        public void close() throws IOException {
            if (!this.m_closed) {
                this.m_closed = true;
                try {
                    this.m_inputStreamQueue.put(new IOException("The connection has been closed."));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public synchronized int available() throws IOException {
            return this.current == null ? 0 : this.current.available();
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int first = this.read();
            if (first < 0) {
                return first;
            }
            b[off++] = (byte)first;
            int numToRead = Math.min(this.available(), len - 1);
            for (int i = 0; i < numToRead; ++i) {
                b[off++] = (byte)this.read();
            }
            return numToRead + 1;
        }

        public synchronized int read() throws IOException {
            while (!this.m_closed) {
                while (this.current == null) {
                    try {
                        Object obj = this.m_inputStreamQueue.poll(1000L);
                        if (this.m_closed) {
                            return -1;
                        }
                        if (obj instanceof IOException) {
                            throw (IOException)obj;
                        }
                        this.current = (InputStream)obj;
                    }
                    catch (InterruptedException e) {}
                }
                int result = this.current.read();
                if (result >= 0) {
                    return result;
                }
                this.current.close();
                this.current = null;
            }
            return -1;
        }
    }

    static class PluggableInputStreamThread
    implements Runnable {
        InputStream inputStream = null;
        LinkedQueue inputStreamQueue = null;

        public PluggableInputStreamThread(InputStream _inputStream, LinkedQueue _queue) {
            this.inputStream = _inputStream;
            this.inputStreamQueue = _queue;
            m_logger.log(Level.FINE, "PluggableInputStreamThread is initialized.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                try {
                    byte[] buffer = new byte[1024];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOException ioException = null;
                    try {
                        m_logger.log(Level.FINE, "start to read from inputStream.");
                        int count = this.inputStream.read(buffer);
                        while (count > 0) {
                            m_logger.log(Level.FINE, "read " + count + "bytes.");
                            baos.write(buffer, 0, count);
                            count = this.inputStream.read(buffer);
                        }
                        m_logger.log(Level.FINE, "while loop is terminated. : " + count);
                    }
                    catch (IOException e) {
                        m_logger.log(Level.FINE, "IOException is thrown. " + e);
                        ioException = e;
                    }
                    try {
                        if (ioException != null) {
                            m_logger.log(Level.FINE, "IOException is added to inputStreamQueue.");
                            this.inputStreamQueue.put(ioException);
                            break block11;
                        }
                        m_logger.log(Level.FINE, "An input byte buffer is added to inputStreamQueue.");
                        this.inputStreamQueue.put(new ByteArrayInputStream(baos.toByteArray()));
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                catch (Throwable t) {
                    m_logger.log(Level.FINE, "An exception is caught in end of run(). " + t);
                }
                finally {
                    m_logger.log(Level.FINE, "run loop is terminated.");
                }
            }
        }
    }
}

