/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi.tunnelling;

import com.evermind.net.http.Cookie;
import com.evermind.server.rmi.RMIConnectionException;
import com.evermind.util.Base64Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import oracle.j2ee.rmi.RmiTransportMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.RmiServerResetException;
import oracle.oc4j.rmi.tunnelling.AuthenticationRequiredException;
import oracle.oc4j.security.CryptoException;
import oracle.oc4j.security.ExchangingEncryptor;
import oracle.oc4j.security.OC4JSSLSocketFactory;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.SSLUtilValues;
import oracle.oc4j.security.SSLUtils;
import oracle.oc4j.util.NamedParameterList;

public class RmiHttpClient {
    static final String SSL_RMI_TAG = "rmi";
    private URL m_url;
    private String m_userName;
    private String m_password;
    private HashMap m_cookies = new HashMap();
    private String m_authorizationHeader;
    private SSLUtils.Values m_sslConfig;
    private static Logger m_logger = TraceLogger.getLogger(RmiHttpClient.class);

    public RmiHttpClient(URL url, String userName, String password) {
        this.m_url = url;
        this.m_userName = userName;
        this.m_password = password;
        try {
            this.m_sslConfig = this.getSSLConfig();
        }
        catch (IOException e) {
            m_logger.severe("exception getting ssl config values in constructor: " + e.getMessage());
        }
    }

    public InputStream post(byte[] bytes) throws IOException {
        try {
            return this.getPostResponse(bytes);
        }
        catch (ClassCastException e) {
            throw new IOException("Not an http or https URL");
        }
        catch (AuthenticationRequiredException e) {
            this.m_authorizationHeader = this.createAuthorizationHeader(e.getMessage());
            RmiTransportMessages.fineTunneledAuthorizationHeader(this.m_authorizationHeader);
            return this.getPostResponse(bytes);
        }
        catch (RmiServerResetException e) {
            throw e;
        }
        catch (IOException e) {
            this.m_cookies.clear();
            throw new RMIConnectionException("Post to " + this.m_url + " failed", e, 1);
        }
    }

    private InputStream getPostResponse(byte[] bytes) throws IOException {
        RmiTransportMessages.fineTunneledRequest(this.m_url, bytes);
        HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
        this.addRequestCookies(connection);
        connection.setRequestProperty("transfer-coding", "chunked");
        if (this.m_authorizationHeader != null) {
            connection.setRequestProperty("Authorization", this.m_authorizationHeader);
        }
        this.setRequestMethod(connection);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        if (connection instanceof HttpsURLConnection) {
            this.establishSSLConfig((HttpsURLConnection)connection);
        }
        OC4JSecurity.getOutputStream(connection).write(bytes);
        this.readResponseHeaders(connection);
        return RmiTransportMessages.fineTunneledResponse(connection);
    }

    private void establishSSLConfig(HttpsURLConnection connection) throws IOException {
        if (this.m_sslConfig == null) {
            throw new IOException("SSL Configuration was not initialized.");
        }
        OC4JSSLSocketFactory factory = this.m_sslConfig.isSpecified() ? OC4JSSLSocketFactory.registerSSLUtilValues(SSL_RMI_TAG, this.m_sslConfig) : OC4JSSLSocketFactory.getDefault(SSL_RMI_TAG);
        try {
            connection.setHostnameVerifier(factory);
            connection.setSSLSocketFactory((SSLSocketFactory)factory.getSocketFactory());
        }
        catch (GeneralSecurityException e) {
            RmiTransportMessages.warnTunnelSSlConfigFailure(e);
            throw new IOException(e.getMessage());
        }
    }

    private SSLUtils.Values getSSLConfig() throws IOException {
        SSLUtils.Values defaultValues = null;
        try {
            defaultValues = SSLUtils.getDefaultValues(SSL_RMI_TAG, false);
        }
        catch (IOException e) {
            m_logger.severe("exception getting ssl config values: " + e.getMessage());
        }
        SSLUtils.Values values = SSLUtils.getValues(null, (Hashtable)null, null, SSL_RMI_TAG, (SSLUtilValues)defaultValues);
        if (values.isSpecified()) {
            return values;
        }
        defaultValues = SSLUtils.getDefaultValues(SSL_RMI_TAG, true);
        values = SSLUtils.getValues(null, (Hashtable)null, null, SSL_RMI_TAG, (SSLUtilValues)defaultValues);
        if (values.isSpecified()) {
            return values;
        }
        OC4JSSLSocketFactory.registerSSLUtilValues(SSL_RMI_TAG, SSLUtils.getDefaultValues(SSL_RMI_TAG));
        return SSLUtils.getDefaultValues(SSL_RMI_TAG);
    }

    void setRequestMethod(HttpURLConnection connection) throws IOException {
        connection.setRequestMethod("POST");
    }

    void readResponseHeaders(HttpURLConnection connection) throws IOException {
        String authenticationHeader;
        String failoverHeader;
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        if (m_logger.isLoggable(Level.FINER)) {
            RmiHttpClient.dumpHeader(headerFields);
        }
        if ((failoverHeader = connection.getHeaderField("x-failover")) != null) {
            throw new RmiServerResetException("Failover reported by server");
        }
        Collection cookieColl = headerFields.get("Set-Cookie");
        if (cookieColl != null) {
            Cookie[] newCookies = new Cookie[]{};
            Iterator iterator = cookieColl.iterator();
            while (iterator.hasNext()) {
                newCookies = Cookie.parse(newCookies, (String)iterator.next());
            }
            for (int i = 0; i < newCookies.length; ++i) {
                this.m_cookies.put(newCookies[i].getName(), newCookies[i]);
            }
        }
        if ((authenticationHeader = connection.getHeaderField("WWW-Authenticate")) != null) {
            throw new AuthenticationRequiredException(authenticationHeader);
        }
    }

    public static void dumpHeader(Map fields) {
        m_logger.finer("header fields:");
        if (null == fields || 0 == fields.size()) {
            m_logger.finer("\tno headers");
        }
        Iterator iter = fields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            m_logger.finer("\t" + entry.toString());
        }
    }

    private void addRequestCookies(HttpURLConnection connection) {
        if (this.m_cookies.isEmpty()) {
            return;
        }
        StringBuffer cookieHeader = new StringBuffer();
        Iterator iterator = this.m_cookies.values().iterator();
        while (iterator.hasNext()) {
            Cookie cookie = (Cookie)iterator.next();
            cookieHeader.append(cookie.toExternalForm());
            if (!iterator.hasNext()) continue;
            cookieHeader.append("; ");
        }
        connection.setRequestProperty("Cookie", cookieHeader.toString());
    }

    String createAuthorizationHeader(String challengeHeader) throws IOException {
        StringTokenizer st = new StringTokenizer(challengeHeader);
        String scheme = st.nextToken();
        if (scheme.equalsIgnoreCase("basic")) {
            return "Basic " + new String(Base64Utils.encode((this.m_userName + ':' + this.m_password).getBytes("utf-8"), -1));
        }
        if (scheme.equalsIgnoreCase("keyexchange")) {
            return RmiHttpClient.createKeyExchangeAuthorizationHeader(challengeHeader, this.m_userName, this.m_password);
        }
        throw new IOException("unsupported authentication scheme: " + scheme);
    }

    static String createKeyExchangeAuthorizationHeader(String challengeHeader, String userName, String password) throws CryptoException {
        ExchangingEncryptor encryptor = ExchangingEncryptor.create();
        NamedParameterList challenge = NamedParameterList.parse(challengeHeader);
        encryptor.setRemotePublicKey(challenge.getBase64Decoded("key"));
        NamedParameterList headerParams = NamedParameterList.create();
        headerParams.put("username", userName);
        headerParams.put("password", encryptor.getEncryptedValue(password));
        headerParams.put("key", encryptor.getLocalPublicKey());
        return "KeyExchange " + headerParams;
    }
}

