/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.net.NetworkConnection;
import com.evermind.security.User;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIClientInputStream;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RMIProtocol;
import com.evermind.server.rmi.RMIServer;
import com.evermind.server.rmi.ServerRmiMessageHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.ClientRmiTransport;
import oracle.oc4j.util.CircularByteBuffer;

public class LocalClientRmiTransport
extends ClientRmiTransport {
    private static final int BUFFER_SIZE = 512;
    private static Logger m_logger = TraceLogger.getLogger(LocalClientRmiTransport.class);
    private CircularByteBuffer m_clientToServerBuffer = new CircularByteBuffer(512);
    private CircularByteBuffer m_serverToClientBuffer = new CircularByteBuffer(512);
    private ServerRmiMessageHandler m_serverRmiMessageHandler = null;
    private RMIServer m_rmiServer = null;

    public LocalClientRmiTransport(RMIServer rmiServer, ServerRmiMessageHandler serverRmiMessageHandler, User user) {
        this.m_rmiServer = rmiServer;
        this.m_serverRmiMessageHandler = serverRmiMessageHandler;
        this.m_serverRmiMessageHandler.setUser(user);
    }

    public LocalClientRmiTransport(RMIServer rmiServer, ServerRmiMessageHandler serverRmiMessageHandler) {
        this.m_rmiServer = rmiServer;
        this.m_serverRmiMessageHandler = serverRmiMessageHandler;
    }

    private LocalClientRmiTransport(LocalClientRmiTransport other) {
        try {
            this.m_rmiServer = other.m_rmiServer;
            this.m_serverRmiMessageHandler = ServerRmiMessageHandler.createMessageHandler(this.m_rmiServer, other.m_serverRmiMessageHandler.getContext().getName(), new RMIProtocol(this.m_rmiServer.getInterceptorManager()), this.m_rmiServer.getThreadPool(), true, other.m_serverRmiMessageHandler.getAuthenticatingUser());
        }
        catch (RMILoginFailedException rmiLoginFailedException) {
            m_logger.log(Level.FINER, "LocalClientRmiTransport - Error in creating a new local transport", rmiLoginFailedException);
        }
    }

    public ClientRmiTransport cloneTransport() {
        return new LocalClientRmiTransport(this);
    }

    public NetworkConnection createNetworkConnection() throws IOException {
        return new LocalNetworkConnection(this.m_serverToClientBuffer, this.m_clientToServerBuffer);
    }

    public void connectToServer(RMIClientConnection connection, RMIProtocol protocol, String username, String password, String initialDomain) throws IOException, RMILoginFailedException, AuthenticationException {
        NetworkConnection networkConnection = this.createNetworkConnection();
        this.openConnection(networkConnection);
    }

    public String getLocation() {
        return "local://" + this.m_serverRmiMessageHandler.getContext().getName();
    }

    protected void sendRequest(byte[] requestContents) throws IOException {
        OutputStream outputStream = this.m_clientToServerBuffer.createOutputStream();
        outputStream.write(requestContents);
        this.m_serverRmiMessageHandler.handleSingleRequest(this.m_clientToServerBuffer.createInputStream(), this.m_serverToClientBuffer.createOutputStream());
    }

    public boolean equals(Object obj) {
        return this.equalsClass(obj) && this.equals((LocalClientRmiTransport)obj);
    }

    public boolean equals(LocalClientRmiTransport obj) {
        return this.m_rmiServer == obj.m_rmiServer && this.m_serverRmiMessageHandler == obj.m_serverRmiMessageHandler;
    }

    public int hashCode() {
        return this.getClass().hashCode() + (null == this.m_rmiServer ? 0 : this.m_rmiServer.hashCode()) + (null == this.m_serverRmiMessageHandler ? 0 : this.m_serverRmiMessageHandler.hashCode());
    }

    public ClassLoaderObjectInputStream createObjectInputStream(InputStream in, RMIConnection connection) throws IOException {
        return new RMIClientInputStream(in, (RMIClientConnection)connection){

            protected void readStreamHeader() {
            }
        };
    }

    static class LocalNetworkConnection
    implements NetworkConnection {
        private final CircularByteBuffer m_inputBuffer;
        private final CircularByteBuffer m_outputBuffer;

        public LocalNetworkConnection(CircularByteBuffer inputBuffer, CircularByteBuffer outputBuffer) {
            this.m_inputBuffer = inputBuffer;
            this.m_outputBuffer = outputBuffer;
        }

        public InputStream getInputStream() throws IOException {
            return this.m_inputBuffer.createInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.m_outputBuffer.createOutputStream();
        }

        public int getPort() {
            return 0;
        }

        public void close() throws IOException {
        }

        public void setTimeout(int timeout) throws IOException {
        }

        public String getTypeDescription() {
            return "LocalNetworkConnection";
        }

        public InetAddress getInetAddress() {
            return null;
        }
    }
}

