/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi;

import com.evermind.io.ClassLoaderObjectInputStream;
import com.evermind.io.IOUtils;
import com.evermind.net.NetworkConnection;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIClientInputStream;
import com.evermind.server.rmi.RMIClientOutputStream;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RMIOutputStream;
import com.evermind.server.rmi.RMIProtocol;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import javax.naming.AuthenticationException;
import oracle.oc4j.rmi.ClientSocketRmiTransport;
import oracle.oc4j.rmi.RmiTransport;
import oracle.oc4j.rmi.tunnelling.TunnelledRmiTransport;

public abstract class ClientRmiTransport
extends RmiTransport {
    private int m_timeout;

    public static ClientRmiTransport createDirectTransport(InetAddress address, int port, boolean secure) {
        return new ClientSocketRmiTransport(address, port, secure);
    }

    public static ClientRmiTransport createTunnelledTransport(String urlString) throws MalformedURLException {
        return new TunnelledRmiTransport(urlString);
    }

    protected ClientRmiTransport() {
    }

    protected ClientRmiTransport(ClientRmiTransport other) {
        this.m_timeout = other.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public abstract ClientRmiTransport cloneTransport();

    public abstract NetworkConnection createNetworkConnection() throws IOException;

    public abstract String getLocation();

    public static void rejectNonOrmiServer(NetworkConnection connection) throws RMILoginFailedException {
        String message = "Server protocol was not ORMI";
        if (connection.getPort() == 80 || connection.getPort() == 8080 || connection.getPort() == 8000) {
            message = message + ", given the server port used the most likely protocol encountered is HTTP";
        }
        if (connection.getPort() != 23791 && connection.getPort() != 23943) {
            message = message + ", if uncertain about the port your server uses for ORMI then use the default, 23791";
        }
        throw new RMILoginFailedException(message);
    }

    public void connectToServer(RMIClientConnection connection, RMIProtocol protocol, String username, String password, String initialDomain) throws IOException, RMILoginFailedException, AuthenticationException {
        int serializationType;
        final NetworkConnection networkConnection = this.createNetworkConnection();
        if (this.m_timeout > 0) {
            networkConnection.setTimeout(this.m_timeout);
        }
        this.openConnection(networkConnection);
        protocol.writeConnectionHeader(this.getOutputStream());
        IOUtils.writeBoolean(this.getOutputStream(), false);
        this.getOutputStream().flush();
        protocol.readConnectionHeader(this.getInputStream(), new RMIProtocol.ConnectionTypeValidation(){

            public void validateConnectionType(int type) throws RMILoginFailedException {
                ClientRmiTransport.rejectNonOrmiServer(networkConnection);
            }
        });
        protocol.sendCredentials(this.getInputStream(), this.getOutputStream(), username, password);
        IOUtils.writeUTF(this.getOutputStream(), initialDomain);
        this.getOutputStream().flush();
        int loginResponse = IOUtils.readCompressedInt(this.getInputStream());
        if (loginResponse != 12) {
            String reason = IOUtils.readUTF(this.getInputStream());
            throw new AuthenticationException(reason);
        }
        int timeout = IOUtils.readCompressedInt(this.getInputStream());
        if (timeout > this.m_timeout) {
            this.m_timeout = timeout;
        }
        if (this.m_timeout > 0) {
            networkConnection.setTimeout(this.m_timeout);
        }
        if ((serializationType = IOUtils.readCompressedInt(this.getInputStream())) != 1) {
            throw new IOException("Unsupported serialization type (" + serializationType + ")");
        }
        this.createObjectInputStream(connection);
        IOUtils.writeCompressedInt(this.getOutputStream(), serializationType);
        this.sendConnectionStreamHeader();
    }

    protected abstract void sendRequest(byte[] var1) throws IOException;

    public ClassLoaderObjectInputStream createObjectInputStream(InputStream in, RMIConnection connection) throws IOException {
        return new RMIClientInputStream(in, (RMIClientConnection)connection);
    }

    protected RMIOutputStream createOutputStream(OutputStream out, RMIConnection connection) throws IOException {
        return new RMIClientOutputStream(out, (RMIClientConnection)connection);
    }

    public RmiTransport.MessageOut createDiscreteMessageOut(RMIConnection connection) throws IOException {
        return new DiscreteMessageOut(connection);
    }

    private class DiscreteMessageOut
    implements RmiTransport.MessageOut {
        private ByteArrayOutputStream _byteStream = new ByteArrayOutputStream();
        private ObjectOutputStream _out;

        public DiscreteMessageOut(RMIConnection connection) throws IOException {
            this._out = ClientRmiTransport.this.doCreateObjectOutputStream(this._byteStream, connection);
        }

        public ObjectOutputStream getOutputStream() {
            return this._out;
        }

        public void send() throws IOException {
            this._out.flush();
            ClientRmiTransport.this.sendRequest(this._byteStream.toByteArray());
        }
    }
}

