/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.oc4j.query.QueryUtils;
import oracle.oc4j.query.ThreadPoolQuery;

public class Threads
extends ThreadPoolQuery {
    public String getDescription() {
        return "List thread info for the current VM." + EOL + EOL + "Args: [list|groups]" + EOL + EOL + "list: list all threads" + EOL + "groups: list all thread groups." + EOL + "deadlocks: (jdk1.5) check for deadlock." + EOL + "memory: (jdk1.5) get memory usage." + EOL;
    }

    public void createQueryReport(String[] args) throws Exception {
        if (args.length == 0) {
            this.appendln(this.getDescription());
        } else {
            try {
                String cmd = args[0];
                switch (cmd.charAt(0)) {
                    case 'l': {
                        this.list();
                        break;
                    }
                    case 'g': {
                        this.groups();
                        break;
                    }
                    case 'd': {
                        this.checkDeadlock();
                        break;
                    }
                    case 'm': {
                        this.checkMemory();
                        break;
                    }
                    default: {
                        this.appendln(this.getDescription());
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.appendln(QueryUtils.getStackTrace(e));
            }
        }
    }

    public void groups() {
        ThreadGroup rootGroup = this.rootThreadGroup();
        StringBuffer buffer = new StringBuffer(4096);
        buffer.append("ThreadGroups: " + rootGroup.activeGroupCount() + EOL);
        ThreadGroup[] threadGroups = new ThreadGroup[rootGroup.activeGroupCount()];
        int snapshot = rootGroup.enumerate(threadGroups);
        this.appendln(this.groupInfoHeader());
        for (int i = 0; i < snapshot; ++i) {
            this.appendln(this.groupInfo(threadGroups[i]));
        }
        this.appendln(buffer.toString());
    }

    public String groupInfoHeader() {
        return QueryUtils.underline(QueryUtils.pad("Group Name", 30) + QueryUtils.pad("Parent Name", 30) + QueryUtils.pad("Count", 10) + QueryUtils.pad("max prio", 10), '=');
    }

    public String groupInfo(ThreadGroup g) {
        String name = g.getName();
        String parent = g.getParent() == null ? "<root>" : g.getParent().getName();
        int count = g.activeCount();
        int prio = g.getMaxPriority();
        return "  " + QueryUtils.pad(name, 30) + QueryUtils.pad(parent, 30) + QueryUtils.pad(count, 10) + QueryUtils.pad(prio, 10);
    }

    public void list() {
        ThreadGroup rootGroup = this.rootThreadGroup();
        this.appendln("Total Threads: " + rootGroup.activeCount());
        Thread[] threads = new Thread[rootGroup.activeCount()];
        int len = rootGroup.enumerate(threads);
        this.appendln(this.threadInfoHeader());
        for (int i = 0; i < len; ++i) {
            if (threads[i] == null) continue;
            this.appendln(this.threadInfo(threads[i]));
        }
        this.appendln();
    }

    public String threadInfoHeader() {
        return QueryUtils.underline(QueryUtils.pad("Thread Name", 40) + QueryUtils.pad("Group", 30) + QueryUtils.pad("Daemon", 7) + QueryUtils.pad("Alive", 5), '=');
    }

    public String threadInfo(Thread t) {
        String name = t.getName();
        ThreadGroup g = t.getThreadGroup();
        int pri = t.getPriority();
        boolean d = t.isDaemon();
        boolean a = t.isAlive();
        return "" + QueryUtils.pad(name, 40) + QueryUtils.pad(g.getName(), 30) + QueryUtils.pad(d, 7) + QueryUtils.pad(a, 5);
    }

    public void checkMemory() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> managementFactoryClass = loader.loadClass("java.lang.management.ManagementFactory");
            Method getMemoryMXBean = managementFactoryClass.getMethod("getMemoryMXBean", null);
            Object memMxBean = getMemoryMXBean.invoke(null, null);
            Class<?> cls = loader.loadClass("java.lang.management.MemoryMXBean");
            Class<?> mcls = loader.loadClass("java.lang.management.MemoryUsage");
            Method getHeapMemoryUsage = cls.getMethod("getHeapMemoryUsage", null);
            Object usage = getHeapMemoryUsage.invoke(memMxBean, null);
            Method getNonHeapMemoryUsage = cls.getMethod("getNonHeapMemoryUsage", null);
            Object nusage = getNonHeapMemoryUsage.invoke(memMxBean, null);
            Method getObjectPendingFinalizationCount = cls.getMethod("getObjectPendingFinalizationCount", null);
            Object pending = getObjectPendingFinalizationCount.invoke(memMxBean, null);
            this.appendln(QueryUtils.pad("HeapMemoryUsage", 30) + usage.toString());
            this.appendln(QueryUtils.pad("NonHeapMemoryUsage", 30) + nusage.toString());
            this.appendln(QueryUtils.pad("Objs Pending Finalization", 30) + pending.toString());
        }
        catch (ClassNotFoundException e) {
            this.appendln("Require JDK 1.5...");
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            this.appendln(QueryUtils.getStackTrace(e));
        }
    }

    public void checkDeadlock() {
        try {
            Object threadMxBean = this.callStaticMethodOnClass("java.lang.management.ManagementFactory", "getThreadMXBean");
            Object ids = this.callMethodOnObject(threadMxBean, "java.lang.management.ThreadMXBean", "findMonitorDeadlockedThreads");
            if (ids != null) {
                this.appendln("Deadlock detected " + ids.toString());
            } else {
                this.appendln("No Deadlock detected ;-)");
            }
        }
        catch (ClassNotFoundException e) {
            this.appendln("Require JDK 1.5...");
            this.appendln(QueryUtils.getStackTrace(e));
        }
    }
}

