/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.classloader.util.ArrayUtils;

public class Skin {
    public static final String DEFAULT_SKIN_NAME = "default";
    private static final String BASE_RESOURCE = "peekfiles/peek.css";
    private static final URL BASE_URL = Skin.getResource("peekfiles/peek.css");
    private static final String DEFAULT_IMAGE_NAME = "peek.png";
    private static final String DEFAULT_HEADER_COLOR = "85b841";
    private static final String DEFAULT_INPUT_COLOR = "69a11d";
    private static final Pattern IMAGE_NAME = Pattern.compile("peek.png");
    private static final Pattern HEADER_COLOR = Pattern.compile("85b841");
    private static final Pattern INPUT_COLOR = Pattern.compile("69a11d");
    private static final Map SKINS = new HashMap();
    private static Calendar CALENDAR = new GregorianCalendar();
    private static long baseLastModified = Skin.getResourceLastModified(BASE_URL);
    private static byte[] baseData = Skin.getResourceBytes(BASE_URL);
    private static final Skin DEFAULT_SKIN = new Skin();
    private String name;
    private String imageName;
    private String headerColor;
    private String inputColor;
    private int firstDay;
    private int lastDay;
    private byte[] file;

    public Skin(String skinName, String imageName, String headerColor, String inputColor) {
        this(skinName, imageName, headerColor, inputColor, -1, -1, null);
    }

    public Skin(String skinName, String imageName, String headerColor, String inputColor, String firstDay, String lastDay) {
        this(skinName, imageName, headerColor, inputColor, Skin.getDay(firstDay), Skin.getDay(lastDay), null);
    }

    public String getName() {
        return this.name;
    }

    public synchronized byte[] getCSSFileData() {
        long newModTime = Skin.getResourceLastModified(BASE_URL);
        if (newModTime != baseLastModified) {
            baseLastModified = newModTime;
            baseData = Skin.getResourceBytes(BASE_URL);
            this.file = this == DEFAULT_SKIN ? baseData : Skin.getFile(this.imageName, this.headerColor, this.inputColor);
        }
        return this.file;
    }

    public static String getDefaultSkinName() {
        Skin result = null;
        int currentDay = Skin.getDay();
        Iterator iterator = SKINS.values().iterator();
        while (iterator.hasNext()) {
            Skin skin = (Skin)iterator.next();
            if (!skin.inRange(currentDay)) continue;
            result = skin;
            break;
        }
        if (result == null) {
            result = DEFAULT_SKIN;
        }
        return result.getName();
    }

    public static Skin getSkin(String skinName) {
        Skin result = null;
        if (skinName != null) {
            result = (Skin)SKINS.get(skinName);
        }
        if (result == null) {
            result = DEFAULT_SKIN;
        }
        return result;
    }

    private Skin() {
        this(DEFAULT_SKIN_NAME, DEFAULT_IMAGE_NAME, DEFAULT_HEADER_COLOR, DEFAULT_INPUT_COLOR, 0, 0, baseData);
    }

    private Skin(String name, String imageName, String headerColor, String inputColor, int firstDay, int lastDay, byte[] data) {
        this.name = name;
        this.firstDay = firstDay;
        this.lastDay = lastDay;
        this.imageName = imageName;
        this.headerColor = headerColor;
        this.inputColor = inputColor;
        if (data == null) {
            data = Skin.getFile(imageName, headerColor, inputColor);
        }
        this.file = data;
        Skin.register(this);
    }

    private static synchronized void register(Skin skin) {
        SKINS.put(skin.name, skin);
    }

    private boolean inRange(int dayOfYear) {
        return this.firstDay <= dayOfYear && dayOfYear <= this.lastDay;
    }

    private static byte[] getFile(String imageName, String headerColor, String inputColor) {
        String result = new String(baseData);
        result = IMAGE_NAME.matcher(result).replaceFirst(imageName);
        result = HEADER_COLOR.matcher(result).replaceAll(headerColor);
        result = INPUT_COLOR.matcher(result).replaceAll(inputColor);
        return result.getBytes();
    }

    private static synchronized int getDay(String monthDay) {
        int month = Integer.parseInt(monthDay.substring(0, monthDay.indexOf(47)));
        int day = Integer.parseInt(monthDay.substring(monthDay.indexOf(47) + 1));
        CALENDAR.setTimeInMillis(System.currentTimeMillis());
        int year = CALENDAR.get(1);
        CALENDAR.set(year, month - 1, day);
        return CALENDAR.get(6);
    }

    private static synchronized int getDay() {
        CALENDAR.setTimeInMillis(System.currentTimeMillis());
        return CALENDAR.get(6);
    }

    private static long getResourceLastModified(URL resource) {
        try {
            return resource.openConnection().getLastModified();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static byte[] getResourceBytes(URL resource) {
        try {
            InputStream in = resource.openStream();
            return ArrayUtils.read((InputStream)in);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static URL getResource(String resourcePath) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader.getResource(resourcePath);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

