/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import com.evermind.io.TimestampedPrintStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.classloader.query.ListQueries;
import oracle.classloader.util.ClassLoadLogger;
import oracle.oc4j.peek.CodeSourceHandler;
import oracle.oc4j.peek.HelpHandler;
import oracle.oc4j.peek.LoaderHandler;
import oracle.oc4j.peek.LoaderTreeHandler;
import oracle.oc4j.peek.LogHandler;
import oracle.oc4j.peek.LoggerHandler;
import oracle.oc4j.peek.LoggersHandler;
import oracle.oc4j.peek.PeekHandler;
import oracle.oc4j.peek.QueryHandler;
import oracle.oc4j.peek.ResourceHandler;
import oracle.oc4j.peek.SkinHandler;

public class Peek
extends HttpServlet {
    static final List QUERY_CLASS_NAMES = ListQueries.getQueryClassNames();
    private static final Logger LOGGER = ClassLoadLogger.getLogger();
    private static ServletContext context;
    private static String contextRoot;
    private static String filesRoot;
    private static Map handlers;
    private static List handlerClasses;
    private static boolean oneTimeInitializationComplete;
    private static PrintStream accessLog;

    private static List getDefaultHandlerClasses() {
        ArrayList<Class> result = new ArrayList<Class>();
        result.add(SkinHandler.class);
        result.add(HelpHandler.class);
        result.add(LoaderHandler.class);
        result.add(LoaderTreeHandler.class);
        result.add(QueryHandler.class);
        result.add(ResourceHandler.class);
        result.add(CodeSourceHandler.class);
        result.add(LoggersHandler.class);
        result.add(LoggerHandler.class);
        result.add(LogHandler.class);
        return result;
    }

    static ServletContext getContext() {
        return context;
    }

    static String getContextRoot() {
        return contextRoot;
    }

    static String getFilesRoot() {
        return filesRoot;
    }

    static PrintStream getAccessLog() {
        return accessLog;
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        context = servletConfig.getServletContext();
    }

    private synchronized void oneTimeInit(HttpServletRequest request) {
        if (!oneTimeInitializationComplete) {
            String root = request.getContextPath();
            if (root.length() == 0) {
                root = "/";
            } else {
                if (!root.startsWith("/")) {
                    root = "/" + root;
                }
                if (!root.endsWith("/")) {
                    root = root + "/";
                }
            }
            contextRoot = root + "peek/";
            filesRoot = root + "peekfiles/";
            try {
                Peek.initHandlers();
                Peek.initAccessLog();
            }
            catch (Exception exception) {
                // empty catch block
            }
            oneTimeInitializationComplete = true;
        }
    }

    public synchronized void destroy() {
        context = null;
    }

    private static void initHandlers() throws ServletException {
        Iterator iterator = handlerClasses.iterator();
        while (iterator.hasNext()) {
            Class aClass = (Class)iterator.next();
            try {
                aClass.newInstance();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public synchronized void addHandlerClass(Class handlerClass) {
        handlerClasses.add(handlerClass);
    }

    static synchronized void registerHandler(String uriSuffix, PeekHandler handler) {
        handlers.put(uriSuffix, handler);
    }

    private static void initAccessLog() throws ServletException {
        String logFilePath = PeekHandler.getLogFilePath();
        if (logFilePath != null) {
            try {
                accessLog = new TimestampedPrintStream(new BufferedOutputStream(new FileOutputStream(logFilePath, true), 2048));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.oneTimeInit(request);
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getPathInfo();
        try {
            if (path == null) {
                response.sendRedirect(contextRoot);
            } else {
                String cmd = path.substring(1);
                String argument = null;
                if (cmd.length() == 0) {
                    cmd = "help";
                } else {
                    int slash = cmd.indexOf(47);
                    if (slash > 0) {
                        argument = cmd.substring(slash + 1);
                        cmd = cmd.substring(0, slash);
                    }
                }
                PeekHandler handler = (PeekHandler)handlers.get(cmd);
                if (handler == null) {
                    handler = (PeekHandler)handlers.get("help");
                    argument = null;
                }
                handler.handleRequest(argument, request, response);
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Caught ", e);
            response.sendError(400, e.toString());
        }
        if (accessLog != null && path != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(request.getRemoteHost());
            buf.append(' ');
            buf.append(request.getRemoteAddr());
            buf.append(' ');
            buf.append(request.getRequestURI());
            String query = request.getQueryString();
            if (query != null) {
                buf.append('?');
                buf.append(query);
            }
            accessLog.println(buf.toString());
        }
    }

    static {
        handlers = new HashMap();
        handlerClasses = Peek.getDefaultHandlerClasses();
    }
}

