/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.network;

import com.evermind.util.BBPool;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.oc4j.network.ServerSocketAcceptHandler;
import oracle.oc4j.network.ServerSocketDriver;
import oracle.oc4j.network.ServerSocketReadHandler;

public class ReadHandlerPool
extends BBPool {
    private ServerSocketAcceptHandler owner;
    private ArrayList registeredUsers = new ArrayList(10);

    public ReadHandlerPool(int min, int max, long maxWaitMilliSecond, long poolTimeout) {
        super(min, max, maxWaitMilliSecond, poolTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(ServerSocketAcceptHandler user) {
        ArrayList arrayList = this.registeredUsers;
        synchronized (arrayList) {
            if (this.owner == null) {
                this.owner = user;
                this.startPool();
            }
            this.registeredUsers.add(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(ServerSocketAcceptHandler user) {
        ArrayList arrayList = this.registeredUsers;
        synchronized (arrayList) {
            int i;
            for (i = 0; i < this.registeredUsers.size() && (ServerSocketAcceptHandler)this.registeredUsers.get(i) != user; ++i) {
            }
            if (i == this.registeredUsers.size()) {
                return;
            }
            this.registeredUsers.remove(i);
            if (this.registeredUsers.size() == 0) {
                this.shutdown();
            } else if (this.owner == user) {
                this.owner = (ServerSocketAcceptHandler)this.registeredUsers.get(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        ArrayList arrayList = this.registeredUsers;
        synchronized (arrayList) {
            this.registeredUsers.clear();
            this.owner = null;
        }
        super.destroy();
    }

    protected Object getContextFromBackend() {
        ServerSocketReadHandler handler = this.owner.getReadHandler();
        handler.bindAcceptHandler(this.owner);
        return handler;
    }

    protected void releaseContextToBackend(Object _context, boolean toBeDiscarded) {
        if (toBeDiscarded) {
            return;
        }
        ServerSocketReadHandler handler = (ServerSocketReadHandler)_context;
        try {
            handler.clearFieldsForGC();
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocketReadHandler getHandler(int port) {
        ServerSocketReadHandler handler = (ServerSocketReadHandler)this.getContext();
        if (handler.acceptHandler.getLocalPort() == port) {
            return handler;
        }
        ArrayList arrayList = this.registeredUsers;
        synchronized (arrayList) {
            for (int i = 0; i < this.registeredUsers.size(); ++i) {
                ServerSocketAcceptHandler accept = (ServerSocketAcceptHandler)this.registeredUsers.get(i);
                if (port != accept.getLocalPort()) continue;
                handler.bindAcceptHandler(accept);
                break;
            }
        }
        return handler;
    }

    public void releaseHandler(ServerSocketReadHandler handler, boolean keep) {
        this.releaseContext(handler, !keep);
    }

    public void releaseHandlerNoEx(ServerSocketReadHandler handler, boolean b) {
        block2: {
            try {
                this.releaseHandler(handler, b);
            }
            catch (Exception e) {
                if (!ServerSocketDriver.logger.isLoggable(Level.WARNING)) break block2;
                ServerSocketDriver.logger.log(Level.WARNING, "Exception in releasing read handler", e);
            }
        }
    }

    protected void afterRecvContextFromClient(Object context, boolean toBeDiscarded) {
        if (!toBeDiscarded) {
            try {
                ((ServerSocketReadHandler)context).beforeCaching();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

