/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.naming.url.opmn;

import com.evermind.server.cluster.ServerIdentification;
import com.evermind.util.OpmnHelper;
import com.evermind.util.ServerProperties;
import com.sun.jndi.toolkit.url.GenericURLContext;
import com.sun.jndi.url.corbaname.corbanameURLContextFactory;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ResolveResult;
import oracle.oc4j.naming.url.opmn.opmncorbaURLContext;

public class opmnURLContext
extends GenericURLContext {
    private OpmnProxy _proxy;
    private static OpmnProxy STANDARD_PROXY = new OpmnProxy(){

        public ServerIdentification[] getServers(String host, int port, String instanceName, String connectionType, String applicationName) {
            return OpmnHelper.getOc4jServers(host, port, instanceName, connectionType, applicationName);
        }

        public ObjectFactory getURLContextFactory(String protocol) {
            if (protocol.equals("corbaname")) {
                return new corbanameURLContextFactory();
            }
            throw new IllegalArgumentException("opmnURLContext does not support opmn:" + protocol + " URLs");
        }
    };

    public opmnURLContext(Hashtable environment) {
        this(environment, STANDARD_PROXY);
    }

    opmnURLContext(Hashtable environment, OpmnProxy proxy) {
        super(environment);
        this._proxy = proxy;
    }

    protected ResolveResult getRootURLContext(String url, Hashtable env) throws NamingException {
        if (!url.startsWith("opmn:corbaname::")) {
            throw new IllegalArgumentException("opmnURLContext: currently only supporting corbaname lookups");
        }
        return new opmncorbaURLContext(env, this._proxy).getRootURLContext(url, env);
    }

    protected ObjectFactory getURLContextFactory(String protocol) {
        return this._proxy.getURLContextFactory(protocol);
    }

    protected ServerIdentification[] getServersFromOpmn(String host, int port, String instanceName, String applicationName) {
        if (ServerProperties.getOpmnQueryDebug()) {
            System.out.println("Querying opmn at host: " + host + ", port: " + port + "for oc4jInstanceName: " + instanceName);
        }
        ServerIdentification[] servers = this._proxy.getServers(host, port, instanceName, "iiop", applicationName);
        if (ServerProperties.getOpmnQueryDebug()) {
            for (int i = 0; i < servers.length; ++i) {
                System.out.println("servers[" + i + "]: " + servers[i].getAddress() + ", port: " + servers[i].getPort());
            }
        }
        return servers;
    }

    static interface OpmnProxy {
        public ServerIdentification[] getServers(String var1, int var2, String var3, String var4, String var5);

        public ObjectFactory getURLContextFactory(String var1);
    }
}

