/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.security;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public final class J2EEKeyManager
implements X509KeyManager {
    private static boolean debug = false;
    private X509KeyManager mgr = null;

    public J2EEKeyManager(X509KeyManager mgr) {
        this.mgr = mgr;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (debug) {
            System.out.println("Choose client Alias for keytype:" + keyType);
        }
        return this.mgr.chooseClientAlias(keyType, issuers, socket);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (debug) {
            System.out.println("Choose server Alias for keytype:" + keyType);
        }
        return this.mgr.chooseServerAlias(keyType, issuers, socket);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        if (debug) {
            System.out.println("Getting certificate chain");
        }
        return this.mgr.getCertificateChain(alias);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (debug) {
            System.out.println("Getting client aliases");
        }
        return this.mgr.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (debug) {
            System.out.println("Getting server aliases");
        }
        return this.mgr.getServerAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String alias) {
        if (debug) {
            System.out.println("Getting private key for alias:" + alias);
        }
        return this.mgr.getPrivateKey(alias);
    }
}

