/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.security;

import com.evermind.util.IIOPProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Provider;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import oracle.j2ee.corba.iiop.IIOPMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.corba.orb.OrbManager;
import oracle.oc4j.security.OC4JSSLSocketFactory;
import oracle.oc4j.security.SSLUtilValues;
import oracle.oc4j.security.SSLUtils;

public class IIOPSSLUtils {
    private static final String CATEGORY_NAME_IIOP = "iiop";
    private static final String JKS_ALGORITM_NAME = "SunX509";
    private static final IIOPSSLUtils IIOP_SSL_Utils = new IIOPSSLUtils();
    static final Logger m_traceLogger = TraceLogger.getLogger(IIOPSSLUtils.class);

    IIOPSSLUtils() {
    }

    public static IIOPSSLUtils getInstance() {
        return IIOP_SSL_Utils;
    }

    public void initStores() throws Exception {
        SSLUtils.Values values = this.getValues();
        if (values == null) {
            throw new IllegalArgumentException("Passed in values can not be null.");
        }
        String keyFile = values.getKeyStoreLocation();
        String keyPass = values.getKeyStorePassword();
        String trustFile = values.getTrustStoreLocation();
        String trustPass = values.getTrustStorePassword();
        IIOPSSLUtils.validate(keyFile, trustFile, keyPass);
        m_traceLogger.log(Level.FINER, "Loading keyFile = {0}", keyFile);
        m_traceLogger.log(Level.FINER, "Loading trustFile = {0}", trustFile);
        TrustManager[] trustManagers = null;
        KeyManager[] keyManagers = null;
        keyManagers = this.createKeyManagers(keyFile, keyPass);
        trustManagers = this.createTrustManagers(trustFile, trustPass);
        this.setKeyAndTrustManagers(keyManagers, trustManagers);
    }

    private static void validate(String keyFile, String trustFile, String keyPass) {
        if (IIOPSSLUtils.isEmpty(keyFile) || IIOPSSLUtils.isUnreadable(keyFile)) {
            throw new IllegalArgumentException("IIOPSSL: Check keyStore value, it can not be null and must point to a readable file.");
        }
        if (IIOPSSLUtils.isEmpty(trustFile) || IIOPSSLUtils.isUnreadable(trustFile)) {
            throw new IllegalArgumentException("IIOPSSL: Check trustStore value, it can not be null and must point to a readable file.");
        }
        if (IIOPSSLUtils.isEmpty(keyPass)) {
            throw new IllegalArgumentException("IIOPSSL: Check KeyPass value, it can not be null");
        }
    }

    private static boolean isUnreadable(String keyFile) {
        return !new File(keyFile).canRead();
    }

    private static boolean isEmpty(String keyFile) {
        return keyFile == null || keyFile.trim().length() == 0;
    }

    public TrustManager[] createTrustManagers(String trustfile, String trustpass) throws Exception {
        if (trustfile != null) {
            TrustManagerFactory tmf;
            KeyStore ks;
            if (IIOPSSLUtils.isWalletStore(trustfile)) {
                ks = KeyStore.getInstance("PKCS12", IIOPSSLUtils.getOracleSSLProvider());
                m_traceLogger.log(Level.FINEST, "Got an instance of PKCS12 Trust Manager for IIOP");
                FileInputStream istream = new FileInputStream(trustfile);
                m_traceLogger.log(Level.FINER, "Loading Trust store {0}", trustfile);
                char[] passphrase = trustpass.toCharArray();
                ks.load(new FileInputStream(trustfile), passphrase);
                istream.close();
                tmf = TrustManagerFactory.getInstance("OracleX509");
            } else {
                ks = KeyStore.getInstance("JKS");
                m_traceLogger.log(Level.FINEST, "Got an instance of JKS Trust Manager for IIOP");
                FileInputStream istream = new FileInputStream(trustfile);
                m_traceLogger.log(Level.FINER, "Loading Trust store {0}", trustfile);
                char[] passphrase = trustpass.toCharArray();
                ks.load(new FileInputStream(trustfile), passphrase);
                istream.close();
                tmf = TrustManagerFactory.getInstance(JKS_ALGORITM_NAME);
            }
            tmf.init(ks);
            return tmf.getTrustManagers();
        }
        return null;
    }

    public KeyManager[] createKeyManagers(String keyFile, String keyPass) throws Exception {
        if (keyFile != null) {
            KeyManagerFactory kmf;
            KeyStore ks;
            if (IIOPSSLUtils.isWalletStore(keyFile)) {
                ks = KeyStore.getInstance("PKCS12", IIOPSSLUtils.getOracleSSLProvider());
                m_traceLogger.log(Level.FINEST, "Got an instance of PKCS12 Key Manager for IIOP");
                FileInputStream istream = new FileInputStream(keyFile);
                m_traceLogger.log(Level.FINER, "Loading key store {0}", keyFile);
                char[] passphrase = keyPass.toCharArray();
                ks.load(new FileInputStream(keyFile), passphrase);
                istream.close();
                kmf = KeyManagerFactory.getInstance("OracleX509");
            } else {
                ks = KeyStore.getInstance("JKS");
                m_traceLogger.log(Level.FINEST, "Got an instance of JKS Key Manager for IIOP");
                FileInputStream istream = new FileInputStream(keyFile);
                m_traceLogger.log(Level.FINER, "Loading key store {0}", keyFile);
                char[] passphrase = keyPass.toCharArray();
                ks.load(new FileInputStream(keyFile), passphrase);
                istream.close();
                kmf = KeyManagerFactory.getInstance(JKS_ALGORITM_NAME);
            }
            kmf.init(ks, keyPass.toCharArray());
            return kmf.getKeyManagers();
        }
        return null;
    }

    private static boolean isWalletStore(String file) {
        return file.trim().length() > 0 && file.endsWith(".p12");
    }

    void setKeyAndTrustManagers(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        OrbManager.setSSLManagers(keyManagers, trustManagers);
    }

    SSLUtils.Values getValues() throws IOException {
        SSLUtils.Values values;
        try {
            values = SSLUtils.getValues(null, IIOPSSLUtils.getPropertiesFileLocation(), "oc4j", CATEGORY_NAME_IIOP, (SSLUtilValues)new DefaultOc4jIIOPSSLUtilValues());
        }
        catch (IOException e) {
            m_traceLogger.log(Level.FINE, e.getMessage(), e);
            throw e;
        }
        return values;
    }

    static String getPropertiesFileLocation() {
        File file;
        String spf = IIOPProperties.getEjbSecPropertiesLocation();
        if (!(null == spf || (file = new File(spf)).exists() && file.canRead())) {
            spf = null;
        }
        if (null == spf) {
            spf = SSLUtils.getDefaultPropertiesFileLocation();
        }
        return spf;
    }

    private static Provider getOracleSSLProvider() throws IOException {
        try {
            return OC4JSSLSocketFactory.createSecurityProvider("oracle.security.pki.OraclePKIProvider");
        }
        catch (IOException e) {
            IIOPMessages.warningOracleSecurityProviderMissing("oracle.security.pki.OraclePKIProvider", e);
            throw e;
        }
    }

    static final class DefaultOc4jIIOPSSLUtilValues
    extends SSLUtils {
        DefaultOc4jIIOPSSLUtilValues() {
        }

        public String getKeyStoreLocation() {
            if (null != SSLUtils.getOverrides().getKeyStoreLocation()) {
                return SSLUtils.getOverrides().getKeyStoreLocation();
            }
            return IIOPProperties.getOc4jIIOPKeyStoreLoc();
        }

        public String getKeyStorePassword() {
            if (null != SSLUtils.getOverrides().getKeyStorePassword()) {
                return SSLUtils.getOverrides().getKeyStorePassword();
            }
            return IIOPProperties.getOc4jIIOPKeyStorePass();
        }

        public String getTrustStoreLocation() {
            if (null != SSLUtils.getOverrides().getTrustStoreLocation()) {
                return SSLUtils.getOverrides().getTrustStoreLocation();
            }
            return IIOPProperties.getOc4jIIOPTrustStoreLoc();
        }

        public String getTrustStorePassword() {
            if (null != SSLUtils.getOverrides().getTrustStorePassword()) {
                return SSLUtils.getOverrides().getTrustStorePassword();
            }
            return IIOPProperties.getOc4jIIOPTrustStorePass();
        }
    }
}

