/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop;

import com.oracle.corba.ee.impl.orb.ORBManagerImpl;
import com.sun.corba.ee.impl.encoding.CDROutputStream;
import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechList;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechListHelper;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.ServiceConfiguration;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import com.sun.corba.ee.org.omg.CSIIOP.TransportAddress;
import com.sun.enterprise.util.Utility;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import oracle.j2ee.corba.security.CSIV2Messages;
import oracle.oc4j.corba.deployment.EjbIORConfigurationDescriptor;
import oracle.oc4j.corba.iiop.CommonCSIV2TaggedComponentInfo;
import oracle.oc4j.corba.iiop.security.GSSUtils;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.TaggedComponent;

public final class CSIV2TaggedComponentInfo
extends CommonCSIV2TaggedComponentInfo {
    private static final String REALM_NAME = "default";
    public static final int SUPPORTED_IDENTITY_TOKEN_TYPES = 15;
    private int m_sslMutualAuthPort;

    public CSIV2TaggedComponentInfo(ORB orb) {
        super(orb);
    }

    public TaggedComponent createSecurityTaggedComponent(int sslPort, Set iorDescSet) {
        try {
            CompoundSecMech[] mechList = this.createCompoundSecMechs(sslPort, iorDescSet);
            return this.createTaggedComponent(mechList);
        }
        catch (Exception e) {
            CSIV2Messages.finerThrowableNoMsg(e);
            return null;
        }
    }

    public TaggedComponent createSecurityTaggedComponent(int sslPort, boolean sslRequired) {
        try {
            CompoundSecMech[] mechList = new CompoundSecMech[1];
            TaggedComponent comp = this.createSSLInfo(sslPort, null, sslRequired);
            AS_ContextSec asContext = this.createASContextSec(null);
            SAS_ContextSec sasContext = this.createSASContextSec(null);
            TaggedComponent transportMech = comp;
            mechList[0] = new CompoundSecMech(0, transportMech, asContext, sasContext);
            return this.createTaggedComponent(mechList);
        }
        catch (Exception e) {
            CSIV2Messages.finerThrowableNoMsg(e);
            return null;
        }
    }

    private TaggedComponent createTaggedComponent(CompoundSecMech[] mechList) {
        CDROutputStream out = (CDROutputStream)this.orb.create_output_stream();
        out.putEndian();
        boolean stateful = false;
        CompoundSecMechList list = new CompoundSecMechList(stateful, mechList);
        CompoundSecMechListHelper.write((OutputStream)out, (CompoundSecMechList)list);
        byte[] buf = out.toByteArray();
        TaggedComponent tc = new TaggedComponent(33, buf);
        return tc;
    }

    private CompoundSecMech[] createCompoundSecMechs(int sslPort, Set iorDescSet) throws IOException {
        int size = iorDescSet.size();
        if (size == 0) {
            EjbIORConfigurationDescriptor eDesc = new EjbIORConfigurationDescriptor();
            eDesc.setAuthMethodRequired(true);
            iorDescSet.add(eDesc);
            size = 1;
        }
        CompoundSecMech[] mechList = new CompoundSecMech[size];
        Iterator itr = iorDescSet.iterator();
        for (int i = 0; i < size; ++i) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            int target_requires = this.getTargetRequires(iorDesc);
            TaggedComponent comp = this.createSSLInfo(sslPort, iorDesc, false);
            AS_ContextSec asContext = this.createASContextSec(iorDesc);
            SAS_ContextSec sasContext = this.createSASContextSec(iorDesc);
            int targ_req = target_requires | asContext.target_requires | sasContext.target_requires;
            TaggedComponent transportMech = comp;
            mechList[i] = new CompoundSecMech((short)targ_req, transportMech, asContext, sasContext);
        }
        return mechList;
    }

    public boolean allMechanismsRequireSSL(Set iorDescSet) {
        int size = iorDescSet.size();
        if (size == 0) {
            return false;
        }
        Iterator itr = iorDescSet.iterator();
        for (int i = 0; i < size; ++i) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            int target_requires = this.getTargetRequires(iorDesc);
            if (target_requires != 0) continue;
            return false;
        }
        return true;
    }

    public AS_ContextSec createASContextSec(EjbIORConfigurationDescriptor iorDesc) throws IOException {
        AS_ContextSec asContext = null;
        int target_supports = 0;
        int target_requires = 0;
        byte[] client_authentication_mechanism = new byte[]{};
        byte[] target_name = new byte[]{};
        String authMethod = null;
        boolean authMethodRequired = false;
        if (iorDesc != null) {
            authMethod = iorDesc.getAuthenticationMethod();
            authMethodRequired = iorDesc.isAuthMethodRequired();
        }
        if (authMethod != null && authMethod.equals("none")) {
            asContext = new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
            return asContext;
        }
        target_name = GSSUtils.createExportedName(GSSUtils.GSSUP_MECH_OID, REALM_NAME.getBytes());
        target_supports = 64;
        if (authMethodRequired) {
            target_requires = 64;
        }
        client_authentication_mechanism = this.getMechanism();
        asContext = new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
        return asContext;
    }

    public SAS_ContextSec createSASContextSec(EjbIORConfigurationDescriptor iorDesc) throws IOException {
        SAS_ContextSec sasContext = null;
        int target_supports = 0;
        boolean target_requires = false;
        ServiceConfiguration[] priv = new ServiceConfiguration[]{};
        String callerPropagation = null;
        Object mechanisms = new byte[][]{};
        int supported_identity_token_type = 0;
        if (iorDesc != null) {
            callerPropagation = iorDesc.getCallerPropagation();
        }
        if (callerPropagation != null && callerPropagation.equals("none")) {
            sasContext = new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), priv, (byte[][])mechanisms, supported_identity_token_type);
            return sasContext;
        }
        if (iorDesc != null) {
            target_supports = 1024;
        }
        byte[] upm = this.getMechanism();
        mechanisms = new byte[1][upm.length];
        for (int i = 0; i < upm.length; ++i) {
            mechanisms[0][i] = upm[i];
        }
        if (target_supports != 0) {
            supported_identity_token_type = 15;
        }
        sasContext = new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), priv, (byte[][])mechanisms, supported_identity_token_type);
        return sasContext;
    }

    private TaggedComponent createSSLInfo(int sslport, EjbIORConfigurationDescriptor iorDesc, boolean sslRequired) {
        int targetSupports = 0;
        int targetRequires = 0;
        if (iorDesc == null) {
            targetSupports = 102;
            if (sslRequired) {
                targetRequires = 70;
            }
        } else {
            String sslPort;
            targetSupports = this.getTargetSupports(iorDesc);
            targetRequires = this.getTargetRequires(iorDesc);
            if ((targetRequires & 0x40) == 64 && (sslPort = ORBManagerImpl.getORBManager().getORBConfig().getORBProperties().getProperty("com.oracle.corba.ee.security.ssl.mutual.auth.port")) != null) {
                sslport = Integer.parseInt(sslPort);
            }
        }
        if ((targetSupports | targetRequires) == 0) {
            byte[] b = new byte[]{};
            TaggedComponent tc = new TaggedComponent(34, b);
            return tc;
        }
        String host_name = "";
        host_name = Utility.getLocalAddress();
        TransportAddress[] listTa = this.generateTransportAddresses(host_name, sslport);
        TLS_SEC_TRANS tls_sec = new TLS_SEC_TRANS((short)targetSupports, (short)targetRequires, listTa);
        CDROutputStream out = (CDROutputStream)this.orb.create_output_stream();
        out.putEndian();
        TLS_SEC_TRANSHelper.write((OutputStream)out, (TLS_SEC_TRANS)tls_sec);
        byte[] buf = out.toByteArray();
        TaggedComponent tc = new TaggedComponent(36, buf);
        return tc;
    }

    private TransportAddress[] generateTransportAddresses(String host, int sslport) {
        short short_port = Utility.intToShort(sslport);
        TransportAddress ta = new TransportAddress(host, short_port);
        TransportAddress[] listTa = new TransportAddress[]{ta};
        return listTa;
    }

    public int getTargetSupports(EjbIORConfigurationDescriptor iorDesc) {
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        if (iorDesc == null) {
            return 0;
        }
        int supports = 0;
        String integrity = iorDesc.getIntegrity();
        if (!integrity.equals("none")) {
            supports |= 2;
        }
        if (!(confidentiality = iorDesc.getConfidentiality()).equals("none")) {
            supports |= 4;
        }
        if (!(establishTrustInTarget = iorDesc.getEstablishTrustInTarget()).equals("none")) {
            supports |= 0x20;
        }
        if (!(establishTrustInClient = iorDesc.getEstablishTrustInClient()).equals("none")) {
            supports |= 0x40;
        }
        return supports;
    }

    public int getTargetRequires(EjbIORConfigurationDescriptor iorDesc) {
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        if (iorDesc == null) {
            return 0;
        }
        int requires = 0;
        String integrity = iorDesc.getIntegrity();
        if (integrity.equals("required")) {
            requires |= 2;
        }
        if ((confidentiality = iorDesc.getConfidentiality()).equals("required")) {
            requires |= 4;
        }
        if ((establishTrustInTarget = iorDesc.getEstablishTrustInTarget()).equals("required")) {
            requires |= 0x20;
        }
        if ((establishTrustInClient = iorDesc.getEstablishTrustInClient()).equals("required")) {
            requires |= 0x40;
        }
        return requires;
    }

    private byte[] getMechanism() throws IOException {
        return GSSUtils.getDER(GSSUtils.GSSUP_MECH_OID);
    }

    public void setSSLMutualAuthPort(int sslMutualAuthPort) {
        this.m_sslMutualAuthPort = sslMutualAuthPort;
    }

    public int getSslMutualAuthPort() {
        return this.m_sslMutualAuthPort;
    }

    public CompoundSecMech[] getSecurityMechanisms(Object ior) {
        return super.getSecurityMechanisms(ior);
    }
}

