/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans.proprietary;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ValueExp;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.mbeans.proprietary.DeploymentManagerProxyMBean;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public class DeploymentManagerProxy
implements DeploymentManagerProxyMBean {
    private MBeanServer mbeanServer_ = null;

    public DeploymentManagerProxy(MBeanServer mbeanServer) {
        this.mbeanServer_ = mbeanServer;
    }

    public Set getRunningModules(SharedModuleType moduleType, Set targetList) throws JMXException {
        return this.performQuery(moduleType, targetList, true);
    }

    public Set getNonRunningModules(SharedModuleType moduleType, Set targetList) throws JMXException {
        return this.performQuery(moduleType, targetList, false);
    }

    private final String getObjectNamePattern(SharedModuleType moduleType) {
        return "*:j2eeType=" + moduleType.getManagementJ2eeType() + ",J2EEServer=";
    }

    private final Set performQuery(SharedModuleType moduleType, Set targetList, boolean startQuery) {
        Set[] deployedObjects = new Set[targetList.size()];
        int deployedObjectsCount = 0;
        String searchPattern = this.getObjectNamePattern(moduleType);
        int i = 0;
        Iterator iterTgt = targetList.iterator();
        while (iterTgt.hasNext()) {
            ObjectName tgt = (ObjectName)iterTgt.next();
            String serverName = tgt.getKeyProperty("name");
            String sPattern = searchPattern + serverName + ",*";
            try {
                ObjectName targetPattern = ObjectNameFactory.create((String)sPattern);
                ValueExp st = null;
                st = startQuery ? Query.value(1) : Query.value(3);
                QueryExp query = Query.eq(Query.attr("state"), st);
                deployedObjects[i] = this.mbeanServer_.queryNames(targetPattern, query);
            }
            catch (Exception e) {
                throw new JMXRuntimeException((Throwable)e);
            }
            if (deployedObjects[i] != null) {
                deployedObjectsCount += deployedObjects[i].size();
            }
            ++i;
        }
        HashSet tgts = new HashSet();
        for (int j = 0; j < targetList.size(); ++j) {
            if (deployedObjects[j] == null) continue;
            Iterator iter = deployedObjects[j].iterator();
            while (iter.hasNext()) {
                tgts.add(iter.next());
            }
        }
        return tgts;
    }
}

