/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.OC4JServiceInfo;
import com.evermind.server.http.deployment.FilterDescriptor;
import com.evermind.server.http.deployment.MimeMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.exceptions.InvalidArgumentValueException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.callbackinterfaces.WebModuleCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.J2EEWSModuleBase;
import oracle.oc4j.admin.management.mbeans.WebModuleMBean;
import oracle.oc4j.admin.management.shared.WebBinding;
import oracle.oc4j.admin.management.shared.WebModuleFilter;
import oracle.oc4j.admin.management.shared.WebModuleInitParam;
import oracle.oc4j.admin.management.shared.WebModuleJspConfig;
import oracle.oc4j.admin.management.shared.WebModuleLocaleEncodingMapping;
import oracle.oc4j.admin.management.shared.WebModuleLoginConfig;
import oracle.oc4j.admin.management.shared.WebModuleMimeMapping;
import oracle.oc4j.admin.management.shared.statistic.WebModuleStatsImpl;

public class WebModule
extends J2EEWSModuleBase
implements WebModuleMBean {
    private static Logger logger_ = TraceLogger.getLogger(WebModule.class);
    static final boolean DEBUG_PERSISTENCE = false;
    WebModuleCallBackIf callBackIf_ = null;

    public WebModule(WebModuleCallBackIf callBackIf, String j2eeAppName, String j2eeServerName, String moduleName, String domain) {
        super(callBackIf, moduleName, j2eeAppName, j2eeServerName, domain);
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=WebModule,name=" + this.getModuleName() + ",J2EEApplication=" + this.getApplicationName() + ",J2EEServer=" + this.getJ2eeServerName());
        this.init();
    }

    public WebModule(WebModuleCallBackIf callBackIf, String j2eeAppName, String moduleName) {
        super(callBackIf, moduleName, j2eeAppName);
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=WebModule,name=" + this.getModuleName() + ",J2EEApplication=" + this.getApplicationName() + ",J2EEServer=" + this.getJ2eeServerName());
        this.init();
    }

    public WebModule(Locale loc) {
        super(loc);
        this.init();
    }

    protected void init() {
        HashMap<String, String> persistenceDescriptorProperties = new HashMap<String, String>();
        persistenceDescriptorProperties.put("persistPolicy", "OnUpdate");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("Servlets", "[Ljavax.management.ObjectName;", this.getLocalizedMessage("webmodule_servlets"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("JSPs", "[Ljavax.management.ObjectName;", this.getLocalizedMessage("webmodule_JSPs"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("webURL", "java.lang.String", this.getLocalizedMessage("webmodule_WebURL"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("stats", "javax.management.j2ee.statistics.Stats", this.getLocalizedMessage("webmodule_stats"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("J2eeWebSites", "[Ljavax.management.ObjectName;", this.getLocalizedMessage("webmodule_j2eewebsites"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("ohsRouting", "java.lang.Boolean", this.getLocalizedMessage("webmodule_OHSRouting"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("description", "java.lang.String", this.getLocalizedMessage("webmodule_description"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("displayName", "java.lang.String", this.getLocalizedMessage("webmodule_displayName"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("distributable", Boolean.TYPE.getName(), this.getLocalizedMessage("webmodule_distributable"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("contextParams", "java.util.List", this.getLocalizedMessage("webmodule_contextParams"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("filters", "java.util.List", this.getLocalizedMessage("webmodule_filters"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("filterMappings", "java.util.List", this.getLocalizedMessage("webmodule_filterMappings"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("servletMappings", "java.util.List", this.getLocalizedMessage("webmodule_servletMappings"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("sessionTimeout", Integer.TYPE.getName(), this.getLocalizedMessage("webmodule_sessionTimeout"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("mimeMappings", "java.util.List", this.getLocalizedMessage("webmodule_mimeMappings"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("welcomeFileList", "java.util.List", this.getLocalizedMessage("webmodule_welcomeFileList"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("errorPages", "java.util.List", this.getLocalizedMessage("webmodule_errorPages"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("securityConstraint", "java.util.List", this.getLocalizedMessage("webmodule_securityConstraint"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("loginConfig", "oracle.oc4j.admin.management.shared.WebModuleLoginConfig", this.getLocalizedMessage("webmodule_loginConfig"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("securityRoles", "java.util.List", this.getLocalizedMessage("webmodule_securityRoles"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("jspConfig", "oracle.oc4j.admin.management.shared.WebModuleJspConfig", this.getLocalizedMessage("webmodule_jspConfig"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("ejbRefs", "java.util.List", this.getLocalizedMessage("webmodule_ejbRefs"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("ejbLocalRefs", "java.util.List", this.getLocalizedMessage("webmodule_ejbLocalRefs"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("resourceRefs", "java.util.List", this.getLocalizedMessage("webmodule_resourceRefs"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("resourceEnvRefs", "java.util.List", this.getLocalizedMessage("webmodule_resourceEnvRefs"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("messageDestinationRefs", "java.util.List", this.getLocalizedMessage("webmodule_messageDestinationRefs"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("localeEncodingMappingList", "java.util.List", this.getLocalizedMessage("webmodule_localeEncodingMappingList"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("envEntries", "java.util.List", this.getLocalizedMessage("webmodule_envEntries"), true, false, false));
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("path", "java.lang.String", this.getLocalizedMessage("webmodule_welcomeFile"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addWelcomeFile", this.getLocalizedMessage("webmodule_addWelcomeFile"), params, "void", 1), persistenceDescriptorProperties);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeWelcomeFile", this.getLocalizedMessage("webmodule_removeWelcomeFile"), params, "void", 1), persistenceDescriptorProperties);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("filterName", "java.lang.String", this.getLocalizedMessage("webmodule_filterName")), new MBeanParameterInfo("URLPattern", "java.lang.String", this.getLocalizedMessage("webmodule_urlPattern")), new MBeanParameterInfo("servletName", "java.lang.String", this.getLocalizedMessage("webmodule_servletName")), new MBeanParameterInfo("dispatchers", "[Ljava.lang.String;", this.getLocalizedMessage("webmodule_dispatchers"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addFilterMapping", this.getLocalizedMessage("webmodule_addFilterMapping"), params, "void", 1), persistenceDescriptorProperties);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("filterName", "java.lang.String", this.getLocalizedMessage("webmodule_filterName")), new MBeanParameterInfo("URLPattern", "java.lang.String", this.getLocalizedMessage("webmodule_urlPattern")), new MBeanParameterInfo("servletName", "java.lang.String", this.getLocalizedMessage("webmodule_servletName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeFilterMapping", this.getLocalizedMessage("webmodule_removeFilterMapping"), params, "void", 1), persistenceDescriptorProperties);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", this.getLocalizedMessage("webmodule_servletName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("loadServletMBean", this.getLocalizedMessage("webmodule_loadServletMBean"), params, "void", 1), persistenceDescriptorProperties);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("loadAllServletMBeans", this.getLocalizedMessage("webmodule_loadAllServletMBeans"), null, "void", 1), persistenceDescriptorProperties);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("distributable", "boolean", this.getLocalizedMessage("webmodule_distributable"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setDistributable", this.getLocalizedMessage("webmodule_setDistributable"), params, "void", 1), persistenceDescriptorProperties);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("updateOHSRoutingDetail", this.getLocalizedMessage("webmodule_updateOHSRoutingDetail"), new MBeanParameterInfo[0], "void", 1));
    }

    public String getDescription() {
        return this.getLocalizedMessage("webmodule_description");
    }

    public ObjectName[] getServlets() throws JMXException {
        String servletPattern = "*:j2eeType=Servlet,WebModule=" + this.getModuleName() + ",J2EEApplication=" + this.getApplicationName() + ",J2EEServer=" + this.getJ2eeServerName() + ",*";
        return this.getObjectNameForPattern(servletPattern);
    }

    public ObjectName[] getJSPs() throws JMXException {
        String jspPattern = "*:j2eeType=JSP,WebModule=" + this.getModuleName() + ",J2EEApplication=" + this.getApplicationName() + ",J2EEServer=" + this.getJ2eeServerName() + ",*";
        return this.getObjectNameForPattern(jspPattern);
    }

    public String[] getservlets() throws JMXException {
        ObjectName[] objs = this.getServlets();
        if (objs == null) {
            return null;
        }
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return res;
    }

    public ObjectName[] getJ2eeWebSites() {
        try {
            HashSet<WebBinding> res = new HashSet<WebBinding>();
            String j2eeWebSitePattern = "*:j2eeType=J2EEWebSite,J2EEServer=" + this.getJ2eeServerName() + ",*";
            ObjectName[] webSites = this.getObjectNameForPattern(j2eeWebSitePattern);
            String domain = this.getDomain();
            MBeanServer mbeanServer = this.getMBeanServer(domain);
            for (int i = 0; i < webSites.length; ++i) {
                WebBinding[] appBindings = (WebBinding[])mbeanServer.getAttribute(webSites[i], "webApplicationsInfo");
                for (int j = 0; j < appBindings.length; ++j) {
                    if (!this.getModuleName().equals(appBindings[j].getWebModule()) || !this.getApplicationName().equals(appBindings[j].getApplication())) continue;
                    res.add(appBindings[j]);
                    break;
                }
                WebBinding defaultAppBinding = (WebBinding)mbeanServer.getAttribute(webSites[i], "defaultWebApplicationInfo");
                if (!this.getModuleName().equals(defaultAppBinding.getWebModule()) || !this.getApplicationName().equals(defaultAppBinding.getApplication())) continue;
                res.add(defaultAppBinding);
            }
            ObjectName[] j2eeWebSites = new ObjectName[res.size()];
            Iterator it = res.iterator();
            int c = 0;
            while (it.hasNext()) {
                WebBinding binding = (WebBinding)it.next();
                String webSiteName = this.getDomain() + ":j2eeType=J2EEWebSite,name=" + binding.getWebSiteName() + ",J2EEServer=" + this.getJ2eeServerName();
                j2eeWebSites[c++] = ObjectNameFactory.create((String)webSiteName);
            }
            return j2eeWebSites;
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String getwebURL() {
        return this.callBackIf_.getWebURL();
    }

    public Boolean getohsRouting() {
        try {
            ObjectName[] webSites = this.getJ2eeWebSites();
            String domain = this.getDomain();
            MBeanServer mbeanServer = this.getMBeanServer(domain);
            boolean res = true;
            Object[] params = new Object[]{this.getObjectName().toString()};
            String[] signature = new String[]{"java.lang.String"};
            for (int i = 0; i < webSites.length; ++i) {
                String protocol = (String)mbeanServer.getAttribute(webSites[i], "protocol");
                if (!protocol.equalsIgnoreCase(OC4JServiceInfo.AJP13)) continue;
                Boolean ohsrouting = (Boolean)mbeanServer.invoke(webSites[i], "getOHSRouting", params, signature);
                res = res && ohsrouting != false;
            }
            return new Boolean(res);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public void setohsRouting(Boolean value) {
        try {
            ObjectName[] webSites = this.getJ2eeWebSites();
            String domain = this.getDomain();
            MBeanServer mbeanServer = this.getMBeanServer(domain);
            boolean res = true;
            Object[] params = new Object[]{this.getObjectName().toString(), value};
            String[] signature = new String[]{"java.lang.String", "java.lang.Boolean"};
            for (int i = 0; i < webSites.length; ++i) {
                String protocol = (String)mbeanServer.getAttribute(webSites[i], "protocol");
                if (!protocol.equalsIgnoreCase(OC4JServiceInfo.AJP13)) continue;
                mbeanServer.invoke(webSites[i], "setOHSRouting", params, signature);
            }
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public void updateOHSRoutingDetail() {
        try {
            ObjectName[] webSites = this.getJ2eeWebSites();
            MBeanServer mbeanServer = this.getMBeanServer(this.getDomain());
            Object[] params = new Object[]{this.getObjectName().toString()};
            String[] signature = new String[]{"java.lang.String"};
            for (int i = 0; i < webSites.length; ++i) {
                String protocol = (String)mbeanServer.getAttribute(webSites[i], "protocol");
                if (!protocol.equalsIgnoreCase(OC4JServiceInfo.AJP13)) continue;
                mbeanServer.invoke(webSites[i], "updateOHSRoutingDetail", params, signature);
            }
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public List getcontextParams() {
        return this.callBackIf_.getContextParams();
    }

    public String getdescription() {
        return this.callBackIf_.getDescription();
    }

    public String getdisplayName() {
        return this.callBackIf_.getDisplayName();
    }

    public boolean getdistributable() {
        return this.callBackIf_.isDistributable();
    }

    public void setDistributable(boolean distributable) {
        try {
            this.callBackIf_.setDistributable(distributable, true);
        }
        catch (IOException e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public List getservletMappings() {
        return this.callBackIf_.getLocalServletMappings();
    }

    public List getmimeMappings() {
        ArrayList<WebModuleMimeMapping> list = this.callBackIf_.getLocalMimeMappings();
        if (list.isEmpty()) {
            return list;
        }
        Iterator mappings = list.iterator();
        list = new ArrayList<WebModuleMimeMapping>();
        while (mappings.hasNext()) {
            MimeMapping m = (MimeMapping)mappings.next();
            list.add(new WebModuleMimeMapping((String)m.getKey(), (String)m.getValue()));
        }
        return list;
    }

    public List geterrorPages() {
        return this.callBackIf_.getLocalErrorPages();
    }

    public WebModuleLoginConfig getloginConfig() {
        return this.callBackIf_.getLoginConfig();
    }

    public WebModuleJspConfig getjspConfig() {
        return this.callBackIf_.getJspConfig();
    }

    public List getfilters() {
        List filterConfigs = this.callBackIf_.getLocalFilters();
        ArrayList<WebModuleFilter> filters = new ArrayList<WebModuleFilter>(filterConfigs.size());
        for (int i = 0; i < filterConfigs.size(); ++i) {
            FilterDescriptor config = (FilterDescriptor)filterConfigs.get(i);
            WebModuleFilter filter = new WebModuleFilter(config.getDescription(), config.getDisplayName(), config.getIcon() == null ? null : config.getIcon().toString(), config.getName(), config.getClassName(), null);
            ArrayList<WebModuleInitParam> params = new ArrayList<WebModuleInitParam>();
            Iterator<Map.Entry<Object, Object>> iterator = config.getInitParameters().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String description = config.getInitParamDescriptions().getProperty(entry.getKey().toString());
                params.add(new WebModuleInitParam(description, entry.getKey().toString(), entry.getValue().toString()));
            }
            filter.setInitParams(params);
            filters.add(filter);
        }
        return filters;
    }

    public List getfilterMappings() {
        return this.callBackIf_.getLocalFilterMappings();
    }

    public void setfilterMappings(List filterMappings) {
        this.callBackIf_.setFilterMappings(filterMappings);
    }

    public void addFilterMapping(String filterName, String URLPattern, String servletName, String[] dispatchers) throws InvalidArgumentValueException {
        if (filterName == null || filterName.length() == 0) {
            throw new InvalidArgumentValueException("filter-name must be set", "filter-mapping");
        }
        if (!(URLPattern != null && URLPattern.length() != 0 || servletName != null && servletName.length() != 0)) {
            throw new InvalidArgumentValueException("Either url-pattern or servlet-name should be set", "filter-mapping");
        }
        try {
            this.callBackIf_.addFilterMapping(filterName, URLPattern, servletName, dispatchers);
        }
        catch (Exception e) {
            throw new InvalidArgumentValueException(e.getMessage(), e, "filterMappings");
        }
    }

    public void removeFilterMapping(String filterName, String URLPattern, String servletName) throws InvalidArgumentValueException {
        if (filterName == null || filterName.length() == 0) {
            throw new InvalidArgumentValueException("filter-name must be set", "filter-mapping");
        }
        if (!(URLPattern != null && URLPattern.length() != 0 || servletName != null && servletName.length() != 0)) {
            throw new InvalidArgumentValueException("Either url-pattern or servlet-name should be set", "filter-mapping");
        }
        try {
            this.callBackIf_.removeFilterMapping(filterName, URLPattern, servletName);
        }
        catch (Exception e) {
            throw new InvalidArgumentValueException(e.getMessage(), e, "filterMappings");
        }
    }

    public int getsessionTimeout() {
        return this.callBackIf_.getSessionTimeout();
    }

    public void setsessionTimeout(int timeout) {
        this.callBackIf_.setSessionTimeout(timeout);
    }

    public void setSessionTimeout(int timeout) {
        this.setsessionTimeout(timeout);
    }

    public List getwelcomeFileList() {
        return this.callBackIf_.getWelcomeFiles();
    }

    public void setwelcomeFileList(List files) {
        this.callBackIf_.setWelcomeFiles(files);
    }

    public void addWelcomeFile(String filename) {
        this.callBackIf_.addNewWelcomeFile(filename);
    }

    public void removeWelcomeFile(String filename) {
        this.callBackIf_.removeWelcomeFile(filename);
    }

    public List getsecurityConstraint() {
        return this.callBackIf_.getSecurityConstraints();
    }

    public List getsecurityRoles() {
        return this.callBackIf_.getSecurityRoles();
    }

    public List getejbRefs() {
        return this.callBackIf_.getRemoteEJBReferences();
    }

    public List getejbLocalRefs() {
        return this.callBackIf_.getLocalEJBReferences();
    }

    public List getresourceRefs() {
        return this.callBackIf_.getResourceReferences();
    }

    public List getresourceEnvRefs() {
        return this.callBackIf_.getResourceEnvironmentReferences();
    }

    public List getmessageDestinationRefs() {
        return this.callBackIf_.getDestinationReferences();
    }

    public List getlocaleEncodingMappingList() {
        HashMap map = this.callBackIf_.getLocaleEncodingMappingList();
        if (map != null && !map.isEmpty()) {
            Iterator locales = map.keySet().iterator();
            ArrayList<WebModuleLocaleEncodingMapping> mappingList = new ArrayList<WebModuleLocaleEncodingMapping>();
            while (locales.hasNext()) {
                String locale = (String)locales.next();
                mappingList.add(new WebModuleLocaleEncodingMapping(locale, (String)map.get(locale)));
            }
            return mappingList;
        }
        return Collections.EMPTY_LIST;
    }

    public void loadAllServletMBeans() {
        this.callBackIf_.loadAllServletMBeans(this.getApplicationName(), this.getModuleName());
    }

    public void loadServletMBean(String name) {
        this.callBackIf_.loadServletMBean(this.getApplicationName(), this.getModuleName(), name);
    }

    public List getenvEntries() {
        return this.callBackIf_.getEnvironmentEntries();
    }

    public boolean getstatisticsProvider() {
        return true;
    }

    public Stats getstats() {
        return new WebModuleStatsImpl(this.getApplicationName(), this.getModuleName(), J2EEManagedObjectBase.getLocaleForCall());
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        try {
            this.callBackIf_.persistUpdates();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }
}

