/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.MessageLocalizationHelper;
import oracle.oc4j.admin.jmx.shared.deploy.NotificationUserData;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.TimerServiceCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEStateManageableObjectBase;
import oracle.oc4j.admin.management.mbeans.TimerServiceMBean;
import oracle.oc4j.admin.management.shared.Timer;

public class TimerService
extends J2EEStateManageableObjectBase
implements TimerServiceMBean {
    private static Logger logger_ = TraceLogger.getLogger(TimerService.class);
    private TimerServiceCallBackIf callBackIf_ = null;

    public TimerService(Locale loc) {
        super(loc);
        this.init();
    }

    public TimerService(TimerServiceCallBackIf callBackIf, String domain, String j2eeServerName) {
        super(callBackIf, domain, j2eeServerName);
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=TimerService,J2EEServer=" + this.getJ2eeServerName());
        this.init();
    }

    public TimerService(TimerServiceCallBackIf callBackIf) {
        super(callBackIf);
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=TimerService,J2EEServer=" + this.getJ2eeServerName());
        this.init();
    }

    private void init() {
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getTimers", this.getLocalizedMessage("timerservice_getTimers"), new MBeanParameterInfo[0], "java.util.List", 0));
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("beanName", "java.lang.String", this.getLocalizedMessage("timerservice_getTimers_beanName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getTimers", this.getLocalizedMessage("timerservice_getTimers"), params, "java.util.List", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("startTime", "long", this.getLocalizedMessage("timerservice_getExpiringTimers_startTime")), new MBeanParameterInfo("endTime", "long", this.getLocalizedMessage("timerservice_getExpiringTimers_endTime"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getExpiringTimers", this.getLocalizedMessage("timerservice_getExpiringTimers_startTime_endTime"), params, "java.util.List", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("containerID", "long", this.getLocalizedMessage("timerservice_findTimerById_containerID")), new MBeanParameterInfo("timerID", "long", this.getLocalizedMessage("timerservice_findTimerById_timerID"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("findTimerById", this.getLocalizedMessage("timerservice_findTimerById_containerID_timerID"), params, "java.util.List", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("timer", "oracle.oc4j.admin.management.shared.Timer", this.getLocalizedMessage("timerservice_cancel_timer"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("cancel", this.getLocalizedMessage("timerservice_cancel"), params, "void", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("timer", "oracle.oc4j.admin.management.shared.Timer", this.getLocalizedMessage("timerservice_getEJBName_timer"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getEJBName", this.getLocalizedMessage("timerservice_getEJBName"), params, "String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("timer", "oracle.oc4j.admin.management.shared.Timer", this.getLocalizedMessage("timerservice_getEJBApplication_timer"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getEJBApplication", this.getLocalizedMessage("timerservice_getEJBApplication"), params, "String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("timer", "oracle.oc4j.admin.management.shared.Timer", this.getLocalizedMessage("timerservice_getEJBJar_timer"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getEJBJar", this.getLocalizedMessage("timerservice_getEJBJar"), params, "String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("timer", "oracle.oc4j.admin.management.shared.Timer", this.getLocalizedMessage("timerservice_getNextExecution_timer"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getNextExecution", this.getLocalizedMessage("timerservice_getNextExecution"), params, "String", 0));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("timer", "oracle.oc4j.admin.management.shared.Timer", this.getLocalizedMessage("timerservice_getLastExecution_timer"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getLastExecution", this.getLocalizedMessage("timerservice_getLastExecution"), params, "String", 0));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getstartTime", this.getLocalizedMessage("timerservice_getstartTime"), null, "long", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getstate", this.getLocalizedMessage("timerservice_getstate"), null, "int", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("startRecursive", this.getLocalizedMessage("timerservice_startRecursive"), null, "void", 1));
    }

    public List getTimers() {
        return this.callBackIf_.getTimers();
    }

    public List getTimers(String fullBeanName) {
        return this.callBackIf_.getTimers(fullBeanName);
    }

    public List getExpiringTimers(long startTime, long endTime) {
        return this.callBackIf_.getExpiringTimers(startTime, endTime);
    }

    public List getEJBTimers() {
        return this.callBackIf_.getEJBTimers();
    }

    public Timer findTimerById(long containerID, long timerID) {
        return this.callBackIf_.findTimerById(containerID, timerID);
    }

    public void cancel(Timer timer) {
        this.callBackIf_.cancel(timer);
    }

    public String getEJBName(Timer timer) {
        return this.callBackIf_.getEJBName(timer);
    }

    public String getEJBApplication(Timer timer) {
        return this.callBackIf_.getEJBApplication(timer);
    }

    public String getEJBJar(Timer timer) {
        return this.callBackIf_.getEJBJar(timer);
    }

    public String getNextExecution(Timer timer) {
        return this.callBackIf_.getNextExecution(timer);
    }

    public String getLastExecution(Timer timer) {
        return this.callBackIf_.getLastExecution(timer);
    }

    public final void start() {
        block11: {
            MessageLocalizationHelper locHelp;
            block10: {
                ResourceBundle bundle = this.getResourceBundle();
                locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                if (this.getstate() == 1 || this.getstate() == 0) {
                    this.reportStateManagementSuccess("j2ee.state.running", locHelp.getLocalizedMessage("statemanageable_success_start"));
                    return;
                }
                if (this.getstate() == 2) {
                    ObjectName thisObj = null;
                    try {
                        thisObj = this.getObjectName();
                    }
                    catch (MalformedObjectNameException e) {
                        // empty catch block
                    }
                    throw new JMXRuntimeException("TimerService: " + thisObj + " currently stopping. It cannot be started until stop operation completes.");
                }
                try {
                    Notification notification = new Notification("j2ee.state.starting", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_starting") + this.getobjectName());
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                this.callBackIf_.start();
                this.reportStateManagementSuccess("j2ee.state.running", locHelp.getLocalizedMessage("statemanageable_success_start"));
            }
            catch (Throwable t) {
                try {
                    Notification notification = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_start") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                    notification.setUserData(userData);
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block11;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public final void startRecursive() {
        this.start();
    }

    public final void stop() {
        block11: {
            MessageLocalizationHelper locHelp;
            block10: {
                ResourceBundle bundle = this.getResourceBundle();
                locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                if (this.getstate() == 3 || this.getstate() == 2) {
                    this.reportStateManagementSuccess("j2ee.state.stopped", locHelp.getLocalizedMessage("statemanageable_success_stop"));
                    return;
                }
                if (this.getstate() == 0) {
                    ObjectName thisObj = null;
                    try {
                        thisObj = this.getObjectName();
                    }
                    catch (MalformedObjectNameException e) {
                        // empty catch block
                    }
                    throw new JMXRuntimeException("MDB: " + thisObj + " currently starting. It cannot be stopped until start operation completes.");
                }
                try {
                    Notification notification = new Notification("j2ee.state.stopping", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_stopping") + this.getobjectName());
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                this.callBackIf_.stop();
                this.reportStateManagementSuccess("j2ee.state.stopped", locHelp.getLocalizedMessage("statemanageable_success_stop"));
            }
            catch (Throwable t) {
                try {
                    Notification notification = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_stop") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                    notification.setUserData(userData);
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block11;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public final long getstartTime() {
        return this.callBackIf_.getstartTime();
    }

    public final int getstate() {
        return this.callBackIf_.getstate();
    }

    private void reportStateManagementSuccess(String nofifType, String notifMsg) {
        block2: {
            try {
                Notification notification = new Notification(nofifType, this.getObjectName(), 0L, new Date().getTime(), notifMsg + this.getObjectName());
                NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                notification.setUserData(userData);
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block2;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

