/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Locale;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.management.callbackinterfaces.J2EEApplicationCallBackIf;
import oracle.oc4j.admin.management.mbeans.JDBCBase;
import oracle.oc4j.admin.management.mbeans.JDBCDataSourceMBean;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.mbean.MBeanUtils;

public abstract class JDBCDataSource
extends JDBCBase
implements JDBCDataSourceMBean {
    private String m_jdbcResourceName = null;

    public JDBCDataSource(String jdbcResourceName, String name, J2EEApplicationCallBackIf applicationCallBack) throws IllegalArgumentException {
        super(name, applicationCallBack);
        if (jdbcResourceName == null) {
            throw new IllegalArgumentException("The JDBC Resource Name cannot be null.");
        }
        this.m_jdbcResourceName = jdbcResourceName;
        this.setBaseObjectName();
        this.init();
    }

    protected JDBCDataSource(Locale locale) {
        super(locale);
        this.init();
    }

    protected void setBaseObjectName() {
        this.setBaseObjectName(MBeanUtils.getJDBCDataSourceObjectName(this.getName(), this.getJdbcResourceName(), this.getApplicationName(), this.getJ2eeServerName()));
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("jdbcDriver", "java.lang.String", this.getLocalizedMessage("jdbcdatasource_jdbcDriver"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("dataSourceName", "java.lang.String", this.getLocalizedMessage("jdbcdatasource_dataSourceName"), true, true, false), ON_APPLICATION_RESTART_ONUPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("jndiName", "java.lang.String", this.getLocalizedMessage("jdbcdatasource_jndiName"), true, false, false), NEVER_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("user", "java.lang.String", this.getLocalizedMessage("jdbcdatasource_user"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("password", "java.lang.String", this.getLocalizedMessage("jdbcdatasource_password"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("loginTimeout", "java.lang.Integer", this.getLocalizedMessage("jdbcdatasource_loginTimeout"), true, true, false), ON_UPDATE_PERSISTENCE_PROPERTIES);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("newDataSourceName", "java.lang.String", this.getLocalizedMessage("jdbcdatasource_copyDataSource_newDataSourceName")), new MBeanParameterInfo("jndiLocation", "java.lang.String", this.getLocalizedMessage("jdbcdatasource_copyDataSource_jndiLocation"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("copyDataSource", this.getLocalizedMessage("jdbcdatasource_copyDataSource"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeDataSource", this.getLocalizedMessage("jdbcdatasource_removeDataSource"), params, "void", 1), ON_UPDATE_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("sqlStatement", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_sqlStatement")), new MBeanParameterInfo("user", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_user")), new MBeanParameterInfo("password", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_password"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("testConnection", this.getLocalizedMessage("jdbc_testConnection"), params, "java.lang.String", 1), NEVER_PERSISTENCE_PROPERTIES);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("sqlStatement", "java.lang.String", this.getLocalizedMessage("jdbc_testConnection_sqlStatement"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("testConnection", this.getLocalizedMessage("jdbc_testConnection"), params, "java.lang.String", 1), NEVER_PERSISTENCE_PROPERTIES);
    }

    public String getDescription() {
        return this.getLocalizedMessage("jdbcdatasource_description");
    }

    public String getjdbcDriver() throws JMXException {
        return "";
    }

    public String getJdbcResourceName() {
        return this.m_jdbcResourceName;
    }

    public abstract void copyDataSource(String var1, String var2) throws MBeanException;

    public abstract void removeDataSource() throws MBeanException, DataSourceException;

    public abstract String testConnection(String var1);

    public abstract String testConnection(String var1, String var2, String var3);

    public abstract String getdataSourceName();

    public abstract void setdataSourceName(String var1) throws DataSourceConfigException, MBeanException;

    public abstract String getjndiName();

    public abstract String getuser();

    public abstract void setuser(String var1) throws MBeanException;

    public abstract String getpassword();

    public abstract void setpassword(String var1) throws MBeanException;

    public abstract int getloginTimeout() throws MBeanException;

    public abstract void setloginTimeout(Integer var1) throws MBeanException;
}

