/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.connector.deployment.ConfigurationProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.callbackinterfaces.JCAAdminObjectInstanceCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JCAAdminObjectInstanceMBean;
import oracle.oc4j.admin.management.shared.JCAConfigurationProperty;

public class JCAAdminObjectInstance
extends J2EEServerDependentObjectBase
implements JCAAdminObjectInstanceMBean {
    private static Logger logger_ = TraceLogger.getLogger(JCAAdminObjectInstance.class);
    private JCAAdminObjectInstanceCallBackIf callBackIf_ = null;
    private String searchPattern = null;
    private ObjectName RAMODULE_OBJECT_NAME = null;
    static final boolean DEBUG_PERSISTENCE = false;

    public JCAAdminObjectInstance(String connectorName, String moduleName, String j2eeAppName, String j2eeServerName, String domain, JCAAdminObjectInstanceCallBackIf callBackIf) {
        super(domain, j2eeServerName);
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=JCAAdminObjectInstance,name=" + this.callBackIf_.getLocation() + ",ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + j2eeServerName);
        this.searchPattern = "*:j2eeType=JCAAdminObject,name=" + this.callBackIf_.getAdminObjectClass() + ",ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + j2eeServerName;
        this.init();
        this.RAMODULE_OBJECT_NAME = ObjectNameFactory.create((String)("*:j2eeType=ResourceAdapterModule,name=" + moduleName + ",*"));
    }

    public JCAAdminObjectInstance(String connectorName, String moduleName, String j2eeAppName, JCAAdminObjectInstanceCallBackIf callBackIf) {
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=JCAAdminObjectInstance,name=" + this.callBackIf_.getLocation() + ",ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + this.getJ2eeServerName());
        this.searchPattern = "*:j2eeType=JCAAdminObject,name=" + this.callBackIf_.getAdminObjectClass() + ",ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + this.getJ2eeServerName();
        this.init();
        this.RAMODULE_OBJECT_NAME = ObjectNameFactory.create((String)("*:j2eeType=ResourceAdapterModule,name=" + moduleName + ",*"));
    }

    public JCAAdminObjectInstance(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        HashMap<String, String> persistenceDescriptorProperties = new HashMap<String, String>();
        persistenceDescriptorProperties.put("persistPolicy", "OnUpdate");
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("persistPolicy", "OnUpdate");
        metaData.put("requireRestart", "applicationRestart");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("adminObjectType", "java.lang.String", this.getLocalizedMessage("adminobjectinstance_adminObjectType"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("adminObjectClass", "java.lang.String", this.getLocalizedMessage("adminobjectinstance_adminObjectClass"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("configurationProperties", "java.util.List", this.getLocalizedMessage("adminobjectinstance_configurationProperties"), true, true, false), metaData);
    }

    public String getadminObjectType() throws JMXException {
        ObjectName[] res = null;
        res = this.getObjectNameForPattern(this.searchPattern);
        if (res.length == 1) {
            return res[0].toString();
        }
        throw new JMXException("Unable to get adminObjectType for JCA administered object instance via JMX");
    }

    public String getadminObjectClass() throws JMXException {
        return this.callBackIf_.getAdminObjectClass();
    }

    public List getconfigurationProperties() throws JMXException {
        Collection incomingProps = this.callBackIf_.getConfigurationProperties();
        if (incomingProps != null) {
            ArrayList<JCAConfigurationProperty> outgoingList = new ArrayList<JCAConfigurationProperty>(incomingProps.size());
            Iterator iter = incomingProps.iterator();
            while (iter.hasNext()) {
                JCAConfigurationProperty entry = new JCAConfigurationProperty((ConfigurationProperty)iter.next());
                outgoingList.add(entry);
            }
            return outgoingList;
        }
        return Collections.EMPTY_LIST;
    }

    public void setconfigurationProperties(List incomingProps) throws JMXException {
        if (incomingProps != null) {
            JCAConfigurationProperty entry;
            Iterator iter = incomingProps.iterator();
            while (iter.hasNext()) {
                try {
                    entry = (JCAConfigurationProperty)iter.next();
                }
                catch (ClassCastException e) {
                    throw new JMXException((Throwable)e, "Unable to set configuration properties on connection factory via MBean.");
                }
            }
            iter = incomingProps.iterator();
            while (iter.hasNext()) {
                entry = (JCAConfigurationProperty)iter.next();
                try {
                    this.callBackIf_.setConfigurationProperty(entry.getName(), entry.getDeployedValue());
                }
                catch (InstantiationException e) {
                    throw new JMXException((Throwable)e, "Unable to set configuration properties on connection factory via MBean.");
                }
            }
        }
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        Set<ObjectName> setOfMBeans = oc4jMBeanServer.queryNames(this.RAMODULE_OBJECT_NAME, null);
        Iterator<ObjectName> iterator = setOfMBeans.iterator();
        ObjectName objName = iterator.next();
        try {
            oc4jMBeanServer.invoke(objName, "persistConfigChange", null, new String[0]);
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }
}

