/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.AttributeValueExp;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.StringValueExp;
import javax.management.ValueExp;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.openmbean.CompositeData;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.oc4j.admin.JMXUtil;
import oracle.oc4j.admin.jmx.web.CompositeDataItem;
import oracle.oc4j.admin.jmx.web.Generator;
import oracle.oc4j.admin.jmx.web.HandlingException;
import oracle.oc4j.admin.jmx.web.HtmlGenerator;
import oracle.oc4j.admin.jmx.web.JMXConsoleListener;
import oracle.oc4j.admin.jmx.web.ServletLocalizationHelper;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;

public class RequestHandler {
    private HttpServletRequest req_ = null;
    private HttpServletResponse res_ = null;
    private MBeanServer mbeanServ_ = null;
    private Generator gen_ = null;
    private PrintWriter out_ = null;
    private String cmd_ = null;
    private String submitAction_ = null;
    private String domainName_ = null;
    private static ObjectName allObjectName_ = null;
    private static Map mbeanToStatAssociation_ = new HashMap();
    private ServletLocalizationHelper locHelper_ = null;
    String reqEncoding_ = null;
    private static Hashtable listeners_;
    private static Vector events_;

    public RequestHandler(HttpServletRequest req, HttpServletResponse res, MBeanServer mbeanServ, String domainName, String extraParam) throws IOException {
        this(req, res, mbeanServ, domainName);
        this.gen_.setExtraParam(extraParam);
    }

    public RequestHandler(HttpServletRequest req, HttpServletResponse res, MBeanServer mbeanServ, String domainName) throws IOException {
        this.req_ = req;
        this.res_ = res;
        this.mbeanServ_ = mbeanServ;
        this.domainName_ = domainName;
        this.reqEncoding_ = this.req_.getCharacterEncoding() != null ? this.req_.getCharacterEncoding() : this.res_.getCharacterEncoding();
        this.locHelper_ = new ServletLocalizationHelper("oracle.oc4j.admin.Messages", req, res);
        this.gen_ = new HtmlGenerator(this.domainName_, this.locHelper_);
        this.out_ = res.getWriter();
        this.cmd_ = this.req_.getParameter("command");
        if (this.cmd_ == null) {
            this.cmd_ = "ROOT";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest() {
        try {
            J2EEManagedObjectBase.setLocaleForCall(this.locHelper_.getLocale());
            if (this.cmd_.equals("ROOT")) {
                this.handleROOTCommand();
            } else if (this.cmd_.equals("SHOWMBEAN")) {
                this.handleSHOWMBEANCommand();
            } else if (this.cmd_.equals("JSR77NAMES")) {
                this.handleJSR77NAMESCommand();
            } else if (this.cmd_.equals("QUERYNAMES")) {
                this.handleQUERYNAMESCommand();
            } else if (this.cmd_.equals("SHOWATTRIBUTE")) {
                this.handleSHOWATTRIBUTECommand();
            } else if (this.cmd_.equals("SHOWOPERATION")) {
                this.handleSHOWOPERATIONCommand(null, false, false);
            } else if (this.cmd_.equals("SHOWNOTIFICATION")) {
                this.handleSHOWNOTIFICATIONCommand();
            } else if (this.cmd_.equals("SHOWSTATISTIC")) {
                this.handleSHOWSTATISTICCommand();
            } else if (this.cmd_.equals("SETATTRIBUTE")) {
                this.submitAction_ = this.req_.getParameter("submitAction");
                if (this.submitAction_ != null) {
                    if (this.submitAction_.equals("Set value")) {
                        this.handleSETATTRIBUTECommand();
                    } else if (this.submitAction_.equals("Input values")) {
                        this.handleSHOWINPUTARRAYFORMForAttributeCommand();
                    } else if (this.submitAction_.equals("Input values for Map")) {
                        this.handleSHOWINPUTMAPFORMFORATTRIBUTECommand();
                    }
                }
            } else if (this.cmd_.equals("INVOKEOPERATION")) {
                this.submitAction_ = this.req_.getParameter("submitAction");
                if (this.submitAction_ != null && this.submitAction_.equals("Invoke Method")) {
                    this.handleINVOKEOPERATIONCommand();
                } else {
                    int paramcnt = this.parseParamCount();
                    for (int i = 0; i < paramcnt; ++i) {
                        this.submitAction_ = this.req_.getParameter("submitAction" + i);
                        if (this.submitAction_ != null && this.submitAction_.equals("Input values")) {
                            this.handleSHOWINPUTARRAYFORMCommand(i);
                            continue;
                        }
                        if (this.submitAction_ != null && this.submitAction_.equals("Input values for Map")) {
                            this.handleSHOWINPUTMAPFORMCommand(i);
                            continue;
                        }
                        if (this.submitAction_ == null || !this.submitAction_.equals("Input values for CompositeData")) continue;
                        this.handleINPUTCOMPOSITEDATACommand(i);
                    }
                }
            } else if (this.cmd_.equals("INPUTARRAY")) {
                this.handleINPUTARRAYCommand();
            } else if (this.cmd_.equals("INPUTARRAYFORATTRIBUTE")) {
                this.handleINPUTARRAYFORATTRIBUTECommand();
            } else if (this.cmd_.equals("INPUTMAP")) {
                this.handleINPUTMAPCommand();
            } else if (this.cmd_.equals("INPUTCOMPOSITEDATA")) {
                this.handleINPUTCOMPOSITEDATACommand(-1);
            } else if (this.cmd_.equals("INPUTMAPFORATTRIBUTE")) {
                this.handleINPUTMAPFORATTRIBUTECommand();
            } else if (this.cmd_.equals("SHOWQUERYHELP")) {
                this.handleSHOWQUERYHELPCommand();
            } else if (this.cmd_.equals("SHOWFULLMBEANINFO")) {
                this.handleSHOWFULLMBEANINFOCommand();
            } else if (this.cmd_.equals("RLISTENER")) {
                this.handleRLISTENERCommand();
            } else if (this.cmd_.equals("URLISTENER")) {
                this.handleURLISTENERCommand();
            } else if (this.cmd_.equals("SHOWEVENTS")) {
                this.handleSHOWEVENTSCommand();
            } else if (this.cmd_.equals("SHOWLISTENERS")) {
                this.handleSHOWLISTENERSCommand();
            } else if (this.cmd_.equals("REMOVELISTENER")) {
                this.handleREMOVELISTENERCommand();
            } else if (this.cmd_.equals("CLEAREVENTS")) {
                this.handleCLEAREVENTSCommand();
            }
        }
        catch (HandlingException e) {
            this.gen_.reportError(e);
        }
        finally {
            J2EEManagedObjectBase.unsetLocaleForCall();
        }
        this.out_.println(this.gen_.getContent());
    }

    private void handleROOTCommand() {
        this.gen_.addHeader();
        this.gen_.addQueryForm("*:*");
        Set mbeans = this.getMBeans();
        Set domains = this.getDomains(mbeans);
        this.gen_.addMBeanList(mbeans, domains);
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleJSR77NAMESCommand() throws HandlingException {
        this.gen_.addHeader();
        String mbeanType = this.req_.getParameter("jsr77name");
        String query = null;
        query = "All".equals(mbeanType) ? "*:*" : "*:j2eeType=" + mbeanType + ",*";
        this.gen_.addQueryForm(query);
        Set mbeans = this.getMBeans(query);
        Set domains = this.getDomains(mbeans);
        this.gen_.addMBeanList(mbeans, domains);
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private void handleSHOWQUERYHELPCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.queryHelp();
        this.gen_.addQueryPageBackLink("*:*");
        this.gen_.addTrailer();
    }

    private void handleSHOWMBEANCommand() throws HandlingException {
        Stats stats;
        MBeanNotificationInfo[] notifInfos;
        MBeanOperationInfo[] operInfos;
        this.gen_.addHeader();
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        String className = mbeanInfo.getClassName();
        String desc = mbeanInfo.getDescription();
        this.gen_.addMBeanGeneralInfo(mbean, className, desc, mbeanInfo);
        MBeanAttributeInfo[] attrInfos = mbeanInfo.getAttributes();
        if (attrInfos != null && attrInfos.length != 0) {
            this.gen_.addAttributesInfo(attrInfos, mbean);
        }
        if ((operInfos = mbeanInfo.getOperations()) != null && operInfos.length != 0) {
            this.gen_.addOperationsInfo(operInfos, mbean);
        }
        if ((notifInfos = mbeanInfo.getNotifications()) != null && notifInfos.length != 0) {
            this.gen_.addNotificationInfo(notifInfos, mbean);
        }
        if ((stats = this.getStats(mbean)) != null) {
            this.gen_.addStats(stats, mbean);
        }
        this.gen_.addQueryPageBackLink("*:*");
        this.gen_.addTrailer();
    }

    private void handleSHOWATTRIBUTECommand() throws HandlingException {
        this.gen_.addHeader();
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String attribute = this.toUTF8(this.req_.getParameter("attribute"));
        String getval = this.toUTF8(this.req_.getParameter("getvalue"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanAttributeInfo theAttrib = this.getAttrInfo(mbeanInfo, attribute, mbean);
        Object val = null;
        if (getval != null & "y".equalsIgnoreCase(getval)) {
            boolean isObjectName;
            val = this.getAttributeValue(theAttrib, mbean);
            boolean bl = isObjectName = theAttrib.getType().indexOf("javax.management.ObjectName") != -1;
            if (isObjectName && val != null && !val.getClass().getName().equals(theAttrib.getType())) {
                throw new HandlingException(attribute + " attribute type is mismatching. The type returned by method get" + attribute + "() in the application MBean is " + val.getClass().getName() + ". But the type defined in MBeanAttributeInfo in the MBean is " + theAttrib.getType() + ". Please check for the type in the MBean.");
            }
            this.gen_.addAttributeInfo(theAttrib, mbean, val);
        } else {
            this.gen_.addAttributeInfo(theAttrib, mbean);
        }
        this.gen_.addMBeanPageBackLink(mbean);
        this.gen_.addTrailer();
    }

    private void handleSETATTRIBUTECommand() throws HandlingException {
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String attribute = this.toUTF8(this.req_.getParameter("attribute"));
        String value = this.toUTF8(this.req_.getParameter("value"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanAttributeInfo theAttrib = this.getAttrInfo(mbeanInfo, attribute, mbean);
        this.setAttribute(attribute, mbean, value, theAttrib.getType());
        this.handleSHOWATTRIBUTECommand();
    }

    private void handleSHOWOPERATIONCommand(Object retval, boolean displayResult, boolean isVoid) throws HandlingException {
        boolean isObjectName;
        this.gen_.addHeader();
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String operation = this.toUTF8(this.req_.getParameter("operation"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanOperationInfo operInfo = this.getOperationInfo(mbeanInfo, operation, mbean);
        this.gen_.addOperationInfo(operInfo, mbean);
        boolean bl = isObjectName = operInfo.getReturnType().indexOf("javax.management.ObjectName") != -1;
        if (displayResult) {
            if (isVoid) {
                this.gen_.addReturnValue(retval, true, isObjectName);
            } else {
                this.gen_.addReturnValue(retval, false, isObjectName);
            }
        }
        this.gen_.addMBeanPageBackLink(mbean);
        this.gen_.addTrailer();
    }

    private void handleSHOWFULLMBEANINFOCommand() throws HandlingException {
        this.gen_.addHeader();
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        Stats stats = this.getStats(mbean);
        this.gen_.addCompleteMBeanDescription(mbeanInfo, mbean, stats);
        this.gen_.addMBeanPageBackLink(mbean);
        this.gen_.addTrailer();
    }

    private void handleINVOKEOPERATIONCommand() throws HandlingException {
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String operation = this.toUTF8(this.req_.getParameter("operation"));
        int paramcnt = this.parseParamCount();
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanOperationInfo operInfo = this.getOperationInfo(mbeanInfo, operation, mbean);
        Vector<String> paramValues = new Vector<String>(paramcnt);
        for (int i = 0; i < paramcnt; ++i) {
            paramValues.add(i, this.req_.getParameter("param" + i));
        }
        Object retval = this.invokeOperation(operInfo, paramValues, mbean);
        boolean isVoid = operInfo.getReturnType().equals("void");
        this.handleSHOWOPERATIONCommand(retval, true, isVoid);
    }

    private void handleSHOWNOTIFICATIONCommand() throws HandlingException {
        this.gen_.addHeader();
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String notification = this.toUTF8(this.req_.getParameter("notification"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanNotificationInfo[] notifInf = mbeanInfo.getNotifications();
        MBeanNotificationInfo theNotif = null;
        for (int i = 0; i < notifInf.length; ++i) {
            if (!notification.equals(notifInf[i].getName())) continue;
            theNotif = notifInf[i];
            break;
        }
        if (theNotif == null) {
            throw new HandlingException(notification + " notification is not defined for mbean: " + mbean);
        }
        this.gen_.addNotification(theNotif, mbean);
        this.gen_.addMBeanPageBackLink(mbean);
        this.gen_.addTrailer();
    }

    private void handleSHOWEVENTSCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.displayReceivedEvents((Vector)events_.clone());
        this.gen_.addQueryPageBackLink("*:*");
        this.gen_.addTrailer();
    }

    private void handleCLEAREVENTSCommand() throws HandlingException {
        events_.clear();
        this.handleSHOWEVENTSCommand();
    }

    private void handleSHOWLISTENERSCommand() throws HandlingException {
        this.gen_.addHeader();
        this.gen_.displayRegisteredListeners((Hashtable)listeners_.clone());
        this.gen_.addQueryPageBackLink("*:*");
        this.gen_.addTrailer();
    }

    private void handleREMOVELISTENERCommand() throws HandlingException {
        try {
            String mbean = this.toUTF8(this.req_.getParameter("listener"));
            ObjectName objName = this.getObjectName(mbean);
            if (listeners_.containsKey(objName)) {
                JMXConsoleListener listener = (JMXConsoleListener)listeners_.get(objName);
                this.mbeanServ_.removeNotificationListener(objName, listener);
                listeners_.remove(objName);
            }
        }
        catch (Exception e) {
            throw new HandlingException(e);
        }
        this.handleSHOWLISTENERSCommand();
    }

    private void handleRLISTENERCommand() throws HandlingException {
        try {
            String mbean = this.toUTF8(this.req_.getParameter("mbean"));
            ObjectName objName = this.getObjectName(mbean);
            if (!listeners_.containsKey(objName)) {
                JMXConsoleListener listener = new JMXConsoleListener(events_);
                this.mbeanServ_.addNotificationListener(objName, listener, null, null);
                listeners_.put(objName, listener);
            }
        }
        catch (Exception e) {
            throw new HandlingException(e);
        }
        this.handleSHOWNOTIFICATIONCommand();
    }

    private void handleURLISTENERCommand() throws HandlingException {
        try {
            String mbean = this.toUTF8(this.req_.getParameter("mbean"));
            ObjectName objName = this.getObjectName(mbean);
            if (listeners_.containsKey(objName)) {
                JMXConsoleListener listener = (JMXConsoleListener)listeners_.get(objName);
                this.mbeanServ_.removeNotificationListener(objName, listener);
                listeners_.remove(objName);
            }
        }
        catch (Exception e) {
            throw new HandlingException(e);
        }
        this.handleSHOWNOTIFICATIONCommand();
    }

    private void handleSHOWSTATISTICCommand() throws HandlingException {
        this.gen_.addHeader();
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String statistic = this.toUTF8(this.req_.getParameter("statistic"));
        Stats stats = this.getStats(mbean);
        Statistic stat = stats.getStatistic(statistic);
        if (stat == null) {
            throw new HandlingException(statistic + " statistic is not defined for mbean: " + mbean);
        }
        this.gen_.addStatistic(stat, mbean);
        this.gen_.addMBeanPageBackLink(mbean);
        this.gen_.addTrailer();
    }

    private void handleQUERYNAMESCommand() throws HandlingException {
        this.gen_.addHeader();
        String query = this.toUTF8(this.req_.getParameter("query"));
        String attr = this.toUTF8(this.req_.getParameter("attr"));
        String op = this.req_.getParameter("op");
        String val = this.toUTF8(this.req_.getParameter("val"));
        this.gen_.addQueryForm(query, attr, op, val);
        QueryExp q = this.getQuery(attr, op, val);
        Set mbeans = this.getMBeans(query, q);
        Set domains = this.getDomains(mbeans);
        this.gen_.addMBeanList(mbeans, domains);
        this.gen_.addAdminBackLink();
        this.gen_.addTrailer();
    }

    private QueryExp getQuery(String attr, String op, String val) throws HandlingException {
        if (attr == null || attr.length() == 0) {
            return null;
        }
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            ValueExp vexp;
            AttributeValueExp attValExp = Query.attr(attr);
            int opv = Integer.parseInt(op);
            if (opv == 4 || opv == 2 || opv == 0 || opv == 3 || opv == 1) {
                vexp = null;
                try {
                    vexp = this.getValExp(val);
                }
                catch (NumberFormatException e) {
                    throw new HandlingException(e, this.locHelper_.getLocalizedMessage("WrongQueryValueType"));
                }
                if (opv == 4) {
                    return Query.eq(attValExp, vexp);
                }
                if (opv == 2) {
                    return Query.geq(attValExp, vexp);
                }
                if (opv == 0) {
                    return Query.gt(attValExp, vexp);
                }
                if (opv == 3) {
                    return Query.leq(attValExp, vexp);
                }
                if (opv == 1) {
                    return Query.lt(attValExp, vexp);
                }
            }
            if (opv == 1000) {
                vexp = Query.value(val);
                return Query.match(attValExp, (StringValueExp)vexp);
            }
            if (opv == 1001) {
                vexp = Query.value(val);
                return Query.anySubString(attValExp, (StringValueExp)vexp);
            }
            if (opv == 1002) {
                vexp = Query.value(val);
                return Query.initialSubString(attValExp, (StringValueExp)vexp);
            }
            if (opv == 1003) {
                vexp = Query.value(val);
                return Query.finalSubString(attValExp, (StringValueExp)vexp);
            }
        }
        catch (HandlingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HandlingException(e);
        }
        return null;
    }

    private ValueExp getValExp(String val) throws NumberFormatException {
        if ("true".equalsIgnoreCase(val)) {
            return Query.value(true);
        }
        if ("false".equalsIgnoreCase(val)) {
            return Query.value(false);
        }
        return Query.value(this.getNumber(val));
    }

    private Number getNumber(String val) throws NumberFormatException {
        try {
            return new Long(val);
        }
        catch (NumberFormatException e) {
            return new Double(val);
        }
    }

    private void handleSHOWINPUTARRAYFORMCommand(int paramNum) throws HandlingException {
        this.gen_.addHeader();
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String operation = this.toUTF8(this.req_.getParameter("operation"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanOperationInfo theOper = this.getOperationInfo(mbeanInfo, operation, mbean);
        int pageNum = 0;
        int elemNum = 10;
        Vector pageVector = new Vector();
        String page = this.req_.getParameter("pageNum");
        pageNum = page == null ? 0 : Integer.parseInt(page);
        String element = this.req_.getParameter("elemNum");
        elemNum = element == null ? 10 : Integer.parseInt(element);
        String pageVectorStr = this.req_.getParameter("pageVector");
        pageVector = pageVectorStr == null ? new Vector() : (Vector)JMXUtil.deserialize(pageVectorStr);
        int paramcnt = this.parseParamCount();
        Vector<String> paramVector = new Vector<String>(paramcnt);
        for (int i = 0; i < paramcnt; ++i) {
            paramVector.add(i, this.req_.getParameter("param" + i));
        }
        this.gen_.addInputArrayForm(mbean, theOper, pageNum, elemNum, JMXUtil.serialize(pageVector), paramNum, JMXUtil.serialize(paramVector), paramcnt);
        this.gen_.addTrailer();
    }

    private void handleSHOWINPUTMAPFORMCommand(int paramNum) throws HandlingException {
        this.gen_.addHeader();
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String operation = this.toUTF8(this.req_.getParameter("operation"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanOperationInfo theOper = this.getOperationInfo(mbeanInfo, operation, mbean);
        int pageNum = 0;
        int elemNum = 10;
        Vector pageVector = new Vector();
        String page = this.req_.getParameter("pageNum");
        pageNum = page == null ? 0 : Integer.parseInt(page);
        String element = this.req_.getParameter("elemNum");
        elemNum = element == null ? 10 : Integer.parseInt(element);
        String pageVectorStr = this.req_.getParameter("pageVector");
        pageVector = pageVectorStr == null ? new Vector() : (Vector)JMXUtil.deserialize(pageVectorStr);
        int paramcnt = this.parseParamCount();
        Vector<String> paramVector = new Vector<String>(paramcnt);
        for (int i = 0; i < paramcnt; ++i) {
            paramVector.add(i, this.req_.getParameter("param" + i));
        }
        this.gen_.addInputMapForm(mbean, theOper, pageNum, elemNum, JMXUtil.serialize(pageVector), paramNum, JMXUtil.serialize(paramVector), paramcnt);
        this.gen_.addTrailer();
    }

    private void handleINPUTARRAYCommand() throws HandlingException {
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String operation = this.toUTF8(this.req_.getParameter("operation"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanOperationInfo theOper = this.getOperationInfo(mbeanInfo, operation, mbean);
        Vector pageVector = new Vector();
        String page = this.req_.getParameter("pageNum");
        int pageNum = page == null ? 0 : Integer.parseInt(page);
        String element = this.req_.getParameter("elemNum");
        int elemNum = element == null ? 10 : Integer.parseInt(element);
        String pageVectorStr = this.req_.getParameter("pageVector");
        pageVector = pageVectorStr == null ? new Vector() : (Vector)JMXUtil.deserialize(pageVectorStr);
        int paramNum = 0;
        int paramcnt = 0;
        try {
            paramNum = new Integer(this.req_.getParameter("paramNum"));
            paramcnt = new Integer(this.req_.getParameter("paramCount"));
        }
        catch (NumberFormatException e) {
            throw new HandlingException(e, "Invalid value for paramNum Server parameter \nvalue: " + this.req_.getParameter("paramNum"));
        }
        MBeanParameterInfo[] params = theOper.getSignature();
        String typeOfParam = params[paramNum].getType();
        String typeOfElementOfCollection = this.req_.getParameter("typeOfCollection");
        String type = typeOfElementOfCollection != null ? typeOfElementOfCollection : typeOfParam;
        Vector<String> paramVector = new Vector<String>(paramcnt);
        String paramVectorStr = this.req_.getParameter("paramVector");
        paramVector = paramVectorStr == null ? new Vector<String>(paramcnt) : (Vector<String>)JMXUtil.deserialize(paramVectorStr);
        String submitAction = this.req_.getParameter("SubmitAction");
        if (submitAction.equals("Next")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageElements(elemNum, type));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, type));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, type));
            }
            this.gen_.addHeader();
            this.gen_.addInputArrayForm(mbean, theOper, ++pageNum, elemNum += 10, JMXUtil.serialize(pageVector), paramNum, JMXUtil.serialize(paramVector), paramcnt);
            this.gen_.addTrailer();
        } else if (submitAction.equals("Pre")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageElements(elemNum, type));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, type));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, type));
            }
            this.gen_.addHeader();
            this.gen_.addInputArrayForm(mbean, theOper, --pageNum, elemNum -= 10, JMXUtil.serialize(pageVector), paramNum, JMXUtil.serialize(paramVector), paramcnt);
            this.gen_.addTrailer();
        } else if (submitAction.equals("Done")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageElements(elemNum, type));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, type));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, type));
            }
            pageVector = this.recreateVector(pageVector);
            Object paramObject = !typeOfParam.equals(type) ? this.makeRealReturnTypeObject(pageVector, typeOfParam) : pageVector;
            if (paramNum < paramVector.size()) {
                paramVector.remove(paramNum);
            }
            paramVector.add(paramNum, JMXUtil.serialize(paramObject));
            this.gen_.addHeader();
            this.gen_.addOperationWithComplexParamsInfo(mbean, theOper, paramNum, paramVector);
            this.gen_.addMBeanPageBackLink(mbean);
            this.gen_.addTrailer();
        }
    }

    private void handleINPUTMAPCommand() throws HandlingException {
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String operation = this.toUTF8(this.req_.getParameter("operation"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanOperationInfo theOper = this.getOperationInfo(mbeanInfo, operation, mbean);
        Vector pageVector = new Vector();
        String page = this.req_.getParameter("pageNum");
        int pageNum = page == null ? 0 : Integer.parseInt(page);
        String element = this.req_.getParameter("elemNum");
        int elemNum = element == null ? 10 : Integer.parseInt(element);
        String pageVectorStr = this.req_.getParameter("pageVector");
        pageVector = pageVectorStr == null ? new Vector() : (Vector)JMXUtil.deserialize(pageVectorStr);
        int paramNum = 0;
        int paramcnt = 0;
        try {
            paramNum = new Integer(this.req_.getParameter("paramNum"));
            paramcnt = new Integer(this.req_.getParameter("paramCount"));
        }
        catch (NumberFormatException e) {
            throw new HandlingException(e, "Invalid value for paramNum Server parameter \nvalue: " + this.req_.getParameter("paramNum"));
        }
        MBeanParameterInfo[] params = theOper.getSignature();
        String typeOfParam = params[paramNum].getType();
        String typeOfEntryKey = this.req_.getParameter("typeOfEntryKey");
        String typeOfEntryValue = this.req_.getParameter("typeOfEntryValue");
        Vector<String> paramVector = new Vector<String>(paramcnt);
        String paramVectorStr = this.req_.getParameter("paramVector");
        paramVector = paramVectorStr == null ? new Vector<String>(paramcnt) : (Vector<String>)JMXUtil.deserialize(paramVectorStr);
        String submitAction = this.req_.getParameter("SubmitAction");
        if (submitAction.equals("Next")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            }
            this.gen_.addHeader();
            this.gen_.addInputMapForm(mbean, theOper, ++pageNum, elemNum += 10, JMXUtil.serialize(pageVector), paramNum, JMXUtil.serialize(paramVector), paramcnt);
            this.gen_.addTrailer();
        } else if (submitAction.equals("Pre")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            }
            this.gen_.addHeader();
            this.gen_.addInputMapForm(mbean, theOper, --pageNum, elemNum -= 10, JMXUtil.serialize(pageVector), paramNum, JMXUtil.serialize(paramVector), paramcnt);
            this.gen_.addTrailer();
        } else if (submitAction.equals("Done")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            }
            Object paramObject = this.makeRealReturnTypeObject(pageVector, typeOfParam);
            if (paramNum < paramVector.size() && paramVector.elementAt(paramNum) != null) {
                paramVector.remove(paramNum);
            }
            paramVector.add(paramNum, JMXUtil.serialize(paramObject));
            this.gen_.addHeader();
            this.gen_.addOperationWithComplexParamsInfo(mbean, theOper, paramNum, paramVector);
            this.gen_.addMBeanPageBackLink(mbean);
            this.gen_.addTrailer();
        }
    }

    private void handleINPUTCOMPOSITEDATACommand(int paramNum) throws HandlingException {
        String submitAction;
        String elemNumStr;
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String operation = this.toUTF8(this.req_.getParameter("operation"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanOperationInfo theOper = this.getOperationInfo(mbeanInfo, operation, mbean);
        boolean dumpData = this.parseDumpData();
        String compositeStoreStr = this.req_.getParameter("compositeStore");
        CompositeDataItem[] compositeStore = compositeStoreStr == null ? new CompositeDataItem[10] : (CompositeDataItem[])JMXUtil.deserialize(compositeStoreStr);
        String compositePosStr = this.req_.getParameter("compositePos");
        Vector compositePos = compositePosStr == null ? new Vector() : (Vector)JMXUtil.deserialize(compositePosStr);
        int paramcnt = this.parseParamCount();
        Vector paramVector = new Vector(paramcnt);
        int pageNum = 0;
        int elemNum = 10;
        if (paramNum >= 0) {
            for (int i = 0; i < paramcnt; ++i) {
                paramVector.add(i, this.req_.getParameter("param" + i));
            }
            try {
                Object tmpObj = JMXUtil.deserialize((String)paramVector.get(paramNum));
                if (tmpObj instanceof CompositeDataItem[]) {
                    compositeStore = (CompositeDataItem[])tmpObj;
                    compositeStore = this.checkCompositeStoreSize(compositeStore, compositePos, elemNum);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.gen_.addHeader();
            this.gen_.addInputCompositeDataForm(mbean, theOper, pageNum, elemNum, JMXUtil.serialize(compositeStore), JMXUtil.serialize(compositePos), paramNum, JMXUtil.serialize(paramVector), paramcnt, dumpData);
            this.gen_.addTrailer();
            return;
        }
        String pageNumStr = this.req_.getParameter("pageNum");
        if (pageNumStr != null) {
            pageNum = Integer.parseInt(pageNumStr);
        }
        if ((elemNumStr = this.req_.getParameter("elemNum")) != null) {
            elemNum = Integer.parseInt(elemNumStr);
        }
        paramNum = this.parseParamNum();
        String paramVectorStr = this.req_.getParameter("paramVector");
        if (paramVectorStr != null) {
            paramVector = (Vector)JMXUtil.deserialize(paramVectorStr);
        }
        if ((submitAction = this.req_.getParameter("SubmitAction")) == null) {
            int inputIdx = -1;
            for (int i = elemNum - 10; i < elemNum; ++i) {
                String tmpStr = this.req_.getParameter("SubmitAction" + i);
                if (tmpStr == null) continue;
                inputIdx = i;
                break;
            }
            if (inputIdx == -1) {
                throw new HandlingException("couldn't find submit action");
            }
            this.collectCompositeDataItems(compositeStore, compositePos, elemNum);
            compositePos.add(new Integer(inputIdx));
            pageNum = 0;
            elemNum = 10;
            compositeStore = this.checkCompositeStoreSize(compositeStore, compositePos, elemNum);
            this.gen_.addHeader();
            this.gen_.addInputCompositeDataForm(mbean, theOper, pageNum, elemNum, JMXUtil.serialize(compositeStore), JMXUtil.serialize(compositePos), paramNum, JMXUtil.serialize(paramVector), paramcnt, dumpData);
            this.gen_.addTrailer();
        } else if (submitAction.equals("Next")) {
            this.collectCompositeDataItems(compositeStore, compositePos, elemNum);
            compositeStore = this.checkCompositeStoreSize(compositeStore, compositePos, elemNum += 10);
            this.gen_.addHeader();
            this.gen_.addInputCompositeDataForm(mbean, theOper, ++pageNum, elemNum, JMXUtil.serialize(compositeStore), JMXUtil.serialize(compositePos), paramNum, JMXUtil.serialize(paramVector), paramcnt, dumpData);
            this.gen_.addTrailer();
        } else if (submitAction.equals("Pre")) {
            this.collectCompositeDataItems(compositeStore, compositePos, elemNum);
            this.gen_.addHeader();
            this.gen_.addInputCompositeDataForm(mbean, theOper, --pageNum, elemNum -= 10, JMXUtil.serialize(compositeStore), JMXUtil.serialize(compositePos), paramNum, JMXUtil.serialize(paramVector), paramcnt, dumpData);
            this.gen_.addTrailer();
        } else if (submitAction.equals("Done")) {
            this.collectCompositeDataItems(compositeStore, compositePos, elemNum);
            if (compositePos.isEmpty()) {
                compositeStore = CompositeDataItem.compactCompositeDataItems(compositeStore);
                paramVector.set(paramNum, JMXUtil.serialize(compositeStore));
                this.gen_.addHeader();
                this.gen_.addOperationWithComplexParamsInfo(mbean, theOper, paramNum, paramVector);
                this.gen_.addMBeanPageBackLink(mbean);
                this.gen_.addTrailer();
            } else {
                int lastIndex = (Integer)compositePos.remove(compositePos.size() - 1);
                pageNum = lastIndex / 10;
                elemNum = (pageNum + 1) * 10;
                this.gen_.addHeader();
                this.gen_.addInputCompositeDataForm(mbean, theOper, pageNum, elemNum, JMXUtil.serialize(compositeStore), JMXUtil.serialize(compositePos), paramNum, JMXUtil.serialize(paramVector), paramcnt, dumpData);
                this.gen_.addTrailer();
            }
        }
    }

    private void collectCompositeDataItems(CompositeDataItem[] store, Vector pos, int elemNum) throws HandlingException {
        int i;
        CompositeDataItem[] current = store;
        for (i = 0; i < pos.size(); ++i) {
            int posIndex = (Integer)pos.get(i);
            current = (CompositeDataItem[])current[posIndex].getValue();
        }
        if (current.length < elemNum) {
            throw new HandlingException("collect data failed. \n insert pos = " + pos + "\n" + " coposite data is \n" + CompositeDataItem.toString(store));
        }
        for (i = elemNum - 10; i < elemNum; ++i) {
            String key = this.convEmptyStrToNull(this.req_.getParameter("entryKey" + i), true);
            String desc = this.convEmptyStrToNull(this.req_.getParameter("entryDesc" + i), true);
            String type = this.convEmptyStrToNull(this.req_.getParameter("entryType" + i), false);
            if (type.endsWith("CompositeData")) {
                if (current[i] == null) {
                    current[i] = new CompositeDataItem(key, desc, type, null);
                    continue;
                }
                current[i].setName(key);
                current[i].setDesc(desc);
                current[i].setType(type);
                continue;
            }
            String value = this.convEmptyStrToNull(this.req_.getParameter("entryValue" + i), false);
            if (current[i] == null) {
                current[i] = new CompositeDataItem(key, desc, type, value);
                continue;
            }
            current[i].setName(key);
            current[i].setDesc(desc);
            current[i].setType(type);
            current[i].setValue(value);
        }
    }

    private String convEmptyStrToNull(String string, boolean trim) {
        if (string != null && (trim ? string.trim().length() == 0 : string.length() == 0)) {
            return null;
        }
        return string != null && trim ? string.trim() : string;
    }

    private CompositeDataItem[] checkCompositeStoreSize(CompositeDataItem[] store, Vector pos, int size) {
        CompositeDataItem[] targetPage = null;
        CompositeDataItem parentItem = null;
        if (pos.isEmpty()) {
            parentItem = null;
            targetPage = store;
        } else {
            CompositeDataItem[] parentPage = store;
            for (int i = 0; i < pos.size() - 1; ++i) {
                int posIndex = (Integer)pos.get(i);
                parentPage = (CompositeDataItem[])parentPage[posIndex].getValue();
            }
            int lastIndex = (Integer)pos.lastElement();
            parentItem = parentPage[lastIndex];
            parentItem.setType("javax.management.openmbean.CompositeData");
            Object tmpValue = parentItem.getValue();
            if (tmpValue instanceof CompositeDataItem[]) {
                targetPage = (CompositeDataItem[])tmpValue;
            } else {
                targetPage = new CompositeDataItem[size];
                parentItem.setValue(targetPage);
            }
        }
        if (targetPage.length < size) {
            CompositeDataItem[] newarray = new CompositeDataItem[size];
            System.arraycopy(targetPage, 0, newarray, 0, targetPage.length);
            if (parentItem == null) {
                store = newarray;
            } else {
                parentItem.setValue(newarray);
            }
        }
        return store;
    }

    private void handleSHOWINPUTARRAYFORMForAttributeCommand() throws HandlingException {
        this.gen_.addHeader();
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String attribute = this.toUTF8(this.req_.getParameter("attribute"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanAttributeInfo theAttri = this.getAttrInfo(mbeanInfo, attribute, mbean);
        int pageNum = 0;
        int elemNum = 10;
        Vector pageVector = new Vector();
        String page = this.req_.getParameter("pageNum");
        pageNum = page == null ? 0 : Integer.parseInt(page);
        String element = this.req_.getParameter("elemNum");
        elemNum = element == null ? 10 : Integer.parseInt(element);
        String pageVectorStr = this.req_.getParameter("pageVector");
        pageVector = pageVectorStr == null ? new Vector() : (Vector)JMXUtil.deserialize(pageVectorStr);
        this.gen_.addInputArrayFormForAttribute(mbean, theAttri, pageNum, elemNum, JMXUtil.serialize(pageVector));
        this.gen_.addTrailer();
    }

    private void handleINPUTARRAYFORATTRIBUTECommand() throws HandlingException {
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String attribute = this.toUTF8(this.req_.getParameter("attribute"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanAttributeInfo theAttrib = this.getAttrInfo(mbeanInfo, attribute, mbean);
        String realType = theAttrib.getType();
        String typeOfCollection = this.req_.getParameter("typeOfCollection");
        String selectedType = typeOfCollection != null ? typeOfCollection : realType;
        Vector pageVector = new Vector();
        String page = this.req_.getParameter("pageNum");
        int pageNum = page == null ? 0 : Integer.parseInt(page);
        String element = this.req_.getParameter("elemNum");
        int elemNum = element == null ? 10 : Integer.parseInt(element);
        String pageVectorStr = this.req_.getParameter("pageVector");
        pageVector = pageVectorStr == null ? new Vector() : (Vector)JMXUtil.deserialize(pageVectorStr);
        String submitAction = this.req_.getParameter("SubmitAction");
        if (submitAction.equals("Next")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageElements(elemNum, selectedType));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, selectedType));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, selectedType));
            }
            this.gen_.addHeader();
            this.gen_.addInputArrayFormForAttribute(mbean, theAttrib, ++pageNum, elemNum += 10, JMXUtil.serialize(pageVector));
            this.gen_.addTrailer();
        } else if (submitAction.equals("Pre")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageElements(elemNum, selectedType));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, selectedType));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, selectedType));
            }
            this.gen_.addHeader();
            this.gen_.addInputArrayFormForAttribute(mbean, theAttrib, --pageNum, elemNum -= 10, JMXUtil.serialize(pageVector));
            this.gen_.addTrailer();
        } else if (submitAction.equals("Done")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageElements(elemNum, selectedType));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, selectedType));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageElements(elemNum, selectedType));
            }
            pageVector = this.recreateVector(pageVector);
            Object realObject = !realType.equals(selectedType) ? this.makeRealReturnTypeObject(pageVector, realType) : pageVector;
            this.gen_.addHeader();
            this.gen_.addAttributeWithComplexTypeInfo(theAttrib, mbean, JMXUtil.serialize(realObject), true);
            this.gen_.addMBeanPageBackLink(mbean);
            this.gen_.addTrailer();
        }
    }

    private void handleSHOWINPUTMAPFORMFORATTRIBUTECommand() throws HandlingException {
        this.gen_.addHeader();
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String attribute = this.toUTF8(this.req_.getParameter("attribute"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanAttributeInfo theAttrib = this.getAttrInfo(mbeanInfo, attribute, mbean);
        int pageNum = 0;
        int elemNum = 10;
        Vector pageVector = new Vector();
        String page = this.req_.getParameter("pageNum");
        pageNum = page == null ? 0 : Integer.parseInt(page);
        String element = this.req_.getParameter("elemNum");
        elemNum = element == null ? 10 : Integer.parseInt(element);
        String pageVectorStr = this.req_.getParameter("pageVector");
        pageVector = pageVectorStr == null ? new Vector() : (Vector)JMXUtil.deserialize(pageVectorStr);
        this.gen_.addInputMapFormForAttribute(mbean, theAttrib, pageNum, elemNum, JMXUtil.serialize(pageVector));
        this.gen_.addTrailer();
    }

    private void handleINPUTMAPFORATTRIBUTECommand() throws HandlingException {
        String mbean = this.toUTF8(this.req_.getParameter("mbean"));
        String attribute = this.toUTF8(this.req_.getParameter("attribute"));
        MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
        MBeanAttributeInfo theAttrib = this.getAttrInfo(mbeanInfo, attribute, mbean);
        Vector pageVector = new Vector();
        String page = this.req_.getParameter("pageNum");
        int pageNum = page == null ? 0 : Integer.parseInt(page);
        String element = this.req_.getParameter("elemNum");
        int elemNum = element == null ? 10 : Integer.parseInt(element);
        String pageVectorStr = this.req_.getParameter("pageVector");
        pageVector = pageVectorStr == null ? new Vector() : (Vector)JMXUtil.deserialize(pageVectorStr);
        String realType = theAttrib.getType();
        String typeOfEntryKey = this.req_.getParameter("typeOfEntryKey");
        String typeOfEntryValue = this.req_.getParameter("typeOfEntryValue");
        String submitAction = this.req_.getParameter("SubmitAction");
        if (submitAction.equals("Next")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            }
            this.gen_.addHeader();
            this.gen_.addInputMapFormForAttribute(mbean, theAttrib, ++pageNum, elemNum += 10, JMXUtil.serialize(pageVector));
            this.gen_.addTrailer();
        } else if (submitAction.equals("Pre")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            }
            this.gen_.addHeader();
            this.gen_.addInputMapFormForAttribute(mbean, theAttrib, --pageNum, elemNum -= 10, JMXUtil.serialize(pageVector));
            this.gen_.addTrailer();
        } else if (submitAction.equals("Done")) {
            if (pageVector.isEmpty()) {
                pageVector.add(this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else if (pageNum == pageVector.size()) {
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            } else {
                pageVector.removeElementAt(pageNum);
                pageVector.add(pageNum, this.collectCurrentPageMapElements(elemNum, typeOfEntryKey, typeOfEntryValue));
            }
            Object value = this.makeRealReturnTypeObject(pageVector, realType);
            this.gen_.addHeader();
            this.gen_.addAttributeWithComplexTypeInfo(theAttrib, mbean, JMXUtil.serialize(value), true);
            this.gen_.addMBeanPageBackLink(mbean);
            this.gen_.addTrailer();
        }
    }

    private Object makeRealReturnTypeObject(Vector pageVector, String type) throws HandlingException {
        Object obj = null;
        String theType = null;
        theType = type.equals("java.util.Collection") || type.equals("java.util.List") ? "java.util.ArrayList" : (type.equals("java.util.Map") ? "java.util.HashMap" : (type.equals("java.util.Set") ? "java.util.TreeSet" : type));
        try {
            obj = Class.forName(theType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new HandlingException(e, e.getMessage());
        }
        if (obj instanceof List) {
            AbstractList list = obj instanceof Vector ? new Vector() : (obj instanceof LinkedList ? new LinkedList() : (obj instanceof Stack ? new Stack() : new ArrayList()));
            for (int i = 0; i < pageVector.size(); ++i) {
                list.add(pageVector.elementAt(i));
            }
            if (type.equals("java.util.Collection")) {
                return list;
            }
            if (type.equals("java.util.List")) {
                return list;
            }
            return list;
        }
        if (obj instanceof Map) {
            Map<Object, Object> map = obj instanceof Hashtable ? new Hashtable() : (obj instanceof TreeMap ? new TreeMap() : (obj instanceof Attributes ? new Attributes() : (obj instanceof IdentityHashMap ? new IdentityHashMap() : (obj instanceof WeakHashMap ? new WeakHashMap() : (obj instanceof Properties ? new Properties() : new HashMap())))));
            for (int i = 0; i < pageVector.size(); ++i) {
                Map tmpMap = (Map)pageVector.elementAt(i);
                Set keySet = tmpMap.keySet();
                Iterator iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    Object tmpKey = iterator.next();
                    Object tmpValue = tmpMap.get(tmpKey);
                    map.put(tmpKey, tmpValue);
                }
            }
            if (type.equals("java.util.Map")) {
                return map;
            }
            return map;
        }
        if (obj instanceof Set) {
            AbstractSet set = obj instanceof TreeSet ? new TreeSet() : (obj instanceof LinkedHashSet ? new LinkedHashSet() : new HashSet());
            for (int i = 0; i < pageVector.size(); ++i) {
                set.add(pageVector.elementAt(i));
            }
            if (type.equals("java.util.Set")) {
                return set;
            }
            return set;
        }
        return obj;
    }

    private Object getRealReturnTypeObject(Object object, String type) throws HandlingException {
        if (object instanceof List) {
            if (type.equals("java.util.Vector")) {
                return (Vector)object;
            }
            if (type.equals("java.util.LinkedList")) {
                return (LinkedList)object;
            }
            if (type.equals("java.util.Stack")) {
                return (Stack)object;
            }
            if (type.equals("java.util.ArrayList")) {
                return (ArrayList)object;
            }
            return (List)object;
        }
        if (object instanceof Map) {
            if (type.equals("java.util.Hashtable")) {
                return (Hashtable)object;
            }
            if (type.equals("java.util.HashMap")) {
                return (HashMap)object;
            }
            if (type.equals("java.util.TreeMap")) {
                return (TreeMap)object;
            }
            if (type.equals("java.util.jar.Attributes")) {
                return (Attributes)object;
            }
            if (type.equals("java.util.IdentityHashMap")) {
                return (IdentityHashMap)object;
            }
            if (type.equals("java.util.WeakHashMap")) {
                return (WeakHashMap)object;
            }
            if (type.equals("java.util.Properties")) {
                Properties prop = new Properties();
                Hashtable table = (Hashtable)object;
                Set keySet = table.keySet();
                Iterator iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    Object tmpKey = iterator.next();
                    Object tmpValue = table.get(tmpKey);
                    prop.put(tmpKey, tmpValue);
                }
                return prop;
            }
            return (Map)object;
        }
        if (object instanceof Set) {
            if (type.equals("java.util.TreeSet")) {
                return (TreeSet)object;
            }
            if (type.equals("java.util.LinkedHashSet")) {
                LinkedHashSet lhs = new LinkedHashSet();
                HashSet hashSet = (HashSet)object;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    lhs.add(iterator.next());
                }
                return lhs;
            }
            if (type.equals("java.util.HashSet")) {
                return (HashSet)object;
            }
            return (Set)object;
        }
        throw new HandlingException("Don't know this deserialized object." + object);
    }

    private Vector recreateVector(Vector pageVector) {
        Vector aVector = new Vector();
        for (int i = 0; i < pageVector.size(); ++i) {
            Vector bVector = (Vector)pageVector.elementAt(i);
            if (bVector == null) continue;
            for (int j = 0; j < bVector.size(); ++j) {
                aVector.add(bVector.elementAt(j));
            }
        }
        return aVector;
    }

    private Vector collectCurrentPageElements(int elemNum, String type) throws HandlingException {
        int paramLength = 0;
        Vector<String> vector = new Vector<String>();
        Enumeration enum5 = this.req_.getParameterNames();
        while (enum5.hasMoreElements()) {
            String name = enum5.nextElement().toString();
            if (!name.startsWith("param")) continue;
            ++paramLength;
        }
        String tmp = new String();
        for (int i = elemNum - 10; i < elemNum - 10 + paramLength; ++i) {
            tmp = this.req_.getParameter("param[" + String.valueOf(i) + "]");
            if (tmp == null || tmp.equals("")) continue;
            if (!this.isCorrectData(tmp, type)) {
                throw new HandlingException("Incorrect value " + tmp + ", type is " + type);
            }
            vector.add(tmp);
        }
        return vector;
    }

    private HashMap collectCurrentPageMapElements(int elemNum, String typeOfEntryKey, String typeOfEntryValue) throws HandlingException {
        int paramLength = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration enum5 = this.req_.getParameterNames();
        while (enum5.hasMoreElements()) {
            String name = enum5.nextElement().toString();
            if (!name.startsWith("entryKey")) continue;
            ++paramLength;
        }
        String tmp = new String();
        for (int i = elemNum - 10; i < elemNum - 10 + paramLength; ++i) {
            String tmpKey = this.req_.getParameter("entryKey[" + String.valueOf(i) + "]");
            String tmpValue = this.req_.getParameter("entryValue[" + String.valueOf(i) + "]");
            if (tmpKey.equals("")) continue;
            if (!this.isCorrectData(tmpKey, typeOfEntryKey)) {
                throw new HandlingException("Incorrect entry key " + tmpKey + " for type " + typeOfEntryKey);
            }
            if (!this.isCorrectData(tmpValue, typeOfEntryValue)) {
                throw new HandlingException("Incorrect entry value" + tmpValue + " for type " + typeOfEntryValue);
            }
            hashMap.put(tmpKey, tmpValue);
        }
        return hashMap;
    }

    private boolean isCorrectData(String data, String type) {
        try {
            if (type.equals("[Ljava.lang.Byte;") || type.equals("[B") || type.equals("java.lang.Byte")) {
                Byte.parseByte(data);
            } else if (type.equals("[Ljava.lang.Double;") || type.equals("[D") || type.equals("java.lang.Double")) {
                Double.parseDouble(data);
            } else if (type.equals("[Ljava.lang.Float;") || type.equals("[F") || type.equals("java.lang.Float")) {
                Float.parseFloat(data);
            } else if (type.equals("[Ljava.lang.Long;") || type.equals("[J") || type.equals("java.lang.Long")) {
                Long.parseLong(data);
            } else if (type.equals("[Ljava.lang.Short;") || type.equals("[S") || type.equals("java.lang.Short")) {
                Short.parseShort(data);
            } else if (type.equals("[Ljava.lang.Integer;") || type.equals("[I") || type.equals("java.lang.Integer")) {
                Integer.parseInt(data);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (type.equals("[Ljava.lang.Boolean;") || type.equals("[Z") || type.equals("java.lang.Boolean")) {
            return data.toLowerCase().equals("true") || data.toLowerCase().equals("false");
        }
        return true;
    }

    private Set getMBeans() {
        return this.mbeanServ_.queryNames(allObjectName_, null);
    }

    private Set getMBeans(String pattern) throws HandlingException {
        return this.getMBeans(pattern, null);
    }

    private Set getMBeans(String pattern, QueryExp q) throws HandlingException {
        ObjectName objPattern = null;
        try {
            objPattern = new ObjectName(pattern);
        }
        catch (MalformedObjectNameException e) {
            throw new HandlingException(e, "Invalid pattern: " + pattern);
        }
        return this.mbeanServ_.queryNames(objPattern, q);
    }

    private Set getDomains(Set objectNames) {
        HashSet<String> domains = new HashSet<String>();
        Iterator iter = objectNames.iterator();
        while (iter.hasNext()) {
            ObjectName objName = (ObjectName)iter.next();
            domains.add(objName.getDomain());
        }
        return domains;
    }

    private ObjectName getObjectName(String mbeanName) throws HandlingException {
        try {
            return new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new HandlingException(e, "Invalid MBean Name: " + mbeanName);
        }
    }

    private MBeanInfo getMBeanInfo(String mbeanName) throws HandlingException {
        ObjectName objName = this.getObjectName(mbeanName);
        try {
            if ("oc4j".equalsIgnoreCase(this.domainName_)) {
                String[] paramTypes = new String[]{"java.util.Locale"};
                Object[] params = new Object[]{this.locHelper_.getLocale()};
                MBeanInfo info = null;
                try {
                    info = (MBeanInfo)this.mbeanServ_.invoke(objName, "getMBeanInfo", params, paramTypes);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return info == null ? this.mbeanServ_.getMBeanInfo(objName) : info;
            }
            return this.mbeanServ_.getMBeanInfo(objName);
        }
        catch (InstanceNotFoundException e) {
            throw new HandlingException(e, "MBean no longer registered with MBeanServer: " + mbeanName);
        }
        catch (IntrospectionException e) {
            throw new HandlingException(e, "Instrospection error for mbean: " + mbeanName);
        }
        catch (ReflectionException e) {
            throw new HandlingException(e, "Exception occurred when trying to invoke the getMBeanInfo for the Dynamic MBean: " + mbeanName);
        }
        catch (Exception e) {
            throw new HandlingException(e, "Exception occurred when trying invoke getMBeanInfo for MBean: " + mbeanName);
        }
    }

    private Stats getStats(String mbeanName) throws HandlingException {
        ObjectName mbean = this.getObjectName(mbeanName);
        try {
            Boolean hasStats = (Boolean)mbeanToStatAssociation_.get(mbeanName);
            if (hasStats == null) {
                MBeanInfo info = this.getMBeanInfo(mbeanName);
                MBeanAttributeInfo[] attrsInf = info.getAttributes();
                for (int i = 0; i < attrsInf.length; ++i) {
                    if (!"statisticsProvider".equals(attrsInf[i].getName())) continue;
                    hasStats = (Boolean)this.mbeanServ_.getAttribute(mbean, "statisticsProvider");
                    mbeanToStatAssociation_.put(mbeanName, hasStats);
                }
                if (hasStats == null) {
                    mbeanToStatAssociation_.put(mbeanName, new Boolean(false));
                    return null;
                }
            }
            if (hasStats.booleanValue()) {
                return (Stats)this.mbeanServ_.getAttribute(mbean, "stats");
            }
            return null;
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
        catch (InstanceNotFoundException e) {
            throw new HandlingException(e, "MBean no longer registered with MBeanServer: " + mbeanName);
        }
        catch (JMException e) {
            throw new HandlingException(e, "Error while handling request. See nested Exception.");
        }
    }

    private Object getAttributeValue(MBeanAttributeInfo theAttrib, String mbeanName) throws HandlingException {
        if (!theAttrib.isReadable()) {
            return null;
        }
        ObjectName mbean = this.getObjectName(mbeanName);
        try {
            return this.mbeanServ_.getAttribute(mbean, theAttrib.getName());
        }
        catch (AttributeNotFoundException e) {
            throw new HandlingException(e, "attribute \"" + theAttrib.getName() + "\" not found in mbean " + mbeanName);
        }
        catch (InstanceNotFoundException e) {
            throw new HandlingException(e, "MBean no longer registered with MBeanServer: " + mbeanName);
        }
        catch (JMException e) {
            throw new HandlingException(e, "Error while handling request. See nested Exception.");
        }
    }

    private void setAttribute(String name, String mbeanName, String value, String type) throws HandlingException {
        ObjectName mbean = this.getObjectName(mbeanName);
        Object val = new Object();
        try {
            MBeanParameterInfo paramInfo = new MBeanParameterInfo(name, type, "name");
            val = this.createParam(value, paramInfo);
        }
        catch (HandlingException e) {
            throw new HandlingException(e, "Invalid value for attribute " + name + ", type is " + type);
        }
        Attribute attrib = new Attribute(name, val);
        try {
            this.mbeanServ_.setAttribute(mbean, attrib);
        }
        catch (AttributeNotFoundException e) {
            throw new HandlingException(e, "Attribute: " + name + " not found for MBean: " + mbeanName);
        }
        catch (InstanceNotFoundException e) {
            throw new HandlingException(e, "MBean no longer registered with MBeanServer: " + mbeanName);
        }
        catch (InvalidAttributeValueException e) {
            throw new HandlingException(e, value + " is not a valid value for attribute: " + name + " of MBean: " + mbeanName);
        }
        catch (JMException e) {
            throw new HandlingException(e, "Error while handling request. See nested Exception.");
        }
    }

    private Object createParam(String value, MBeanParameterInfo paramInfo) throws HandlingException {
        String type = paramInfo.getType();
        try {
            if (type.equals("java.lang.String")) {
                return value;
            }
            if (value == null || value.length() == 0) {
                return null;
            }
            if (type.equals("javax.management.ObjectName")) {
                return new ObjectName(value);
            }
            if (type.equals("java.lang.Integer") || type.equals("int") || type.equals("I")) {
                return new Integer(value);
            }
            if (type.equals("java.lang.Long") || type.equals("long") || type.equals("L")) {
                return new Long(value);
            }
            if (type.equals("java.lang.Boolean") || type.equals("boolean") || type.equals("Z")) {
                return new Boolean(value);
            }
            if (type.equals("java.lang.Float") || type.equals("float") || type.equals("F")) {
                return new Float(value);
            }
            if (type.equals("java.lang.Byte") || type.equals("byte") || type.equals("B")) {
                return new Byte(value);
            }
            if (type.equals("java.lang.Double") || type.equals("double") || type.equals("D")) {
                return new Double(value);
            }
            if (type.equals("java.lang.Short") || type.equals("short") || type.equals("S")) {
                return new Short(value);
            }
            if (type.equals("java.lang.Character") || type.equals("char") || type.equals("C")) {
                return new Character(value.charAt(0));
            }
            if (type.equals("[Ljava.lang.Integer;") || type.equals("[I")) {
                Integer[] integerArray = null;
                Object object = JMXUtil.deserialize(value);
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    int length = vector.size();
                    integerArray = new Integer[length];
                    for (int i = 0; i < length; ++i) {
                        integerArray[i] = Integer.valueOf(String.valueOf(vector.elementAt(i)));
                    }
                } else {
                    throw new HandlingException("Don't know this deserialized object." + object);
                }
                return integerArray;
            }
            if (type.equals("[Ljava.lang.Boolean;") || type.equals("[Z")) {
                Boolean[] booleanArray = null;
                Object object = JMXUtil.deserialize(value);
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    int length = vector.size();
                    booleanArray = new Boolean[length];
                    for (int i = 0; i < length; ++i) {
                        booleanArray[i] = Boolean.valueOf(String.valueOf(vector.elementAt(i)));
                    }
                } else {
                    throw new HandlingException("Don't know this deserialized object." + object);
                }
                return booleanArray;
            }
            if (type.equals("[Ljava.lang.Byte;") || type.equals("[B")) {
                Byte[] byteArray = null;
                Object object = JMXUtil.deserialize(value);
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    int length = vector.size();
                    byteArray = new Byte[length];
                    for (int i = 0; i < length; ++i) {
                        byteArray[i] = Byte.valueOf(String.valueOf(vector.elementAt(i)));
                    }
                } else {
                    throw new HandlingException("Don't know this deserialized object." + object);
                }
                return byteArray;
            }
            if (type.equals("[Ljava.lang.Character;") || type.equals("[C")) {
                Character[] charArray = null;
                Object object = JMXUtil.deserialize(value);
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    int length = vector.size();
                    charArray = new Character[length];
                    for (int i = 0; i < length; ++i) {
                        charArray[i] = new Character(String.valueOf(vector.elementAt(i)).charAt(0));
                    }
                } else {
                    throw new HandlingException("Don't know this deserialized object." + object);
                }
                return charArray;
            }
            if (type.equals("[Ljava.lang.Double;") || type.equals("[D")) {
                Double[] doubleArray = null;
                Object object = JMXUtil.deserialize(value);
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    int length = vector.size();
                    doubleArray = new Double[length];
                    for (int i = 0; i < length; ++i) {
                        doubleArray[i] = Double.valueOf(String.valueOf(vector.elementAt(i)));
                    }
                } else {
                    throw new HandlingException("Don't know this deserialized object." + object);
                }
                return doubleArray;
            }
            if (type.equals("[Ljava.lang.Float;") || type.equals("[F")) {
                Float[] floatArray = null;
                Object object = JMXUtil.deserialize(value);
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    int length = vector.size();
                    floatArray = new Float[length];
                    for (int i = 0; i < length; ++i) {
                        floatArray[i] = Float.valueOf(String.valueOf(vector.elementAt(i)));
                    }
                } else {
                    throw new HandlingException("Don't know this deserialized object." + object);
                }
                return floatArray;
            }
            if (type.equals("[Ljava.lang.Long;") || type.equals("[J")) {
                Long[] longArray = null;
                Object object = JMXUtil.deserialize(value);
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    int length = vector.size();
                    longArray = new Long[length];
                    for (int i = 0; i < length; ++i) {
                        longArray[i] = Long.valueOf(String.valueOf(vector.elementAt(i)));
                    }
                } else {
                    throw new HandlingException("Don't know this deserialized object." + object);
                }
                return longArray;
            }
            if (type.equals("[Ljava.lang.Short;") || type.equals("[S")) {
                Short[] shortArray = null;
                Object object = JMXUtil.deserialize(value);
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    int length = vector.size();
                    shortArray = new Short[length];
                    for (int i = 0; i < length; ++i) {
                        shortArray[i] = Short.valueOf(String.valueOf(vector.elementAt(i)));
                    }
                } else {
                    throw new HandlingException("Don't know this deserialized object." + object);
                }
                return shortArray;
            }
            if (type.equals("[Ljava.lang.String;")) {
                String[] stringArray = null;
                Object object = JMXUtil.deserialize(value);
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    int length = vector.size();
                    stringArray = new String[length];
                    for (int i = 0; i < length; ++i) {
                        stringArray[i] = String.valueOf(vector.elementAt(i));
                    }
                } else {
                    throw new HandlingException("Don't know this deserialized object." + object);
                }
                return stringArray;
            }
            if (type.startsWith("java.util")) {
                Object object = JMXUtil.deserialize(value);
                return this.getRealReturnTypeObject(object, type);
            }
            if (type.equals("javax.management.openmbean.CompositeData")) {
                Object object = JMXUtil.deserialize(value);
                if (!(object instanceof CompositeDataItem[])) {
                    return null;
                }
                CompositeData compositeData = CompositeDataItem.convertToCompositeDataSupport(paramInfo.getName() + "Type", paramInfo.getDescription(), (CompositeDataItem[])object);
                return compositeData;
            }
            throw new HandlingException(type + " is not a supported type.");
        }
        catch (NumberFormatException e) {
            throw new HandlingException(e, "Invalid value for attribute\nvalue : " + value + "\ntype  : " + type);
        }
        catch (Exception e) {
            throw new HandlingException("The value is invalid. Please input it again.");
        }
    }

    private Object invokeOperation(MBeanOperationInfo theOper, Vector paramValues, String mbeanName) throws HandlingException {
        MBeanParameterInfo[] paramInfos = theOper.getSignature();
        if (paramValues.size() != paramInfos.length) {
            throw new HandlingException("Missmatch number of parameters. Method as " + paramInfos.length + " while " + paramValues.size() + " where passed");
        }
        Object[] vals = new Object[paramInfos.length];
        String[] sign = new String[paramInfos.length];
        for (int i = 0; i < paramInfos.length; ++i) {
            sign[i] = paramInfos[i].getType();
            try {
                vals[i] = this.createParam(paramValues.elementAt(i).toString(), paramInfos[i]);
                continue;
            }
            catch (HandlingException e) {
                throw new HandlingException(e, "Invalid value for parameter " + (i + 1) + ", type is " + sign[i]);
            }
        }
        ObjectName mbean = this.getObjectName(mbeanName);
        try {
            return this.mbeanServ_.invoke(mbean, theOper.getName(), vals, sign);
        }
        catch (InstanceNotFoundException e) {
            throw new HandlingException(e, "MBean no longer registered with MBeanServer: " + mbeanName);
        }
        catch (JMException e) {
            throw new HandlingException(e, "Error while handling request. See nested Exception.");
        }
    }

    private String toUTF8(String ori) {
        if (ori == null) {
            return ori;
        }
        String res = ori;
        if (this.reqEncoding_ != null && !"UTF-8".equalsIgnoreCase(this.reqEncoding_)) {
            try {
                byte[] defaultBytes = ori.getBytes(this.reqEncoding_);
                res = new String(defaultBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return res;
            }
        }
        return res;
    }

    private MBeanOperationInfo getOperationInfo(MBeanInfo mbeanInfo, String operation, String mbean) throws HandlingException {
        MBeanOperationInfo[] operInfos = mbeanInfo.getOperations();
        MBeanOperationInfo operInfo = null;
        for (int i = 0; i < operInfos.length; ++i) {
            String sign = this.gen_.buildMethodSignature(operInfos[i]);
            if (!operation.equals(sign)) continue;
            operInfo = operInfos[i];
            break;
        }
        if (operInfo == null) {
            throw new HandlingException(operation + " method is not defined for mbean: " + mbean);
        }
        return operInfo;
    }

    private MBeanAttributeInfo getAttrInfo(MBeanInfo mbeanInfo, String attribute, String mbean) throws HandlingException {
        MBeanAttributeInfo[] attrInfos = mbeanInfo.getAttributes();
        MBeanAttributeInfo attrInfo = null;
        for (int i = 0; i < attrInfos.length; ++i) {
            if (!attribute.equals(attrInfos[i].getName())) continue;
            attrInfo = attrInfos[i];
            break;
        }
        if (attrInfo == null) {
            throw new HandlingException(attribute + " attribute is not defined for mbean: " + mbean);
        }
        return attrInfo;
    }

    private int parseParamCount() throws HandlingException {
        try {
            return new Integer(this.req_.getParameter("paramCount"));
        }
        catch (NumberFormatException e) {
            throw new HandlingException(e, "Invalid value for paramNum Servlet parameter \nvalue: " + this.req_.getParameter("paramCount"));
        }
    }

    private int parseParamNum() throws HandlingException {
        try {
            return new Integer(this.req_.getParameter("paramNum"));
        }
        catch (NumberFormatException e) {
            throw new HandlingException(e, "Invalid value for paramNum Servlet parameter value: " + this.req_.getParameter("paramNum"));
        }
    }

    private boolean parseDumpData() {
        return "true".equalsIgnoreCase(this.req_.getParameter("dumpData"));
    }

    static {
        try {
            allObjectName_ = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        listeners_ = new Hashtable();
        events_ = new Vector();
    }
}

