/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.server.mbeans.deploy;

import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.jmx.server.mbeans.deploy.DeployerMBeanImplBase;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public abstract class DeployerRunnable
implements Runnable {
    private static Logger logger_ = TraceLogger.getLogger(DeployerRunnable.class);
    protected DeployerMBeanImplBase _deployerMBean;
    protected DataSink _sink;
    protected String _deployName;
    protected Map _extraParams;
    protected SharedModuleType _moduleType;
    protected boolean _isRedeploy;
    protected ObjectName[] _targets;
    private ContextContainer _contextContainer;

    public DeployerRunnable(DeployerMBeanImplBase deployerMBean, DataSink sink, String deployName, Map extraParams, SharedModuleType moduleType, boolean isRedeploy, ObjectName[] targets) {
        this._deployerMBean = deployerMBean;
        this._sink = sink;
        this._deployName = deployName;
        this._extraParams = extraParams;
        this._moduleType = moduleType;
        this._isRedeploy = isRedeploy;
        this._targets = targets;
        this._contextContainer = ThreadState.getCurrentState().getContextContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        try {
            try {
                thread.setName("DeployerRunnable Thread for " + this._deployName);
                if (this._contextContainer != null) {
                    ThreadState.getCurrentState().contextContainer = this._contextContainer;
                }
                this.doRun();
            }
            catch (Exception e) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, e.getMessage(), e);
                }
                Object var5_4 = null;
                this._deployerMBean.clear(this._sink.getId());
                thread.setName(threadName);
                ThreadState.getCurrentState().contextContainer = null;
                return;
            }
            Object var5_3 = null;
            this._deployerMBean.clear(this._sink.getId());
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._deployerMBean.clear(this._sink.getId());
            thread.setName(threadName);
            ThreadState.getCurrentState().contextContainer = null;
            throw throwable;
        }
        thread.setName(threadName);
        ThreadState.getCurrentState().contextContainer = null;
    }

    protected abstract void doRun() throws DeployerException;

    public abstract void cancel() throws DeployerException;
}

