/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.server.mbeans.deploy;

import com.evermind.server.ApplicationServer;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.UploaderStateKeeper;
import oracle.oc4j.admin.jmx.server.mbeans.deploy.DeployerMBeanBase;
import oracle.oc4j.admin.jmx.server.mbeans.deploy.DeployerRunnable;
import oracle.oc4j.admin.jmx.server.mbeans.deploy.UnDeployerRunnable;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public abstract class DeployerMBeanImplBase
extends NotificationBroadcasterSupport
implements DeployerMBeanBase {
    protected Hashtable _internalDeployers = new Hashtable();

    public DeployerRunnable clear(Integer id) {
        return (DeployerRunnable)this._internalDeployers.remove(id);
    }

    public void deploy(Integer id, String deployName, Map extraParams, SharedModuleType moduleType, ObjectName[] targets) throws DeployerException {
        boolean isRedeploy = false;
        this.deployFromId(id, deployName, extraParams, moduleType, isRedeploy, targets);
    }

    public Integer deploy(String deployFilePath, String deployName, Map extraParams, SharedModuleType moduleType, ObjectName[] targets) throws DeployerException {
        boolean isRedeploy = false;
        DataSink sink = new DataSink(deployFilePath);
        return this.internalDeploy(sink, deployName, extraParams, moduleType, isRedeploy, targets);
    }

    public void redeploy(Integer id, String deployName, Map extraParams, SharedModuleType moduleType, ObjectName[] targets) throws DeployerException {
        boolean isRedeploy = true;
        this.deployFromId(id, deployName, extraParams, moduleType, isRedeploy, targets);
    }

    public Integer redeploy(String deployFilePath, String deployName, Map extraParams, SharedModuleType moduleType, ObjectName[] targets) throws DeployerException {
        boolean isRedeploy = true;
        DataSink sink = new DataSink(deployFilePath);
        return this.internalDeploy(sink, deployName, extraParams, moduleType, isRedeploy, targets);
    }

    public void undeploy(String deployName, boolean isRar, ObjectName[] targets) throws DeployerException {
        UnDeployerRunnable runnable = this.getUnDeployerRunnable(deployName, isRar, targets);
        ApplicationServer.getInstance().getThreadPool().launch(runnable);
    }

    public void cancel(Integer id) throws DeployerException {
        DeployerRunnable runnable = (DeployerRunnable)this._internalDeployers.get(id);
        if (runnable == null) {
            throw new DeployerException("cancel(): unable to find id " + id);
        }
        runnable.cancel();
    }

    private void deployFromId(Integer id, String deployName, Map extraParams, SharedModuleType moduleType, boolean isRedeploy, ObjectName[] targets) throws DeployerException {
        File uploadFile = (File)UploaderStateKeeper.getState(id);
        DataSink sink = new DataSink(uploadFile.getAbsolutePath());
        sink.setUploadId(id);
        this.internalDeploy(sink, deployName, extraParams, moduleType, isRedeploy, targets);
    }

    protected Integer internalDeploy(DataSink sink, String deployName, Map extraParams, SharedModuleType moduleType, boolean isRedeploy, ObjectName[] targets) throws DeployerException {
        DeployerRunnable runnable = this.getDeployerRunnable(sink, deployName, extraParams, moduleType, isRedeploy, targets);
        Integer id = sink.getId();
        this._internalDeployers.put(id, runnable);
        ApplicationServer.getInstance().getThreadPool().launch(runnable);
        return id;
    }

    protected abstract DeployerRunnable getDeployerRunnable(DataSink var1, String var2, Map var3, SharedModuleType var4, boolean var5, ObjectName[] var6);

    protected abstract UnDeployerRunnable getUnDeployerRunnable(String var1, boolean var2, ObjectName[] var3);
}

