/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.server;

import com.evermind.security.MemoryUser;
import com.evermind.security.User;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.server.state.LocalizationFilterMBeanServer;
import oracle.oc4j.admin.jmx.server.state.LoggerFilterMBeanServer;
import oracle.oc4j.admin.jmx.shared.Debug;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;

public class IasMBeanServerFactory {
    private static Logger logger_ = TraceLogger.getLogger(IasMBeanServerFactory.class);
    private static MBeanServer singletonMBeanServer_ = null;
    private static MBeanServer singletonLocalMBeanServer_ = null;
    private static boolean initFlag_ = false;
    private static User user_ = null;

    public static void setInternalConnectionsCredentials(User user) {
        user_ = user;
    }

    public static void setInternalConnectionsCredentials(String login, String cred) {
        user_ = new MemoryUser(login, cred);
    }

    public static User getInternalConnectionsCredentials() {
        return user_;
    }

    public static MBeanServer getMBeanServer() {
        if (!initFlag_) {
            IasMBeanServerFactory.init();
        }
        return new LocalizationFilterMBeanServer(singletonMBeanServer_);
    }

    public static MBeanServer getLocalMBeanServer() {
        if (!initFlag_) {
            IasMBeanServerFactory.init();
        }
        return new LocalizationFilterMBeanServer(singletonLocalMBeanServer_);
    }

    private static synchronized void init() {
        try {
            ArrayList<MBeanServer> registeredMBeanServers;
            if (initFlag_) {
                return;
            }
            if (logger_.isLoggable(Level.FINEST)) {
                logger_.finest("Creating MBeanServer for domain ias");
            }
            System.setProperty("javax.management.builder.initial", "javax.management.MBeanServerBuilder");
            String JDK15_JMX_ON = System.getProperty("com.sun.management.jmxremote");
            String IAS_JMX_ON = System.getProperty("oracle.oc4j.ias.jmxremote");
            String JMX_REGISTER_MBEANSERVER_ON = System.getProperty("oracle.oc4j.jmx.mbeanserver.register");
            if (JDK15_JMX_ON != null && IAS_JMX_ON != null && (registeredMBeanServers = MBeanServerFactory.findMBeanServer(null)) != null && registeredMBeanServers.size() > 0) {
                singletonLocalMBeanServer_ = registeredMBeanServers.get(0);
            }
            if (singletonLocalMBeanServer_ == null) {
                singletonLocalMBeanServer_ = JMX_REGISTER_MBEANSERVER_ON == null ? MBeanServerFactory.newMBeanServer("ias") : MBeanServerFactory.createMBeanServer("ias");
            }
            System.setProperty("javax.management.builder.initial", "oracle.oc4j.admin.jmx.server.Oc4jMBeanServerBuilder");
            IasMBeanServerFactory.createMBeanServerDelegate();
            J2EEManagedObjectBase.registerMBeanServer("ias", singletonMBeanServer_);
            initFlag_ = true;
            IasMBeanServerFactory.initFarmManager();
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private static void initFarmManager() {
        try {
            Class<?> cl = Class.forName("oracle.oc4j.admin.jmx.distributed.Bootstrap");
            if (user_ == null) {
                Method start = cl.getMethod("start", null);
                start.invoke(null, null);
            } else {
                Class[] paramTypes = new Class[]{User.class};
                Method start = cl.getMethod("start", paramTypes);
                Object[] params = new Object[]{user_};
                start.invoke(null, params);
            }
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e, "Nested Exception: Farm Manager initialization error");
        }
    }

    private static void createMBeanServerDelegate() {
        try {
            Class<?> cl = Class.forName("oracle.oc4j.admin.jmx.distributed.MBeanServerDelegate");
            Method createMBeanServer = cl.getMethod("createMBeanServer", null);
            singletonMBeanServer_ = (MBeanServer)createMBeanServer.invoke(null, null);
            if (Debug.isDebug()) {
                singletonMBeanServer_ = new LoggerFilterMBeanServer(singletonMBeanServer_);
            }
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new JMXRuntimeException((Throwable)e);
        }
    }
}

