/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.deployment.WebModule;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.HttpSiteConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.internal.WebApplicationBase;

public class WebApplicationUnbinder
extends WebApplicationBase {
    private static Logger logger_ = TraceLogger.getLogger(WebApplicationUnbinder.class);

    public void unbindWebApp(String appName, String siteName) throws DeployerException {
        Collection webApps = this.getWebApps(appName);
        if (webApps == null || webApps.isEmpty()) {
            return;
        }
        Iterator iterator = webApps.iterator();
        while (iterator.hasNext()) {
            WebModule mod = (WebModule)iterator.next();
            String webName = mod.getName();
            this.unbindWebApp(appName, webName, siteName);
        }
    }

    public void unbindWebApp(String appName, String webName, String siteName) throws DeployerException {
        Collection webApps = this.getWebApps(appName);
        if (webApps == null || webApps.isEmpty()) {
            return;
        }
        Iterator iterator = webApps.iterator();
        while (iterator.hasNext()) {
            WebModule mod = (WebModule)iterator.next();
            String name = mod.getName();
            if (!name.equals(webName)) continue;
            this.unbindWebApp(appName, webName, siteName, mod.getContextRoot());
            return;
        }
    }

    public void unbindWebApp(String appName, String webName, String siteName, String root) throws DeployerException {
        HttpSite site;
        Application application = this.getApplication(appName);
        HttpServer httpServer = ApplicationServer.getInstance().getHttpServer();
        if (httpServer == null) {
            throw new DeployerException("The Http server is unavailable to unbind web applications.");
        }
        Notifier notifier = Notifier.getNotifier();
        if (notifier != null) {
            try {
                String[] params = new String[]{webName, appName, siteName, root};
                notifier.sendNotification("UNBINDING_WEBMODULE_FROM_SITE", params);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            site = this.getSite(siteName, httpServer);
        }
        catch (Exception e) {
            throw new DeployerException("Site " + siteName + " is not found", e);
        }
        if (site == null) {
            String errMsg;
            block13: {
                errMsg = "Unknown site: " + siteName + "\n";
                errMsg = errMsg + "Active sites are:\n";
                try {
                    List sites = httpServer.getSites();
                    for (int i = 0; i < sites.size(); ++i) {
                        errMsg = errMsg + ((HttpSite)sites.get(i)).getName() + "\n";
                    }
                }
                catch (Exception e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block13;
                    logger_.log(Level.SEVERE, "Unable to get active sites: " + e.getMessage(), e);
                }
            }
            throw new DeployerException(errMsg);
        }
        HttpSiteConfig config = site.getConfig();
        try {
            if (config.unBindApplication(appName)) {
                config.store();
            }
        }
        catch (IOException e) {
            DeployerException exception = new DeployerException("Unable to remove web binding " + root + " for web module " + webName + " for application " + appName);
            exception.initCause(exception);
            throw exception;
        }
        site.removeHttpApplication(application);
    }
}

