/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.WebModule;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import oracle.oc4j.admin.internal.DeployerException;

public class WebApplicationBase {
    Application getApplication(String appName) throws DeployerException {
        Application application = null;
        try {
            application = ApplicationServer.getInstance().getApplication(appName);
            if (application == null) {
                throw new DeployerException("Application " + appName + " is not found.");
            }
        }
        catch (InstantiationException e) {
            throw new DeployerException("Application " + appName + " is not found", e);
        }
        return application;
    }

    Collection getWebApps(String appName) throws DeployerException {
        Application application = this.getApplication(appName);
        EnterpriseArchive archive = (EnterpriseArchive)application.getConfig();
        Collection webApps = archive.getWebApplications();
        return webApps;
    }

    String getContextRoot(String appName, String webName) throws DeployerException {
        Application application;
        try {
            application = ApplicationServer.getInstance().getApplication(appName);
            if (application == null) {
                throw new DeployerException("Application " + appName + " is not found");
            }
        }
        catch (InstantiationException e) {
            throw new DeployerException("Application " + appName + " is not found", e);
        }
        EnterpriseArchive archive = (EnterpriseArchive)application.getConfig();
        WebModule module = archive.getWebApplication(webName);
        if (module == null) {
            throw new DeployerException("Web module " + webName + " in application " + appName + " is not found");
        }
        return module.getContextRoot();
    }

    HttpSite getSite(String name, HttpServer httpServer) {
        List sites = httpServer.getSites();
        for (int i = 0; i < sites.size(); ++i) {
            HttpSite site = (HttpSite)sites.get(i);
            if (site.getName().equals(name) || site.getShortName().equals(name)) {
                return site;
            }
            String siteName = site.getName();
            if (!siteName.endsWith(".xml")) continue;
            try {
                URL url = new URL(name);
                File file = new File(url.getFile());
                String path = file.getCanonicalFile().toURL().toString();
                if (!site.getName().equals(path)) continue;
                return site;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }
}

