/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import com.evermind.server.ApplicationServer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.instrument.NounIntf;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.internal.UnDeployerIF;

public abstract class UnDeployerBase
extends Notifier
implements UnDeployerIF {
    static final String BACKUP = "_backup";
    private static Logger logger_ = TraceLogger.getLogger(UnDeployerBase.class);
    protected String _deploymentName;
    private boolean _isVerbose = ApplicationServer.getInstance().getVerbosityLevel() >= 3;
    protected static Logger m_logger = Logger.getLogger(UnDeployerBase.class.getName());

    public UnDeployerBase(String name) {
        this._deploymentName = name;
    }

    public Map execute() throws DeployerException {
        return this.execute(true);
    }

    public Map execute(boolean undo) throws DeployerException {
        Map map;
        block10: {
            String[] params = new String[]{this.getNotificationSource().toString(), this._deploymentName};
            try {
                if (undo) {
                    this.registerNotifierWithThread();
                    this.sendNotification("START_OPERATION", params);
                }
                boolean requiresRestart = this.doUndeploy();
                if (undo) {
                    if (requiresRestart) {
                        this.reportStateChange("OPERATION_COMPLETES_AND_RESTART_REQUIRED", params, 100);
                    } else {
                        this.reportStateChange("OPERATION_COMPLETES", params, 100);
                    }
                }
                this.destroyDMSNounForThisApp();
                this.addOutput();
                map = this.getReturnValues();
                Object var6_6 = null;
                if (!undo) break block10;
            }
            catch (DeployerException e) {
                try {
                    if (logger_.isLoggable(Level.SEVERE)) {
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                    this.reportError("OPERATION_FAILED", params, e);
                    throw (DeployerException)e.fillInStackTrace();
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (undo) {
                        this.unregisterNotifierWithThread();
                    }
                    this.clean();
                    throw throwable;
                }
            }
            this.unregisterNotifierWithThread();
        }
        this.clean();
        return map;
    }

    protected void clean() {
    }

    protected String getNotificationType() {
        return "undeploy." + this._deploymentName;
    }

    protected boolean isVerbose() {
        return this._isVerbose;
    }

    protected abstract Object getNotificationSource();

    protected abstract ObjectName getTargetObjectName();

    protected abstract boolean isRar();

    protected abstract boolean doUndeploy() throws DeployerException;

    private void destroyDMSNounForThisApp() {
        try {
            if (this._deploymentName != null) {
                NounIntf rootNoun;
                String rootName = "@oc4j@" + this._deploymentName;
                NounFactoryIntf factory = ApplicationServer.nounFactory();
                if (factory != null && (rootNoun = factory.get(rootName)) != null) {
                    if (m_logger.isLoggable(Level.FINE)) {
                        m_logger.log(Level.FINE, "Destroying DMS Noun = " + rootNoun.getName());
                    }
                    rootNoun.destroy();
                }
            }
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "Caught exception: " + e.getMessage(), e);
        }
    }
}

