/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanException;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanExceptionHelper;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.OpmnCompCallBack;
import oracle.oc4j.admin.internal.OpmnCompOc4jGroupCallBack;
import oracle.oc4j.admin.internal.OpmnProcCallBack;
import oracle.oc4j.admin.internal.OpmnRuntimeHelper;
import oracle.oc4j.admin.internal.OpmnXmlHelper;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnProcOc4jCallBackIf;
import org.w3c.dom.Element;

public class OpmnProcOc4jCallBack
extends OpmnProcCallBack
implements OpmnProcOc4jCallBackIf {
    private static Logger logger_ = TraceLogger.getLogger(OpmnProcOc4jCallBack.class);
    static String[] ParamCats = new String[]{"start-parameters", "stop-parameters", "restart-parameters", "url-parameters", "security-parameters"};
    static String[][] ParamNames = new String[][]{{"java-options", "oc4j-options", "config-file", "java-bin", "routing-id"}, {"java-options"}, {"reverseping-timeout", "no-reverseping-failed-ping-limit", "reverseping-failed-ping-limit"}, null, {"wallet-file", "wallet-password"}};

    public OpmnProcOc4jCallBack(OpmnCompCallBack parent, Element procNode) {
        super(parent, procNode);
    }

    void setParent(OpmnCompOc4jGroupCallBack parent) {
        this.parent_ = parent;
    }

    public String getMBeanClassName() {
        return "oracle.oc4j.admin.management.mbeans.OpmnProcOc4j";
    }

    public String getType() {
        return "OpmnProcOc4j";
    }

    public String getParameter(String category, String paramName) throws ConfigMBeanException {
        return OpmnXmlHelper.getParameter(this.procNode_, category, paramName, ParamCats, ParamNames, "OC4J");
    }

    public void setParameter(String category, String paramName, String paramValue) throws ConfigMBeanException {
        if ("start-parameters".equals(category) && "java-options".equals(paramName)) {
            this.validateCmdLineOptions(paramValue, 68);
        } else if ("start-parameters".equals(category) && "oc4j-options".equals(paramName)) {
            this.validateCmdLineOptions(paramValue, 72);
        }
        OpmnXmlHelper.setParameter(this.procNode_, category, paramName, paramValue, ParamCats, ParamNames, "OC4J", OrderedSubTags);
    }

    public void removeParameter(String category, String paramName) throws ConfigMBeanException {
        OpmnXmlHelper.removeParameter(this.procNode_, category, paramName, ParamCats, ParamNames, "OC4J");
    }

    public void setEnabled(boolean enable) throws ConfigMBeanException {
        this.setAttr("status", enable ? "enabled" : "disabled");
    }

    public void setAttr(String attrName, String attrValue) throws ConfigMBeanException {
        if ("id".equals(attrName)) {
            throw ConfigMBeanExceptionHelper.getException(62, this.getType() + ":" + this.getname(), JMXStateFactory.getJMXState().getLocale());
        }
        if ("status".equals(attrName) && "disabled".equals(attrValue) && OpmnRuntimeHelper.isOc4jAlive(this.getOracleHome(), this.getParentName(), this.getname())) {
            throw ConfigMBeanExceptionHelper.getException(70, this.getname(), JMXStateFactory.getJMXState().getLocale());
        }
        OpmnXmlHelper.setElementAttr(this.procNode_, attrName, attrValue, ProcNodeAttrNames, ProcNodeAttrValues);
    }

    public int getnumProcs() {
        Element elem = OpmnXmlHelper.getChildElement(this.procNode_, "process-set", null, null, true, null);
        String idStr = elem.getAttribute("id");
        if (idStr == null || idStr.trim().length() == 0) {
            elem.setAttribute("id", this.parent_.getname());
        }
        String numProcsStr = elem.getAttribute("numprocs");
        try {
            int numProcs = Integer.parseInt(numProcsStr);
            return numProcs;
        }
        catch (NumberFormatException e) {
            String serviceFailover = this.procNode_.getAttribute("service-failover");
            try {
                int serviceFailoverInt = Integer.parseInt(serviceFailover);
                if (serviceFailoverInt > 0) {
                    elem.removeAttribute("numprocs");
                    return 1;
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            elem.setAttribute("numprocs", "1");
            return 1;
        }
    }

    public void setnumProcs(int n) throws ConfigMBeanException {
        this.setProcessSet(null, n);
    }

    public String getJVMOptions() {
        String result = null;
        try {
            result = this.getParameter("start-parameters", "java-options");
            if (result != null && result.trim().length() == 0) {
                result = null;
            }
        }
        catch (ConfigMBeanException e) {
            result = null;
            logger_.log(Level.WARNING, "get start-param/java-options error", e);
        }
        return result;
    }

    public void addJVMOption(String option) throws ConfigMBeanException {
        String optPrefix;
        if (option == null || option.trim().length() == 0 || option.trim().charAt(0) != '-') {
            throw ConfigMBeanExceptionHelper.getException(67, option, JMXStateFactory.getJMXState().getLocale());
        }
        ArrayList existOpts = this.splitCmdLineOptions(this.getJVMOptions());
        int pos = this.searchJVMOption(existOpts, optPrefix = this.getJVMOptionPrefix(option = option.trim().replace('\t', ' ')));
        if (pos >= 0) {
            existOpts.remove(pos);
        }
        existOpts.add(option);
        this.setJVMOptions(existOpts);
    }

    public void setJVMOptions(String options) throws ConfigMBeanException {
        this.setParameter("start-parameters", "java-options", options);
    }

    private void validateCmdLineOptions(String options, int errorCode) throws ConfigMBeanException {
        if (options != null) {
            options = options.trim();
        }
        if (options == null || options.length() > 0 && options.charAt(0) != '-' || !OpmnXmlHelper.validateXMLValue(options)) {
            throw ConfigMBeanExceptionHelper.getException(errorCode, options, JMXStateFactory.getJMXState().getLocale());
        }
    }

    public void removeJVMOption(String option) throws ConfigMBeanException {
        String optPrefix;
        if (option == null || option.trim().length() == 0 || option.trim().charAt(0) != '-') {
            throw ConfigMBeanExceptionHelper.getException(67, option, JMXStateFactory.getJMXState().getLocale());
        }
        ArrayList existOpts = this.splitCmdLineOptions(this.getJVMOptions());
        int pos = this.searchJVMOption(existOpts, optPrefix = this.getJVMOptionPrefix(option = option.trim().replace('\t', ' ')));
        if (pos < 0) {
            throw ConfigMBeanExceptionHelper.getException(69, option, JMXStateFactory.getJMXState().getLocale());
        }
        existOpts.remove(pos);
        this.setJVMOptions(existOpts);
    }

    public String getOC4JOptions() {
        String result = null;
        try {
            result = this.getParameter("start-parameters", "oc4j-options");
            if (result != null && result.trim().length() == 0) {
                result = null;
            }
        }
        catch (ConfigMBeanException e) {
            result = null;
            logger_.log(Level.WARNING, "get start-param/oc4j-options error", e);
        }
        return result;
    }

    public void setOC4JOptions(String options) throws ConfigMBeanException {
        if (options == null || options.trim().length() == 0) {
            this.removeParameter("start-parameters", "oc4j-options");
        } else {
            this.setParameter("start-parameters", "oc4j-options", options);
        }
    }

    public void addOC4JOption(String option) throws ConfigMBeanException {
        String optPrefix;
        if (option == null || option.trim().length() == 0 || option.trim().charAt(0) != '-') {
            throw ConfigMBeanExceptionHelper.getException(71, option, JMXStateFactory.getJMXState().getLocale());
        }
        ArrayList existOpts = this.splitCmdLineOptions(this.getOC4JOptions());
        int pos = this.searchCmdLineOption(existOpts, optPrefix = this.getOC4JOptionPrefix(option = option.trim().replace('\t', ' ')));
        if (pos >= 0) {
            existOpts.remove(pos);
        }
        existOpts.add(option);
        this.setOC4JOptions(existOpts);
    }

    public void removeOC4JOption(String option) throws ConfigMBeanException {
        String optPrefix;
        if (option == null || option.trim().length() == 0 || option.trim().charAt(0) != '-') {
            throw ConfigMBeanExceptionHelper.getException(71, option, JMXStateFactory.getJMXState().getLocale());
        }
        ArrayList existOpts = this.splitCmdLineOptions(this.getOC4JOptions());
        int pos = this.searchCmdLineOption(existOpts, optPrefix = this.getOC4JOptionPrefix(option = option.trim().replace('\t', ' ')));
        if (pos < 0) {
            throw ConfigMBeanExceptionHelper.getException(73, option, JMXStateFactory.getJMXState().getLocale());
        }
        existOpts.remove(pos);
        this.setOC4JOptions(existOpts);
    }

    private String getOc4jOption(String option) {
        if (option == null || option.trim().length() == 0 || option.trim().charAt(0) != '-') {
            return null;
        }
        ArrayList existOpts = this.splitCmdLineOptions(this.getOC4JOptions());
        option = option.trim().replace('\t', ' ');
        String optPrefix = null;
        try {
            optPrefix = this.getOC4JOptionPrefix(option);
        }
        catch (ConfigMBeanException e) {
            logger_.log(Level.WARNING, "getOc4jOption(" + option + ") error", e);
            return null;
        }
        int pos = this.searchCmdLineOption(existOpts, optPrefix);
        if (pos < 0) {
            return null;
        }
        return (String)existOpts.get(pos);
    }

    public boolean getuserThreads() {
        String value = this.getOc4jOption("-userThreads");
        return value != null;
    }

    public void setuserThreads(boolean value) {
        try {
            if (value) {
                this.addOC4JOption("-userThreads");
            } else {
                this.removeOC4JOption("-userThreads");
            }
        }
        catch (ConfigMBeanException e) {
            logger_.log(Level.WARNING, "setuserThread to " + value + " failed", e);
        }
    }

    public String getstdOut() {
        String value = this.getOc4jOption("-out");
        if (value != null && value.length() > 5) {
            return value.substring(5);
        }
        return null;
    }

    public void setstdOut(String fileName) throws ConfigMBeanException {
        if (fileName == null || fileName.trim().length() == 0) {
            this.removeOC4JOption("-out");
            return;
        }
        this.addOC4JOption("-out " + fileName.trim());
    }

    public String getstdErr() {
        String value = this.getOc4jOption("-err");
        if (value != null && value.length() > 5) {
            return value.substring(5);
        }
        return null;
    }

    public void setstdErr(String fileName) throws ConfigMBeanException {
        if (fileName == null || fileName.trim().length() == 0) {
            this.removeOC4JOption("-err");
            return;
        }
        this.addOC4JOption("-err " + fileName.trim());
    }

    public String getRoutingId() {
        String result = null;
        try {
            result = this.getParameter("start-parameters", "routing-id");
            if (result != null && result.trim().length() == 0) {
                result = null;
            }
        }
        catch (ConfigMBeanException e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public void setRoutingId(String routingId) throws ConfigMBeanException {
        if (!OpmnXmlHelper.validateName(routingId)) {
            throw ConfigMBeanExceptionHelper.getException(15, routingId, JMXStateFactory.getJMXState().getLocale());
        }
        this.setParameter("start-parameters", "routing-id", routingId);
    }

    public boolean isRemovable() {
        if (!((OpmnCompOc4jGroupCallBack)this.parent_).isPureOc4jGroup()) {
            return false;
        }
        return !"home".equals(this.getname()) || !this.parent_.getOracleHome().equals(this.parent_.getConfigHome());
    }

    void setProcessSet(String id, int numprocs) {
        Element elem = OpmnXmlHelper.getChildElement(this.procNode_, "process-set", null, null, true, null);
        if (id != null && id.trim().length() != 0) {
            elem.setAttribute("id", id);
        }
        String serviceFailover = this.procNode_.getAttribute("service-failover");
        try {
            int serviceFailoverInt = Integer.parseInt(serviceFailover);
            if (serviceFailoverInt > 0) {
                elem.removeAttribute("numprocs");
                return;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (numprocs <= 0) {
            numprocs = 1;
        }
        elem.setAttribute("numprocs", Integer.toString(numprocs));
    }

    private void setJVMOptions(ArrayList options) throws ConfigMBeanException {
        if (options.size() <= 0) {
            this.setJVMOptions("");
            return;
        }
        StringBuffer buf = new StringBuffer((String)options.get(0));
        for (int i = 1; i < options.size(); ++i) {
            buf.append(' ').append(options.get(i));
        }
        this.setJVMOptions(buf.toString());
    }

    private ArrayList splitCmdLineOptions(String options) {
        ArrayList<String> result = new ArrayList<String>();
        if (options == null || options.trim().length() == 0) {
            return result;
        }
        options = options.replace('\t', ' ');
        String[] splitedOpts = options.split(" -");
        for (int i = 0; i < splitedOpts.length; ++i) {
            if (i == 0) {
                result.add(splitedOpts[i].trim());
                continue;
            }
            result.add("-" + splitedOpts[i].trim());
        }
        return result;
    }

    private String getJVMOptionPrefix(String option) throws ConfigMBeanException {
        String optPrefix;
        if (option.startsWith("-cp")) {
            optPrefix = "-cp";
        } else if (option.startsWith("-classpath")) {
            optPrefix = "-classpath";
        } else if (option.startsWith("-D")) {
            int pos = option.indexOf(61);
            optPrefix = pos > 0 ? option.substring(0, pos) : option;
        } else if (option.startsWith("-XX")) {
            int pos = option.indexOf(61);
            if (pos > 0) {
                optPrefix = option.substring(0, pos);
            } else {
                optPrefix = option.substring(4, option.length());
                if (optPrefix.startsWith("+") || optPrefix.startsWith("-")) {
                    optPrefix = optPrefix.substring(1, optPrefix.length());
                }
                optPrefix = "-XX:" + optPrefix;
            }
        } else {
            int pos;
            optPrefix = option.startsWith("-Xms") ? "-Xms" : (option.startsWith("-Xmx") ? "-Xmx" : (option.startsWith("-Xss") ? "-Xss" : ((pos = option.indexOf(58)) > 0 ? option.substring(0, pos) : option)));
        }
        if (!optPrefix.equals("-cp") && !optPrefix.equals("-classpath") && option.indexOf(32) > 0) {
            throw ConfigMBeanExceptionHelper.getException(67, option, JMXStateFactory.getJMXState().getLocale());
        }
        return optPrefix;
    }

    private int searchJVMOption(ArrayList options, String optPrefix) throws ConfigMBeanException {
        if (optPrefix.equals("-cp")) {
            int pos = this.searchCmdLineOption(options, optPrefix);
            if (pos < 0) {
                return this.searchCmdLineOption(options, "-classpath");
            }
            return pos;
        }
        if (optPrefix.equals("-classpath")) {
            int pos = this.searchCmdLineOption(options, optPrefix);
            if (pos < 0) {
                return this.searchCmdLineOption(options, "-cp");
            }
            return pos;
        }
        for (int i = 0; i < options.size(); ++i) {
            String opt = (String)options.get(i);
            String optPrefix2 = this.getJVMOptionPrefix(opt);
            if (!optPrefix2.equals(optPrefix)) continue;
            return i;
        }
        return -1;
    }

    private int searchCmdLineOption(ArrayList options, String optPrefix) {
        for (int i = 0; i < options.size(); ++i) {
            String opt = (String)options.get(i);
            if (!opt.startsWith(optPrefix)) continue;
            return i;
        }
        return -1;
    }

    private String getOC4JOptionPrefix(String option) throws ConfigMBeanException {
        String optPrefix;
        int pos = option.indexOf(32);
        if (pos > 0) {
            if (option.substring(pos).trim().startsWith("-")) {
                throw ConfigMBeanExceptionHelper.getException(71, option, JMXStateFactory.getJMXState().getLocale());
            }
            optPrefix = option.substring(0, pos);
        } else {
            optPrefix = option;
        }
        return optPrefix;
    }

    private void setOC4JOptions(ArrayList options) throws ConfigMBeanException {
        if (options.size() <= 0) {
            this.setOC4JOptions("");
            return;
        }
        StringBuffer buf = new StringBuffer((String)options.get(0));
        for (int i = 1; i < options.size(); ++i) {
            buf.append(' ').append(options.get(i));
        }
        this.setOC4JOptions(buf.toString());
    }
}

