/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import java.io.File;
import java.util.Map;
import java.util.logging.Logger;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanException;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanExceptionHelper;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.config.CreationException;
import oracle.oc4j.admin.config.Oc4jCreator;
import oracle.oc4j.admin.config.Oc4jRemover;
import oracle.oc4j.admin.internal.OpmnCompCallBack;
import oracle.oc4j.admin.internal.OpmnConfigCallBack;
import oracle.oc4j.admin.internal.OpmnProcCallBack;
import oracle.oc4j.admin.internal.OpmnProcOc4jCallBack;
import oracle.oc4j.admin.internal.OpmnRuntimeHelper;
import oracle.oc4j.admin.internal.OpmnXmlHelper;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnCompOc4jGroupCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnProcCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnProcOc4jCallBackIf;
import org.w3c.dom.Element;

public class OpmnCompOc4jGroupCallBack
extends OpmnCompCallBack
implements OpmnCompOc4jGroupCallBackIf {
    private static Logger logger_ = TraceLogger.getLogger(OpmnCompOc4jGroupCallBack.class);

    public OpmnCompOc4jGroupCallBack(OpmnConfigCallBack parent, Element compNode) {
        super(parent, compNode);
    }

    public String getMBeanClassName() {
        return "oracle.oc4j.admin.management.mbeans.OpmnCompOc4jGroup";
    }

    public String getType() {
        return "OpmnCompOc4jGroup";
    }

    public OpmnProcCallBackIf[] getProcs() {
        Element[] nodes = OpmnXmlHelper.getChildElements(this.compNode_, "process-type");
        OpmnProcCallBackIf[] procs = new OpmnProcCallBack[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            String moduleId = nodes[i].getAttribute("module-id");
            procs[i] = "OC4J".equals(moduleId) ? new OpmnProcOc4jCallBack(this, nodes[i]) : new OpmnProcCallBack(this, nodes[i]);
        }
        return procs;
    }

    public boolean isPureOc4jGroup() {
        Element[] nodes = OpmnXmlHelper.getChildElements(this.compNode_, "process-type");
        boolean isPure = true;
        for (int i = 0; i < nodes.length; ++i) {
            String moduleId = nodes[i].getAttribute("module-id");
            if ("OC4J".equals(moduleId)) continue;
            isPure = false;
            break;
        }
        return isPure;
    }

    public String getParameter(String category, String paramName) throws ConfigMBeanException {
        return OpmnXmlHelper.getParameter(this.compNode_, category, paramName, OpmnProcOc4jCallBack.ParamCats, OpmnProcOc4jCallBack.ParamNames, "OC4J");
    }

    public void setParameter(String category, String paramName, String paramValue) throws ConfigMBeanException {
        OpmnXmlHelper.setParameter(this.compNode_, category, paramName, paramValue, OpmnProcOc4jCallBack.ParamCats, OpmnProcOc4jCallBack.ParamNames, "OC4J", OrderedSubTags);
    }

    public void removeParameter(String category, String paramName) throws ConfigMBeanException {
        OpmnXmlHelper.removeParameter(this.compNode_, category, paramName, OpmnProcOc4jCallBack.ParamCats, OpmnProcOc4jCallBack.ParamNames, "OC4J");
    }

    public void setAttr(String attrName, String attrValue) throws ConfigMBeanException {
        if ("id".equals(attrName)) {
            throw ConfigMBeanExceptionHelper.getException(62, this.getType() + ":" + this.getname(), JMXStateFactory.getJMXState().getLocale());
        }
        if ("status".equals(attrName) && "disabled".equals(attrValue) && OpmnRuntimeHelper.isOc4jGroupAlive(this.getConfigHome(), this.getname())) {
            throw ConfigMBeanExceptionHelper.getException(74, this.getname(), JMXStateFactory.getJMXState().getLocale());
        }
        OpmnXmlHelper.setElementAttr(this.compNode_, attrName, attrValue, CompNodeAttrNames, CompNodeAttrValues);
    }

    public void setEnabled(boolean enable) throws ConfigMBeanException {
        this.setAttr("status", enable ? "enabled" : "disabled");
    }

    public OpmnProcCallBackIf createOc4j(String oc4jName, String password, boolean start, Map extraParams) throws ConfigMBeanException {
        if (!OpmnXmlHelper.validateName(oc4jName)) {
            throw ConfigMBeanExceptionHelper.getException(58, oc4jName, JMXStateFactory.getJMXState().getLocale());
        }
        Element oc4jElem = OpmnXmlHelper.getOc4jElement(this.compNode_, oc4jName);
        if (oc4jElem != null) {
            String groupId = ((Element)oc4jElem.getParentNode()).getAttribute("id");
            throw ConfigMBeanExceptionHelper.getException(55, oc4jName, groupId, JMXStateFactory.getJMXState().getLocale());
        }
        String fileName = !extraParams.isEmpty() && extraParams.get("opmnsnippet") != null ? (String)extraParams.get("opmnsnippet") : this.parent_.getConfigHome() + File.separator + "config" + File.separator + "oc4j_home.xml";
        OpmnProcOc4jCallBack oc4j = null;
        if (extraParams.isEmpty() || "false".equals(extraParams.get("clone.home"))) {
            oc4j = new File(fileName).exists() ? OpmnXmlHelper.addTemplateOc4jElement(this, oc4jName, fileName) : OpmnXmlHelper.addVanillaOc4jElement(this, oc4jName);
        } else if (OpmnXmlHelper.getOc4jElement(this.compNode_, "home") != null) {
            oc4j = OpmnXmlHelper.cloneOc4jHomeElement(this, oc4jName);
        } else if (OpmnXmlHelper.getOc4jElement(this.compNode_, "default_oc4j") != null) {
            oc4j = OpmnXmlHelper.cloneDefaultOc4jElement(this, oc4jName);
        } else if (!this.parent_.getOracleHome().equals(this.parent_.getConfigHome())) {
            oc4j = new File(fileName).exists() ? OpmnXmlHelper.addTemplateOc4jElement(this, oc4jName, fileName) : OpmnXmlHelper.addVanillaOc4jElement(this, oc4jName);
        }
        try {
            this.createOc4jInternal(oc4jName, password, extraParams, oc4j);
        }
        catch (ConfigMBeanException e) {
            this.compNode_.removeChild(oc4j.getXmlElement());
            throw e;
        }
        if (start) {
            this.store();
            this.getParent().reloadOPMN();
            OpmnRuntimeHelper.startOc4j(this.getConfigHome(), this.getname(), oc4jName);
        }
        return oc4j;
    }

    private void createOc4jInternal(String oc4jName, String password, Map extraParams, OpmnProcOc4jCallBackIf oc4jCallBack) throws ConfigMBeanException {
        String oracleHome = this.getOracleHome();
        String configHome = this.getConfigHome();
        Oc4jCreator oc4jCreator = new Oc4jCreator();
        try {
            oc4jCreator.doCreation(oracleHome, configHome, oc4jName, password, extraParams, oc4jCallBack);
        }
        catch (CreationException ce) {
            throw ConfigMBeanExceptionHelper.getException(59, ce.getMessage(), (Throwable)ce, JMXStateFactory.getJMXState().getLocale());
        }
    }

    public OpmnProcOc4jCallBackIf removeOc4j(String oc4jName, boolean real) throws ConfigMBeanException {
        if (!OpmnXmlHelper.validateName(oc4jName)) {
            throw ConfigMBeanExceptionHelper.getException(58, oc4jName, JMXStateFactory.getJMXState().getLocale());
        }
        Element oc4jElem = OpmnXmlHelper.getChildElement(this.compNode_, "process-type", "id", oc4jName);
        if (oc4jElem == null) {
            throw ConfigMBeanExceptionHelper.getException(56, oc4jName, this.getname(), JMXStateFactory.getJMXState().getLocale());
        }
        if (real) {
            if (this.isOc4jProcAlive(oc4jName)) {
                throw ConfigMBeanExceptionHelper.getException(70, oc4jName, JMXStateFactory.getJMXState().getLocale());
            }
            this.removeOc4jInternal(oc4jName);
        }
        this.compNode_.removeChild(oc4jElem);
        return new OpmnProcOc4jCallBack(this, oc4jElem);
    }

    private void removeOc4jInternal(String oc4jName) throws ConfigMBeanException {
        String oracleHome = this.getOracleHome();
        String configHome = this.getConfigHome();
        Oc4jRemover oc4jRemover = new Oc4jRemover();
        try {
            oc4jRemover.doRemove(oracleHome, configHome, oc4jName);
        }
        catch (CreationException ce) {
            throw ConfigMBeanExceptionHelper.getException(63, ce.getMessage(), (Throwable)ce, JMXStateFactory.getJMXState().getLocale());
        }
    }

    public void addOc4j(OpmnProcOc4jCallBackIf callback) {
        this.compNode_.appendChild(callback.getXmlElement());
        ((OpmnProcOc4jCallBack)callback).setParent(this);
    }

    public boolean isOc4jProcAlive(String oc4jName) {
        return OpmnRuntimeHelper.isOc4jAlive(this.getConfigHome(), this.getname(), oc4jName);
    }

    public void setRoutingId(String routingId) throws ConfigMBeanException {
        if (!OpmnXmlHelper.validateName(routingId)) {
            throw ConfigMBeanExceptionHelper.getException(15, routingId, JMXStateFactory.getJMXState().getLocale());
        }
        this.setParameter("start-parameters", "routing-id", routingId);
    }
}

