/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.ObjectName;
import oracle.oc4j.admin.MessageLocalizationHelper;
import oracle.oc4j.admin.internal.DeployerNotificationHandlerIF;
import oracle.oc4j.admin.jmx.shared.deploy.NotificationUserData;
import oracle.oc4j.admin.jmx.shared.exceptions.ExceptionHelper;

public abstract class Notifier
extends MessageLocalizationHelper {
    private static Map _notifierToThreadAssociation = new Hashtable();
    private Vector _notificationHandlers;
    private Map _returnValues = new HashMap();
    private ByteArrayOutputStream _bufferOut = new ByteArrayOutputStream();
    private PrintStream _bufferStream = new PrintStream(this._bufferOut, true);
    private static long _messageSequenceNumber = 0L;
    private static final String _resourceBundleLocation = "oracle.oc4j.admin.internal.Messages";
    private static Logger _logger = null;
    private static Map _localeToMessageLocalizationHelperMapping = new Hashtable();
    private static Map _localeToDateFormatMapping = new Hashtable();
    private String _notificationString = this.getLocalizedMessage("NOTIFICATION");

    protected Notifier() {
        super(Notifier.getResourceBundle(_resourceBundleLocation, Locale.getDefault()), Locale.getDefault());
        _logger = Logger.getLogger(Notifier.class.getName());
    }

    private static ResourceBundle getResourceBundle(String resourceBundleLocation, Locale loc) {
        return ResourceBundle.getBundle(resourceBundleLocation, loc);
    }

    public static MessageLocalizationHelper getMessageLocalizationHelper(Locale loc) {
        MessageLocalizationHelper locHelp = (MessageLocalizationHelper)_localeToMessageLocalizationHelperMapping.get(loc);
        if (locHelp != null) {
            return locHelp;
        }
        locHelp = new MessageLocalizationHelper(Notifier.getResourceBundle(_resourceBundleLocation, loc), loc);
        _localeToMessageLocalizationHelperMapping.put(loc, locHelp);
        return locHelp;
    }

    public static Notifier getNotifier() {
        Thread t = Thread.currentThread();
        return (Notifier)_notifierToThreadAssociation.get(t);
    }

    protected final void registerNotifierWithThread() {
        Thread t = Thread.currentThread();
        _notifierToThreadAssociation.put(t, this);
    }

    protected final void unregisterNotifierWithThread() {
        Thread t = Thread.currentThread();
        _notifierToThreadAssociation.remove(t);
    }

    public final void addNotificationHandler(DeployerNotificationHandlerIF handler) {
        if (handler == null) {
            throw new IllegalArgumentException("addNotificationHandler(), handler is null");
        }
        if (this._notificationHandlers == null) {
            this._notificationHandlers = new Vector();
        }
        this._notificationHandlers.add(handler);
    }

    public final void sendErrorNotification(Throwable t) {
        this.sendNotification("ERROR", t);
    }

    public final void sendWarningNotification(Throwable t) {
        this.sendNotification("WARNING", t);
    }

    public final void sendNotification(String msgId) {
        this.sendNotification(msgId, null, null, null);
    }

    public final void sendNotification(String msgId, Object userData) {
        this.sendNotification(msgId, null, null, userData);
    }

    public final void sendNotification(String msgId, String[] params) {
        this.sendNotification(msgId, params, null, null);
    }

    public final void sendNotification(String msgId, String[] params, Object userData) {
        this.sendNotification(msgId, params, null, userData);
    }

    public final void sendNotification(String msgId, Throwable t) {
        this.sendNotification(msgId, null, t, null);
    }

    public final void sendNotification(String msgId, String[] params, Throwable t) {
        this.sendNotification(msgId, params, t, null);
    }

    public final void sendNotification(String msgId, String[] params, Throwable t, Object userData) {
        Date timeStamp = new Date();
        String serverLocalizedDate = this.getDate(Locale.getDefault(), timeStamp);
        String stackTrace = null;
        if (t != null) {
            try {
                CharArrayWriter cw = new CharArrayWriter();
                PrintWriter pw = new PrintWriter(cw);
                ExceptionHelper.printStackTrace((PrintWriter)pw, (Throwable)t);
                pw.flush();
                stackTrace = cw.toString();
            }
            catch (Exception e) {
                _logger.warning(this.getLocalizedMessage("WARNING_UNABLE_TO_REPORT_ERROR", e.getMessage()));
                t.printStackTrace();
            }
        }
        StringBuffer localMessage = new StringBuffer();
        String localizedMsg = null;
        if (params == null || params.length == 0) {
            localizedMsg = this.getLocalizedMessage(msgId);
            localMessage.append(localizedMsg);
        } else {
            localizedMsg = this.getLocalizedMessage(msgId, params);
            localMessage.append(localizedMsg);
        }
        if (t != null) {
            localMessage.append("\n");
            localMessage.append(stackTrace);
        }
        if (this.isVerbose() && _logger.isLoggable(Level.INFO)) {
            _logger.info(localizedMsg);
        }
        this._bufferStream.println("[ " + serverLocalizedDate + " ] " + localMessage.toString());
        if (this._notificationHandlers == null) {
            return;
        }
        Enumeration enum5 = this._notificationHandlers.elements();
        while (enum5.hasMoreElements()) {
            DeployerNotificationHandlerIF handler = (DeployerNotificationHandlerIF)enum5.nextElement();
            Locale loc = handler.getLocale();
            MessageLocalizationHelper locHelp = Notifier.getMessageLocalizationHelper(loc);
            StringBuffer remoteMessage = new StringBuffer();
            if (params == null || params.length == 0) {
                remoteMessage.append(locHelp.getLocalizedMessage(msgId));
            } else {
                remoteMessage.append(locHelp.getLocalizedMessage(msgId, params));
            }
            if (t != null) {
                remoteMessage.append("\n");
                remoteMessage.append(stackTrace);
            }
            Notification notification = new Notification(this.getNotificationType(), this.getNotificationSource(), Notifier.getNextMessageSequenceNumber(), timeStamp.getTime(), remoteMessage.toString());
            if (userData != null) {
                notification.setUserData(userData);
            }
            handler.sendNotification(notification);
        }
    }

    protected final void addReturnValue(String key, Object value) {
        this._returnValues.put(key, value);
    }

    protected final Map getReturnValues() {
        return this._returnValues;
    }

    protected final void addOutput() {
        this.addReturnValue("output", this._bufferOut.toString());
    }

    protected abstract String getNotificationType();

    protected abstract Object getNotificationSource();

    protected abstract ObjectName getTargetObjectName();

    protected abstract boolean isVerbose();

    protected final void reportStateChange(String msgId, String[] params, int state) {
        this.reportStateChange(msgId, params, state, false);
    }

    protected final void reportStateChange(String msgId, String[] params, int state, boolean isDefaultApplicationRestartNeeded) {
        try {
            ObjectName name = this.getTargetObjectName();
            NotificationUserData userData = new NotificationUserData(name, state);
            if (isDefaultApplicationRestartNeeded) {
                userData.setDefaultApplicationRestartNeeded(true);
            }
            this.sendNotification(msgId, params, userData);
        }
        catch (Exception e) {
            _logger.warning(this.getLocalizedMessage("WARNING_UNABLE_TO_REPORT_ERROR", e.getMessage()));
        }
    }

    protected final void reportError(String msgId, Throwable t) {
        try {
            ObjectName name = this.getTargetObjectName();
            NotificationUserData userData = new NotificationUserData(name, t);
            this.sendNotification(msgId, userData);
        }
        catch (Exception e) {
            _logger.warning(this.getLocalizedMessage("WARNING_UNABLE_TO_REPORT_ERROR_MSGID", msgId, e.getMessage()));
        }
    }

    protected final void reportError(String msgId, String[] params, Throwable t) {
        try {
            ObjectName name = this.getTargetObjectName();
            NotificationUserData userData = new NotificationUserData(name, t);
            this.sendNotification(msgId, params, userData);
        }
        catch (Exception e) {
            _logger.warning(this.getLocalizedMessage("WARNING_UNABLE_TO_REPORT_ERROR_MSGID", msgId, e.getMessage()));
        }
    }

    protected final String getDate(Locale loc, Date date) {
        DateFormat df = (DateFormat)_localeToDateFormatMapping.get(loc);
        if (df == null) {
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z", loc);
            _localeToDateFormatMapping.put(loc, df);
        }
        return df.format(date);
    }

    public static synchronized long getNextMessageSequenceNumber() {
        return _messageSequenceNumber++;
    }
}

