/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.deployment.ConnectorModule;
import com.evermind.server.deployment.EnterpriseArchive;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import oracle.j2ee.deployment.DeploymentMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.ConnectorModuleUnDeployer;
import oracle.oc4j.admin.internal.DeployerBase;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.shared.SharedModuleType;
import oracle.oc4j.util.FileUtils;

public class ConnectorModuleDeployer
extends DeployerBase {
    private static Logger logger_ = TraceLogger.getLogger(ConnectorModuleDeployer.class);
    private Application _application;
    private EnterpriseArchive _archive;
    private String _rarFileName;
    private boolean _failureRecovery;
    private ConnectorModule _module;
    private String _deploymentDesc = null;
    private String _connectorDeploymentDesc = null;
    private String _connectorsPath = null;
    private File _connectorFile = null;
    private File _backupFile = null;
    private File _connectorDir = null;
    private File _backupDir = null;

    public ConnectorModuleDeployer(DataSink sink, String deploymentName, Map extraParams) {
        super(sink, deploymentName, extraParams);
    }

    protected boolean doDeploy(boolean isReDeploy) throws DeployerException {
        boolean needsRestart = false;
        this._failureRecovery = "true".equals(this.getParam("failureRecovery"));
        this.initVars();
        ConnectorModule module = this._archive.getConnectorModuleByName(this._deploymentName);
        if (isReDeploy) {
            if (this._failureRecovery) {
                this.saveDeploymentDescs(module);
                this.saveArchive();
            }
            needsRestart = this.undeployPrevious(isReDeploy);
        } else if (module != null) {
            throw new DeployerException(DeploymentMessages.warningDuplicateConnectorName(this._deploymentName, this._application.getName()));
        }
        this.initFiles();
        this.updateConfig(true, false);
        return needsRestart;
    }

    protected void clean() {
        this.removeBackup();
        this._application = null;
        this._archive = null;
        this._module = null;
        super.clean();
    }

    private void removeBackup() {
        try {
            if (this._backupFile != null && this._backupFile.exists()) {
                this._backupFile.delete();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (this._backupDir != null && this._backupDir.exists()) {
                FileUtils.recursiveRemove(this._backupDir);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void undo(boolean isReDeploy) {
        block6: {
            block5: {
                if (this._archive.getConnectorModuleByName(this._deploymentName) == null) {
                    return;
                }
                try {
                    ConnectorModuleUnDeployer undeployer = new ConnectorModuleUnDeployer(this._deploymentName);
                    undeployer.execute(!isReDeploy);
                }
                catch (Exception e) {
                    if (!logger_.isLoggable(Level.WARNING)) break block5;
                    logger_.log(Level.WARNING, "WARNING: unable to undo the deployment for connector " + this._deploymentName + " : " + e.getMessage(), e);
                }
            }
            try {
                this.recover();
            }
            catch (Exception e) {
                if (!logger_.isLoggable(Level.WARNING)) break block6;
                logger_.log(Level.WARNING, "WARNING: unable to undo the deployment for connector " + this._deploymentName + " : " + e.getMessage(), e);
            }
        }
    }

    protected Object getNotificationSource() {
        return "Connector Module Deployer";
    }

    protected ObjectName getTargetObjectName() {
        return ObjectNameFactory.create((String)("oc4j:j2eeType=ResourceAdapterModule,name=" + this._deploymentName + ",J2EEApplication=default,J2EEServer=" + "standalone"));
    }

    protected boolean isRar() {
        return true;
    }

    private void saveDeploymentDescs(ConnectorModule module) {
        if (this._failureRecovery) {
            try {
                StringWriter buffer = new StringWriter();
                PrintWriter writer = new PrintWriter(buffer);
                writer.println("<?xml version=\"1.0\"?>");
                module.getConnectorArchive().writeOrionXML(writer, "");
                this._deploymentDesc = buffer.toString();
                buffer = new StringWriter();
                writer = new PrintWriter(buffer);
                writer.println("<?xml version=\"1.0\"?>");
                module.writeOrionXML(writer, "");
                this._connectorDeploymentDesc = buffer.toString();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void initVars() throws DeployerException {
        try {
            this._application = ApplicationServer.getInstance().getDefaultApplication();
            if (this._application == null) {
                throw new DeployerException("Default application is not found!");
            }
            this._archive = (EnterpriseArchive)this._application.getConfig();
            if (this._archive == null) {
                throw new DeployerException("EnterpriseArchive for default application is not found!");
            }
            this._rarFileName = this._deploymentName + SharedModuleType.RAR.getModuleExtention();
            boolean grantAllPermissions = "true".equals(this.getParam("grantAllPermissions"));
            this._module = new ConnectorModule(this._rarFileName, this._deploymentName, grantAllPermissions);
            String connectorConfiguration = this.getParam("oc4j-connectors");
            if (connectorConfiguration != null) {
                this._module.setDeploymentDescriptor(connectorConfiguration);
            }
            this._connectorsPath = ApplicationServer.getInstance().getConfig().getConnectorDirectory();
            this._connectorDir = new File(this._connectorsPath + File.separator + this._deploymentName);
            this._backupDir = new File(this._connectorsPath + File.separator + this._deploymentName + "_backup");
            this._connectorFile = new File(this._connectorsPath + File.separator + this._deploymentName + File.separator + this._rarFileName);
            this._backupFile = new File(this._backupDir, this._rarFileName);
        }
        catch (DeployerException de) {
            throw (DeployerException)de.fillInStackTrace();
        }
        catch (Exception e) {
            throw new DeployerException(e);
        }
    }

    private boolean undeployPrevious(boolean isReDeploy) throws DeployerException {
        String[] params = new String[]{this._deploymentName};
        ConnectorModule connectorModule = this._archive.getConnectorModuleByName(this._deploymentName);
        if (connectorModule == null) {
            this.sendNotification("NO_PREVIOUS_DEPLOYMENT_FOR_CONNECTOR", params);
            return false;
        }
        try {
            this.sendNotification("UNDEPLOY_PREVIOUS_DEPLOYMENT");
            ConnectorModuleUnDeployer undeployer = new ConnectorModuleUnDeployer(this._deploymentName);
            undeployer.execute(!isReDeploy);
        }
        catch (DeployerException e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, "WARNING: unable to undeploy the previous deployment for connector " + this._deploymentName + " : " + e.getMessage(), e);
            }
            this.sendNotification("WARNING_UNABLE_TO_UNDEPLOY_PREVIOUS_CONNECTOR_DEPLOYMENT", params);
            throw e;
        }
        return !connectorModule.getConnectorArchive().shouldDeployAsSharedLib();
    }

    private void initFiles() throws DeployerException {
        try {
            if (this._connectorDir.exists()) {
                if (!this._connectorDir.isDirectory()) {
                    throw new DeployerException(this._connectorDir.getName() + " is not a directory. Try another -deploymentName value");
                }
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "WARNING: directory " + this._connectorDir.getName() + " should not exist! Previous undeployment maybe unsuccessful!");
                }
            } else if (!this._connectorDir.mkdir()) {
                throw new DeployerException("Cannot create directory " + this._connectorDir.getName());
            }
            File dest = new File(this._connectorDir, this._rarFileName);
            this._sink.copyOrMoveTo(dest);
        }
        catch (Exception e) {
            throw new DeployerException(e);
        }
    }

    private void updateConfig(boolean activate, boolean useSavedDesc) throws DeployerException {
        try {
            this._archive.addModule(this._module, true);
            this._archive.storeConnectors();
            if (activate) {
                if (useSavedDesc) {
                    this._application.addConnector(this._module, this._deploymentDesc, this);
                } else {
                    this._application.addConnector(this._module, this.getParam(this._rarFileName), this);
                }
            }
        }
        catch (Exception e) {
            throw new DeployerException(e);
        }
    }

    private void saveArchive() {
        try {
            if (!this._backupDir.exists() && !this._backupDir.mkdir()) {
                return;
            }
            boolean renamed = this._connectorFile.renameTo(this._backupFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recover() throws Exception {
        String[] params = new String[]{"Connector Recovery", this._deploymentName};
        this.sendNotification("START_OPERATION", params);
        if (this._backupFile.exists()) {
            if (!this._connectorDir.exists() && !this._connectorDir.mkdir()) {
                return;
            }
            boolean renamed = this._backupFile.renameTo(this._connectorFile);
            this._module = new ConnectorModule(this._rarFileName, this._deploymentName, false);
            if (this._connectorDeploymentDesc != null) {
                this._module.setDeploymentDescriptor(this._connectorDeploymentDesc);
            }
            this.updateConfig(true, true);
        }
        this.sendNotification("OPERATION_COMPLETES", params);
    }
}

