/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import com.evermind.server.Application;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationConfigReference;
import com.evermind.server.ApplicationServer;
import com.evermind.server.administration.DefaultApplicationServerAdministrator;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.util.OC4JRuntimeProperties;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.UnDeployerBase;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.hooks.ApplicationProtocol;
import oracle.oc4j.util.FileUtils;

public class ApplicationUnDeployer
extends UnDeployerBase {
    private static Logger logger_ = TraceLogger.getLogger(ApplicationUnDeployer.class);
    private boolean _keepWebBindings = false;
    private boolean isFromDeployRedeploy = false;
    private boolean failureRecovery = false;
    private boolean fireUndeployApplicationHooks = true;

    public ApplicationUnDeployer(String name) {
        super(name);
    }

    public ApplicationUnDeployer(String name, boolean isFromDeployRedeploy) {
        this(name);
        this.isFromDeployRedeploy = isFromDeployRedeploy;
    }

    public ApplicationUnDeployer(String name, boolean isFromDeployRedeploy, boolean failureRecovery) {
        this(name, isFromDeployRedeploy);
        this.failureRecovery = failureRecovery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doUndeploy() throws DeployerException {
        if (this._deploymentName.equals("default")) throw new DeployerException("\"default\" and \"system\" are reserved application names for oc4j server and can not be used for user applications.\n");
        if (this._deploymentName.equals("system")) {
            throw new DeployerException("\"default\" and \"system\" are reserved application names for oc4j server and can not be used for user applications.\n");
        }
        Object object = DefaultApplicationServerAdministrator.iASDeploymentTransactionMutex_;
        synchronized (object) {
            Application application;
            if (!ApplicationServer.getInstance().isOperationAllowed(this._deploymentName)) {
                throw new DeployerException("Application with name: " + this._deploymentName + " cannot be undeployed.");
            }
            try {
                application = ApplicationServer.getInstance().getApplication(this._deploymentName);
                if (application == null) {
                    String[] params = new String[]{this._deploymentName};
                    this.sendNotification("WARNING_APPLICATION_DOESNOT_EXIT_FOR_UNDEPLOY", params);
                    return false;
                }
            }
            catch (Exception e) {
                throw new DeployerException("unable to get application " + this._deploymentName, e);
            }
            ApplicationConfig config_ = application.getConfig();
            try {
                ApplicationConfig parent;
                try {
                    List children;
                    if (this.fireUndeployApplicationHooks) {
                        ApplicationProtocol.PRE_UNDEPLOY_APPLICATION.fire(application);
                    }
                    if (!this.isFromDeployRedeploy && (children = application.getChildren()) != null) {
                        Object[] childrenArray = children.toArray();
                        for (int i = 0; i < childrenArray.length; ++i) {
                            Application child = (Application)childrenArray[i];
                            try {
                                ApplicationUnDeployer ad = new ApplicationUnDeployer(child.getName());
                                ad.fireUndeployApplicationHooks = false;
                                ad.execute();
                                continue;
                            }
                            catch (DeployerException de) {
                                if (!logger_.isLoggable(Level.WARNING)) continue;
                                logger_.log(Level.WARNING, "WARNING: unable to undeploy the child application " + child.getName() + " : " + de.getMessage(), de);
                            }
                        }
                    }
                    ApplicationServer.getInstance().uninstall(application, this._keepWebBindings);
                }
                catch (DeployerException de) {
                    throw (DeployerException)de.fillInStackTrace();
                }
                catch (Exception e) {
                    throw new DeployerException(e);
                }
                Object var10_14 = null;
                if (config_ != null && !(parent = ((EnterpriseArchive)config_).getParent()).getName().equals("default") && !parent.getName().equals("system")) {
                    parent.getLogger().close();
                }
                this.removeFiles(application);
                if (!this.fireUndeployApplicationHooks) return false;
                ApplicationProtocol.POST_UNDEPLOY_APPLICATION.fire(application);
            }
            catch (Throwable throwable) {
                ApplicationConfig parent;
                Object var10_15 = null;
                if (config_ != null && !(parent = ((EnterpriseArchive)config_).getParent()).getName().equals("default") && !parent.getName().equals("system")) {
                    parent.getLogger().close();
                }
                this.removeFiles(application);
                if (!this.fireUndeployApplicationHooks) throw throwable;
                ApplicationProtocol.POST_UNDEPLOY_APPLICATION.fire(application);
                throw throwable;
            }
            return false;
        }
    }

    protected Object getNotificationSource() {
        return "Application UnDeployer";
    }

    protected ObjectName getTargetObjectName() {
        return ObjectNameFactory.create((String)("oc4j:j2eeType=J2EEApplication,name=" + this._deploymentName + ",J2EEServer=" + "standalone"));
    }

    private void removeFiles(Application application) {
        block27: {
            File deploymentDir;
            block26: {
                File appFile;
                block25: {
                    File appDir;
                    block24: {
                        if (!(this.isFromDeployRedeploy && this.failureRecovery || !OC4JRuntimeProperties.getKeepDeployedFiles())) {
                            return;
                        }
                        ApplicationConfigReference ref = application.getApplicationConfigReference();
                        if (ref != null && ref.isExplodedDeployment()) {
                            return;
                        }
                        appDir = new File(application.getConfig().getURL().getFile());
                        deploymentDir = new File(((EnterpriseArchive)application.getConfig()).getDeploymentURL().getFile());
                        appFile = new File(appDir.getParent(), appDir.getName() + ".ear");
                        File backupFile = new File(appDir.getParent(), appDir.getName() + "_backup" + ".ear");
                        File backupDir = new File(appDir.getParent(), appDir.getName() + "_backup");
                        File deploymentBackupDir = new File(deploymentDir.getParent(), deploymentDir.getName() + "_backup");
                        if (this.isFromDeployRedeploy && this.failureRecovery && appFile.exists()) {
                            block23: {
                                block22: {
                                    try {
                                        boolean renamed;
                                        boolean deleted;
                                        if (backupFile.exists() && !(deleted = backupFile.delete()) && logger_.isLoggable(Level.WARNING)) {
                                            logger_.log(Level.WARNING, "WARNING: Unable to remove " + backupFile.getAbsolutePath() + "!");
                                        }
                                        if (appFile.exists() && !(renamed = appFile.renameTo(backupFile)) && logger_.isLoggable(Level.WARNING)) {
                                            logger_.log(Level.WARNING, "WARNING: Unable to rename " + appFile.getAbsolutePath() + "!");
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!logger_.isLoggable(Level.WARNING)) break block22;
                                        logger_.log(Level.WARNING, "WARNING: Unable to rename " + appFile.getAbsolutePath() + " : " + e.getMessage(), e);
                                    }
                                }
                                try {
                                    boolean renamed;
                                    if (backupDir.exists()) {
                                        FileUtils.recursiveRemove(backupDir);
                                    }
                                    if (!(renamed = appDir.renameTo(backupDir)) && logger_.isLoggable(Level.WARNING)) {
                                        logger_.log(Level.WARNING, "WARNING: Unable to rename " + appDir.getAbsolutePath() + "!");
                                    }
                                }
                                catch (Exception e) {
                                    if (!logger_.isLoggable(Level.WARNING)) break block23;
                                    logger_.log(Level.WARNING, "WARNING: Unable to rename " + appDir.getAbsolutePath() + " : " + e.getMessage(), e);
                                }
                            }
                            try {
                                boolean renamed;
                                if (deploymentBackupDir.exists()) {
                                    FileUtils.recursiveRemove(deploymentBackupDir);
                                }
                                if (!(renamed = deploymentDir.renameTo(deploymentBackupDir)) && logger_.isLoggable(Level.WARNING)) {
                                    logger_.log(Level.WARNING, "WARNING: Unable to rename " + deploymentDir.getAbsolutePath() + "!");
                                }
                            }
                            catch (Exception e) {
                                if (!logger_.isLoggable(Level.WARNING)) break block24;
                                logger_.log(Level.WARNING, "WARNING: Unable to rename " + deploymentDir.getAbsolutePath() + " : " + e.getMessage(), e);
                            }
                        }
                    }
                    try {
                        FileUtils.recursiveRemove(appDir);
                    }
                    catch (Exception e) {
                        if (!logger_.isLoggable(Level.WARNING)) break block25;
                        logger_.log(Level.WARNING, "WARNING: Unable to remove appDir " + appDir.getAbsolutePath() + " : " + e.getMessage(), e);
                    }
                }
                try {
                    boolean deleted;
                    if (appFile.exists() && !(deleted = appFile.delete()) && logger_.isLoggable(Level.WARNING)) {
                        logger_.log(Level.WARNING, "WARNING: Unable to remove " + appFile.getAbsolutePath() + "!");
                    }
                }
                catch (Exception e) {
                    if (!logger_.isLoggable(Level.WARNING)) break block26;
                    logger_.log(Level.WARNING, "WARNING: Unable to remove " + appFile.getAbsolutePath() + " : " + e.getMessage(), e);
                }
            }
            try {
                FileUtils.recursiveRemove(deploymentDir);
            }
            catch (Exception e) {
                if (!logger_.isLoggable(Level.WARNING)) break block27;
                logger_.log(Level.WARNING, "WARNING: Unable to remove " + deploymentDir.getAbsolutePath() + " : " + e.getMessage(), e);
            }
        }
    }

    protected boolean isRar() {
        return false;
    }
}

