/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.server.Application;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationConfigReference;
import com.evermind.server.ApplicationServer;
import com.evermind.server.RuntimeApplicationUpdater;
import com.evermind.server.ServerComponent;
import com.evermind.server.administration.DefaultApplicationServerAdministrator;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.WebModule;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.util.CompilerProperties;
import com.evermind.util.ConfigUtils;
import com.evermind.util.OC4JRuntimeProperties;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.ApplicationUnDeployer;
import oracle.oc4j.admin.internal.DeployerBase;
import oracle.oc4j.admin.internal.DeployerCancelException;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.DeployerStateKeeper;
import oracle.oc4j.admin.internal.WebApplicationBinder;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.shared.WebSiteBindings;
import oracle.oc4j.hooks.ApplicationProtocol;
import oracle.oc4j.util.FileUtils;

public class ApplicationDeployer
extends DeployerBase {
    private static Logger logger_ = TraceLogger.getLogger(ApplicationDeployer.class);
    private Application _application;
    private ApplicationConfigReference _appConfigReference;
    private String _parentName;
    private Application _parentApp;
    private String _appDirPath;
    private String _deploymentDirPath;
    private String _archiveFileName;
    private String _archiveFilePath;
    private URL _archiveURL;
    private URL _deploymentURL;
    private ApplicationConfig _parentConfig;
    private EnterpriseArchive _archive;
    private boolean _enableIIOP;
    private boolean _returnClientJar;
    private byte[] _clientJarBytes;
    private boolean _removeArchive;
    private boolean _isExplodedDeployment = false;
    private boolean _failureRecovery;
    private boolean _isReDeploy;
    private Map _savedExtraParams;
    private File _appFile;
    private File _appDir;
    private File _deploymentDir;
    private File _backupFile;
    private File _backupDir;
    private File _deploymentBackupDir;

    public ApplicationDeployer(DataSink sink, String deploymentName, Map extraParams) {
        super(sink, deploymentName, extraParams);
        File src;
        if (sink != null && (src = new File(sink.getFilePath())) != null && src.isDirectory()) {
            this._isExplodedDeployment = true;
            if (this._extraParams == null) {
                this._extraParams = new HashMap();
            }
            this._extraParams.put("explodedDeployment", "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doDeploy(boolean isReDeploy) throws DeployerException {
        this._isReDeploy = isReDeploy;
        if (this._deploymentName.equals("default") || this._deploymentName.equals("system")) {
            throw new DeployerException("\"default\" and \"system\" are reserved application names for oc4j server and can not be used for user applications.\n");
        }
        Object object = DefaultApplicationServerAdministrator.iASDeploymentTransactionMutex_;
        synchronized (object) {
            try {
                if (!ApplicationServer.getInstance().isOperationAllowed(this._deploymentName)) {
                    throw new DeployerException("Deployment to application: " + this._deploymentName + " is not allowed.");
                }
                Map childAppStateMapping = null;
                childAppStateMapping = this.prepareIfThisIsRedeploy(isReDeploy);
                this._failureRecovery = "true".equals(this.getParam("failureRecovery"));
                if (isReDeploy) {
                    if (this._failureRecovery) {
                        this.saveDeploymentExtraParams();
                    }
                    if ("true".equals(this.getParam("keepSettings")) && this.getParam("<main>") == null) {
                        try {
                            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
                            String proprietaryDesc = (String)oc4jMBeanServer.getAttribute(this.getTargetObjectName(), "proprietaryDeploymentDescriptor");
                            this.setParam("<main>", proprietaryDesc);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    this.stopApplication();
                }
                this.undeployPrevious(isReDeploy);
                ApplicationProtocol.PRE_DEPLOY_APPLICATION.fire(ApplicationServer.getInstance(), this._deploymentName);
                this.initVars();
                this.copyArchive();
                this.initArchive();
                this.initApplication();
                this.initAppClientContext();
                this.addApplication();
                this.bindWebApp();
                this.storeConfig();
                this.removeArchive();
                this.setReturnAppClientJar();
                this.reregisterChildApplications(isReDeploy, childAppStateMapping);
            }
            finally {
                ApplicationProtocol.POST_DEPLOY_APPLICATION.fire(ApplicationServer.getInstance(), this._deploymentName);
            }
        }
        return false;
    }

    Map prepareIfThisIsRedeploy(boolean isReDeploy) {
        HashMap<String, Boolean> childAppStateMapping = null;
        if (isReDeploy) {
            List children = this.getChildReferences();
            if (!children.isEmpty()) {
                childAppStateMapping = new HashMap<String, Boolean>();
            }
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                ApplicationConfigReference reference = (ApplicationConfigReference)iterator.next();
                String name = reference.getName();
                boolean state = reference.getStart();
                if (childAppStateMapping == null) continue;
                childAppStateMapping.put(name, new Boolean(state));
            }
        }
        return childAppStateMapping;
    }

    List getChildReferences() {
        return ApplicationServer.getInstance().getConfig().getChildApplicationConfigReferences(this._deploymentName);
    }

    void reregisterChildApplications(boolean isReDeploy, Map childAppStateMapping) throws DeployerException {
        if (!isReDeploy) {
            return;
        }
        ArrayList<InstantiationException> exceptions = null;
        if (childAppStateMapping != null) {
            Iterator iterator = childAppStateMapping.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                Boolean state = (Boolean)childAppStateMapping.get(name);
                try {
                    this.reregisterChildApplication(name, this._deploymentName);
                    if (!state.booleanValue()) continue;
                    this.getApplication(name).startRecursive();
                }
                catch (InstantiationException ie) {
                    if (exceptions == null) {
                        exceptions = new ArrayList<InstantiationException>();
                    }
                    exceptions.add(ie);
                }
            }
            if (exceptions != null) {
                throw new DeployerException("Unable to start child applications - " + this.getErrorString(exceptions).toString());
            }
        }
    }

    private StringBuffer getErrorString(List exceptions) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = exceptions.iterator();
        while (iterator.hasNext()) {
            InstantiationException instantiationException = (InstantiationException)iterator.next();
            buffer.append(instantiationException);
            buffer.append("\n");
        }
        return buffer;
    }

    protected void undo(boolean isRedeploy) {
        block6: {
            if (!this._failureRecovery && CompilerProperties.getWSDebug()) {
                return;
            }
            try {
                if (this.getApplication(this._deploymentName) != null) {
                    try {
                        ApplicationUnDeployer undeployer = new ApplicationUnDeployer(this._deploymentName, isRedeploy);
                        undeployer.execute();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                this.removeFiles();
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (!logger_.isLoggable(Level.WARNING)) break block6;
                logger_.log(Level.WARNING, "WARNING: undo is not successful: " + t.getMessage(), t);
            }
        }
    }

    protected Object getNotificationSource() {
        return "Application Deployer";
    }

    protected ObjectName getTargetObjectName() {
        return ObjectNameFactory.create((String)("oc4j:j2eeType=J2EEApplication,name=" + this._deploymentName + ",J2EEServer=" + "standalone"));
    }

    protected ObjectName getJaznObjectName() {
        return ObjectNameFactory.create((String)("oc4j:j2eeType=Security,name=SecurityProvider,J2EEApplication=" + this._deploymentName + ",J2EEServer=" + "standalone"));
    }

    protected boolean isRar() {
        return false;
    }

    private void saveDeploymentExtraParams() {
        try {
            this._savedExtraParams = new HashMap();
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            ObjectName targetObjectName = this.getTargetObjectName();
            if (oc4jMBeanServer.isRegistered(targetObjectName)) {
                URL descriptorPathURL;
                ApplicationConfigReference appConfigRef;
                boolean isIIOPEnabled;
                Map webSiteBindingsMap;
                Hashtable webSiteBindingNames;
                String webSiteBindings;
                Application previous = this.getApplication(this._deploymentName);
                this._savedExtraParams.put("applicationID", this._deploymentName);
                String parentName = (String)oc4jMBeanServer.getAttribute(targetObjectName, "parentApplicationName");
                this._savedExtraParams.put("parent", parentName == null ? "" : parentName);
                String webSite = (String)oc4jMBeanServer.getAttribute(targetObjectName, "webSite");
                if (webSite != null) {
                    this._savedExtraParams.put("bindWebApp", webSite == null ? "" : webSite);
                }
                if ((webSiteBindings = WebSiteBindings.formatWebSiteBindings((Hashtable)(webSiteBindingNames = WebSiteBindings.translateWebSites((Map)(webSiteBindingsMap = (Map)oc4jMBeanServer.getAttribute(targetObjectName, "webSiteBindings")))))) != null) {
                    this._savedExtraParams.put("webSiteBindings", webSiteBindings);
                }
                this._savedExtraParams.put("enableIIOP", (isIIOPEnabled = (appConfigRef = this.getApplication(this._deploymentName).getApplicationConfigReference()).isIiopEnabled()) ? "true" : "false");
                this._savedExtraParams.put("returnClientJar", "false");
                this._savedExtraParams.put("removeArchive", "false");
                String appPath = appConfigRef.getURL().getPath();
                String targetPath = appPath.substring(0, appPath.lastIndexOf(this._deploymentName) - 1);
                String defaultPath = ApplicationServer.getInstance().getConfig().getApplicationDirectory();
                if (!targetPath.equals(defaultPath)) {
                    this._savedExtraParams.put("targetPath", targetPath);
                }
                if ((descriptorPathURL = appConfigRef.getDeploymentDescriptorURL()) != null) {
                    this._savedExtraParams.put("deploymentDirectory", descriptorPathURL.getPath());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void undeployPrevious(boolean isReDeploy) throws DeployerException {
        this.checkCancelState();
        if (!this._failureRecovery && this.getParam("undeployPrevious") != null && "false".equals(this.getParam("undeployPrevious"))) {
            this.sendNotification("DO_NOT_UNDEPLOY_PREVIOUS_DEPLOYMENT");
            return;
        }
        try {
            Application previous = this.getApplication(this._deploymentName);
            if (previous != null) {
                this.sendNotification("UNDEPLOY_PREVIOUS_DEPLOYMENT");
                ApplicationUnDeployer undeployer = new ApplicationUnDeployer(this._deploymentName, true, this._failureRecovery);
                undeployer.execute(!isReDeploy);
            }
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, "WARNING: unable to undeploy the previous deployment for application " + this._deploymentName + " : " + t.getMessage(), t);
            }
            String[] params = new String[]{this._deploymentName};
            this.sendNotification("WARNING_UNABLE_TO_UNDEPLOY_PREVIOUS_DEPLOYMENT", params, t);
        }
    }

    private void stopApplication() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        String[] params = new String[]{this._deploymentName};
        try {
            if (oc4jMBeanServer.isRegistered(this.getTargetObjectName())) {
                this.sendNotification("STOPPING_APPLICATION", params);
                oc4jMBeanServer.invoke(this.getTargetObjectName(), "stop", null, null);
                this.sendNotification("STOPPED_APPLICATION", params);
            }
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, "ERROR: unable to stop application " + this._deploymentName + " : " + t.getMessage(), t);
            }
            this.sendNotification("ERROR_STOPPING_APPLICATION", params, t);
        }
    }

    private void initVars() throws DeployerException {
        try {
            this._parentName = this.getParam("parent");
            if (this._parentName == null) {
                this._parentName = ApplicationServer.getInstance().getConfig().getDefaultApplicationConfigReference().getName();
            }
            this._parentApp = this.getApplication(this._parentName);
            this._enableIIOP = "true".equals(this.getParam("enableIIOP")) && Compilation.iiopGen;
            this._returnClientJar = "true".equals(this.getParam("returnClientJar")) && Compilation.iiopGen;
            this._removeArchive = "true".equals(this.getParam("removeArchive"));
            if (this._returnClientJar) {
                this._enableIIOP = true;
            }
            String targetPath = this.getParam("targetPath");
            if (this._isExplodedDeployment) {
                this._archiveFilePath = this._appDirPath = this._sink.getFilePath();
            } else {
                this._appDirPath = targetPath == null ? ApplicationServer.getInstance().getConfig().getApplicationDirectory() : targetPath;
                this._archiveFileName = this._deploymentName + ".ear";
                this._archiveFilePath = this._appDirPath + File.separator + this._archiveFileName;
            }
            this._archiveURL = new File(this._archiveFilePath).toURL();
            this._deploymentDirPath = this.getParam("deploymentDirectory");
            if (this._deploymentDirPath == null) {
                this._deploymentDirPath = this._isExplodedDeployment ? this._archiveURL.getPath() + File.separator + "META-INF" : ApplicationServer.getInstance().getConfig().getDeploymentDirectory();
            }
            this._deploymentURL = this._isExplodedDeployment ? ConfigUtils.getURL(ApplicationServer.getInstance().getConfig().getURL(), this._deploymentDirPath) : ConfigUtils.getURL(ApplicationServer.getInstance().getConfig().getURL(), this._deploymentDirPath + File.separator + this._deploymentName);
            this._appFile = new File(this._archiveURL.getFile());
            this._appDir = new File(this._appDirPath, this._deploymentName);
            this._deploymentDir = new File(this._deploymentURL.getFile());
            if (this._isExplodedDeployment && !this._deploymentDir.exists()) {
                this._deploymentDir.mkdirs();
            }
            this._backupFile = new File(this._appDir.getParent(), this._appDir.getName() + "_backup" + ".ear");
            this._backupDir = new File(this._appDir.getParent(), this._appDir.getName() + "_backup");
            this._deploymentBackupDir = new File(this._deploymentDir.getParent(), this._deploymentDir.getName() + "_backup");
            if (this._parentApp == null) {
                throw new DeployerException("parent application (" + this._parentName + ") is not found!");
            }
            this._parentConfig = ApplicationServer.getInstance().getConfig().getApplicationConfig(this._parentName);
        }
        catch (DeployerException de) {
            throw (DeployerException)de.fillInStackTrace();
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    private void copyArchive() throws DeployerException {
        this.checkCancelState();
        try {
            File dir = new File(this._appDirPath);
            if (dir.exists()) {
                if (!dir.isDirectory()) {
                    throw new DeployerException(dir.getName() + " is not a directory. The -targetPath value should be a directory.");
                }
            } else if (!dir.mkdir()) {
                throw new DeployerException("Cannot create directory " + dir.getName());
            }
            if (!this._isExplodedDeployment) {
                File dest = new File(this._appDirPath, this._archiveFileName);
                this._sink.copyOrMoveTo(dest);
            }
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    private void initArchive() throws DeployerException {
        this.checkCancelState();
        try {
            String[] params = new String[]{this._archiveFilePath};
            this.sendNotification("INITIALIZE_BEGINS", params);
            boolean autoUnpack = true;
            this._archive = new EnterpriseArchive(this._deploymentName, this._archiveURL, this._deploymentURL, ApplicationServer.getInstance().getConfig(), this._parentConfig, autoUnpack, this._extraParams);
            this.sendNotification("INITIALIZE_ENDS", params);
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    private void initApplication() throws DeployerException {
        this.checkCancelState();
        try {
            String path;
            String targetPath = this.getParam("targetPath");
            String string = path = targetPath == null ? ApplicationServer.getInstance().getConfig().getApplicationDirectoryString() : targetPath;
            if (this._isExplodedDeployment) {
                path = this._sink.getFilePath();
            } else {
                if (!path.endsWith(File.separator) && !path.endsWith("/")) {
                    path = path + File.separatorChar;
                }
                path = path + this._archiveFileName;
            }
            this._appConfigReference = new ApplicationConfigReference(ApplicationServer.getInstance().getConfig().getURL(), this._deploymentName, path, this._parentName);
            if (this._isExplodedDeployment) {
                this._appConfigReference.setExplodedDeployment(true);
            }
            if (this.getParam("deploymentDirectory") != null) {
                this._appConfigReference.setDeploymentDirectory(ApplicationServer.getInstance().getConfig().getURL(), this._deploymentDirPath + File.separator + this._deploymentName);
            }
            if (this._enableIIOP) {
                this._appConfigReference.setIiopEnabled(true);
            }
            this._appConfigReference.setConfig(this._archive);
            this._application = new Application(ApplicationServer.getInstance(), this._parentApp, this._appConfigReference);
            this._application.setNotifier(this);
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    protected void clean() {
        this.removeBackup();
        if (this._application != null) {
            this._application.setNotifier(null);
            this._application = null;
        }
        this._appConfigReference = null;
        this._parentApp = null;
        this._parentConfig = null;
        this._archive = null;
        this._clientJarBytes = null;
        this._savedExtraParams = null;
        super.clean();
    }

    private void removeBackup() {
        try {
            if (this._backupFile != null && this._backupFile.exists()) {
                this._backupFile.delete();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (this._backupDir != null && this._backupDir.exists()) {
                FileUtils.recursiveRemove(this._backupDir);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (this._deploymentBackupDir != null && this._deploymentBackupDir.exists()) {
                FileUtils.recursiveRemove(this._deploymentBackupDir);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initAppClientContext() throws DeployerException {
        this.checkCancelState();
        if (this._enableIIOP) {
            try {
                Context ctx = this._archive.getDeploymentContext();
                byte[] clientData = new byte[]{};
                MemoryArchiveContext clientJarContext = new MemoryArchiveContext(ctx, "_iiopClient.jar", clientData, 0, clientData.length, false);
                ctx.rebind("_iiopClient.jar", (Object)clientData);
                ContextUtils.flush(clientJarContext);
            }
            catch (Throwable t) {
                throw new DeployerException("Unable to read deployment directory", t);
            }
        }
        try {
            Context ctx = this._archive.getDeploymentContext();
            ctx.unbind("_iiopClient.jar");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addApplication() throws DeployerException {
        this.checkCancelState();
        try {
            ApplicationServer.getInstance().addApplication(this._archive, this._application, this);
            ApplicationServer.getInstance().getConfig().addApplicationConfigReference(this._appConfigReference);
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    private void storeConfig() throws DeployerException {
        this.checkCancelState();
        try {
            HttpApplicationConfig hconfig;
            this._archive.storeDeployment();
            ApplicationServer.getInstance().getConfig().store();
            WebModule webModule = this.getNewContextRootWebModule();
            if (webModule != null && (hconfig = this._application.getHttpApplicationConfig(webModule.getName())) instanceof ServerComponent) {
                ((ServerComponent)((Object)hconfig)).storeDeployment();
            }
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    private void bindWebApp() throws DeployerException {
        String webSiteBindings;
        this.checkCancelState();
        WebApplicationBinder binder = null;
        String siteName = this.getParam("bindWebApp");
        if (siteName != null && !siteName.trim().equals("")) {
            binder = new WebApplicationBinder();
            WebModule webModule = this.getNewContextRootWebModule();
            if (webModule != null) {
                webModule.setContextRoot(this.getParam("contextRoot"));
            }
            String[] params = new String[]{siteName};
            this.sendNotification("BIND_WEB_APPS_BEGINS", params);
            binder.bindWebApp(this._deploymentName, siteName);
            this.sendNotification("BIND_WEB_APPS_ENDS", params);
        }
        if ((webSiteBindings = this.getParam("webSiteBindings")) != null && webSiteBindings.trim().length() > 0) {
            String[] moduleBindings;
            if (binder == null) {
                binder = new WebApplicationBinder();
            }
            if ((moduleBindings = webSiteBindings.split(";")).length > 0) {
                for (int n = 0; n < moduleBindings.length; ++n) {
                    if (moduleBindings[n] == null) continue;
                    String[] moduleBinding = moduleBindings[n].split(":");
                    String moduleName = null;
                    String[] webSites = null;
                    if (moduleBinding[0] != null) {
                        moduleName = moduleBinding[0].trim();
                    }
                    if (moduleBinding.length > 1 && moduleBinding[1].trim().length() > 0) {
                        webSites = moduleBinding[1].split(",");
                    }
                    if (moduleName == null || webSites.length <= 0) continue;
                    for (int m = 0; m < webSites.length; ++m) {
                        if (webSites[m] == null) continue;
                        String webSite = webSites[m].trim();
                        if (moduleName.equals(".")) {
                            binder.bindWebApp(this._deploymentName, webSite);
                            continue;
                        }
                        binder.bindWebApp(this._deploymentName, moduleName, webSite);
                    }
                }
            }
        }
    }

    private void removeArchive() throws DeployerException {
        this.checkCancelState();
        if (!this._removeArchive) {
            return;
        }
        if (this._isExplodedDeployment) {
            return;
        }
        try {
            if (this._archiveFilePath != null) {
                String[] params = new String[]{this._archiveFilePath};
                this.sendNotification("DELETING", params);
                File earFile = new File(this._archiveFilePath);
                if (earFile.exists()) {
                    earFile.delete();
                }
            }
            Iterator iterator = this._archive.getWebApplications().iterator();
            while (iterator.hasNext()) {
                WebModule module = (WebModule)iterator.next();
                String path = module.getPath();
                if (path.endsWith(".war")) {
                    if (logger_.isLoggable(Level.WARNING)) {
                        logger_.log(Level.WARNING, "WARNING: ApplicationDeployer.removeArchive(), path should NOT end with .war: " + path + "!");
                    }
                } else {
                    path = path + ".war";
                }
                String webModulePath = ConfigUtils.getURL(this._archive.getURL(), path).getPath();
                String[] params = new String[]{webModulePath};
                this.sendNotification("DELETING", params);
                File warFile = new File(webModulePath);
                if (!warFile.exists()) continue;
                warFile.delete();
            }
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, "ERROR: unable to remove ear and war files after deployment: " + t.getMessage(), t);
            }
            this.sendNotification("WARNING_UNABLE_TO_REMOVE_FILE_AFTER_DEPLOYMENT", t);
        }
    }

    private void setReturnAppClientJar() throws DeployerException {
        if (this._returnClientJar) {
            try {
                Context ctx = this._archive.getDeploymentContext();
                this._clientJarBytes = (byte[])ctx.lookup("_iiopClient.jar");
            }
            catch (Throwable t) {
                throw new DeployerException(t);
            }
            this.addReturnValue("<client-stubs-supported>", "true");
            this.addReturnValue("<return-client-jar>", this._clientJarBytes);
        } else {
            this.addReturnValue("<client-stubs-supported>", "false");
        }
    }

    private void checkCancelState() throws DeployerException {
        Integer state = (Integer)DeployerStateKeeper.getState(this._id);
        if (state == DeployerStateKeeper.CANCEL) {
            throw new DeployerCancelException("operation is cancelled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFiles() throws DeployerException {
        Object object = DefaultApplicationServerAdministrator.iASDeploymentTransactionMutex_;
        synchronized (object) {
            block27: {
                block26: {
                    if (!this._failureRecovery && OC4JRuntimeProperties.getKeepDeployedFiles()) {
                        return;
                    }
                    if (this._isExplodedDeployment) {
                        return;
                    }
                    try {
                        FileUtils.recursiveRemove(this._appDir);
                    }
                    catch (Throwable t) {
                        if (logger_.isLoggable(Level.SEVERE)) {
                            logger_.log(Level.SEVERE, "ERROR: Unable to remove appDir " + this._appDir.getAbsolutePath() + " : " + t.getMessage(), t);
                        }
                        String[] params = new String[]{this._appDir.getAbsolutePath()};
                        this.sendNotification("WARNING_UNABLE_TO_REMOVE_APP_DIR", params, t);
                    }
                    try {
                        boolean deleted;
                        if (this._archiveURL != null && this._appFile.exists() && !(deleted = this._appFile.delete()) && logger_.isLoggable(Level.WARNING)) {
                            logger_.log(Level.WARNING, "WARNING: Unable to remove " + this._appFile.getAbsolutePath() + "!");
                        }
                    }
                    catch (Throwable t) {
                        if (!logger_.isLoggable(Level.WARNING)) break block26;
                        logger_.log(Level.WARNING, "WARNING: Unable to remove " + this._appFile.getAbsolutePath() + " : " + t.getMessage(), t);
                    }
                }
                try {
                    if (this._deploymentURL != null) {
                        FileUtils.recursiveRemove(this._deploymentDir);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (!logger_.isLoggable(Level.WARNING)) break block27;
                    logger_.log(Level.WARNING, "WARNING: Unable to remove " + this._deploymentDir.getAbsolutePath() + " : " + t.getMessage(), t);
                }
            }
            if (this._isReDeploy && this._failureRecovery) {
                String[] params;
                block30: {
                    block29: {
                        block28: {
                            params = new String[]{"Application Recovery", this._deploymentName};
                            this.sendNotification("START_OPERATION", params);
                            try {
                                boolean renamed;
                                if (this._backupFile.exists() && !(renamed = this._backupFile.renameTo(this._appFile)) && logger_.isLoggable(Level.WARNING)) {
                                    logger_.log(Level.WARNING, "WARNING: Unable to rename " + this._backupFile.getAbsolutePath() + "!");
                                }
                            }
                            catch (Exception e) {
                                if (!logger_.isLoggable(Level.WARNING)) break block28;
                                logger_.log(Level.WARNING, "WARNING: Unable to rename " + this._backupFile.getAbsolutePath() + " : " + e.getMessage(), e);
                            }
                        }
                        try {
                            boolean renamed;
                            if (this._backupDir.exists() && !(renamed = this._backupDir.renameTo(this._appDir)) && logger_.isLoggable(Level.WARNING)) {
                                logger_.log(Level.WARNING, "WARNING: Unable to rename backupDir " + this._backupDir.getAbsolutePath() + "!");
                            }
                        }
                        catch (Exception e) {
                            if (!logger_.isLoggable(Level.WARNING)) break block29;
                            logger_.log(Level.WARNING, "WARNING: Unable to rename backupDir " + this._backupDir.getAbsolutePath() + " : " + e.getMessage(), e);
                        }
                    }
                    try {
                        boolean renamed;
                        if (this._deploymentBackupDir.exists() && !(renamed = this._deploymentBackupDir.renameTo(this._deploymentDir)) && logger_.isLoggable(Level.WARNING)) {
                            logger_.log(Level.WARNING, "WARNING: Unable to rename " + this._deploymentBackupDir.getAbsolutePath() + "!");
                        }
                    }
                    catch (Exception e) {
                        if (!logger_.isLoggable(Level.WARNING)) break block30;
                        logger_.log(Level.WARNING, "WARNING: Unable to rename " + this._deploymentBackupDir.getAbsolutePath() + " : " + e.getMessage(), e);
                    }
                }
                RuntimeApplicationUpdater updater = new RuntimeApplicationUpdater(this._deploymentName, this._savedExtraParams);
                try {
                    updater.addApplicationToRuntime();
                }
                catch (DeployerException ex) {
                    ex.printStackTrace();
                    throw ex;
                }
                this.sendNotification("OPERATION_COMPLETES", params);
            }
        }
    }

    void reregisterChildApplication(String childAppName, String parentName) throws InstantiationException {
        Application childApp = this.getApplication(childAppName);
        if (childApp != null) {
            childApp.reregisterWithParent(parentName);
        }
    }

    Application getApplication(String appName) throws InstantiationException {
        return ApplicationServer.getInstance().getApplication(appName);
    }

    private WebModule getNewContextRootWebModule() {
        String contextRoot = this.getParam("contextRoot");
        if (contextRoot != null) {
            Iterator webIt;
            Collection webApps = this._archive.getWebApplications();
            Iterator iterator = webIt = webApps != null ? webApps.iterator() : null;
            if (webIt != null && webApps.size() == 1 && webIt.hasNext()) {
                return (WebModule)webIt.next();
            }
        }
        return null;
    }
}

