/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.config;

import com.evermind.security.User;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import oracle.ias.opmn.optic.OpmnHostPort;
import oracle.ias.opmn.optic.OpmnProcess;
import oracle.ias.opmn.optic.OpmnQuery;
import oracle.ias.opmn.optic.OpticException;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanException;
import oracle.oc4j.admin.config.CommandParser;
import oracle.oc4j.admin.config.ConfigUtils;
import oracle.oc4j.admin.config.CreationException;
import oracle.oc4j.admin.config.InstanceConfig;
import oracle.oc4j.admin.config.LocalizationHelper;
import oracle.oc4j.admin.internal.OpmnConfigCallBack;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.server.state.JMXStateFactoryImpl;
import oracle.oc4j.admin.management.mbeans.OpmnConfig;

public class Oc4jRemover {
    static String CONFIG_MBEAN_NAME = "default";
    static String DEFAULT_DOMAIN = "oc4j";
    static LocalizationHelper _locHelper = null;
    static String _configHome = null;

    public Oc4jRemover() {
        JMXStateFactoryImpl.init();
        _locHelper = new LocalizationHelper();
        ConfigUtils.doDebug(Boolean.getBoolean("oc4j.creation.debug"));
    }

    public void doRemove(String oracleHome, String configHome, String oc4jName) throws CreationException {
        InstanceConfig instanceConfig = new InstanceConfig(oracleHome, configHome, oc4jName);
        instanceConfig.permitRemove(false);
    }

    public static void main(String[] args) {
        Oc4jRemover remover = new Oc4jRemover();
        if (args == null || args.length == 0 || args[0].equals("-help")) {
            System.out.println(Oc4jRemover.getUsage());
            System.exit(9);
        }
        CommandParser parser = new CommandParser();
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        try {
            parser.parseArguments(arguments);
        }
        catch (CreationException ce) {
            ConfigUtils.log(ce);
            System.out.println(ce.getMessage());
            System.out.println(Oc4jRemover.getUsage());
            System.exit(1);
        }
        _configHome = parser.getConfigHome();
        if (!new File(_configHome).exists()) {
            System.out.println(_locHelper.getMessage("config_home_not_exist", _configHome));
            System.exit(1);
        }
        if (parser.getInstanceName().equals("home") && _configHome.equals(parser.getOracleHome())) {
            System.out.println(_locHelper.getMessage("can_not_remove_binary_home", _configHome));
            System.exit(1);
        }
        System.out.println(_locHelper.getMessage("removing_oc4j", parser.getInstanceName()));
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer("TEST");
        try {
            remover.checkReservedInstance(parser.getInstanceName(), parser.getOracleHome(), parser.getConfigHome());
            boolean isOc4jAlive = remover.checkOc4jAlive(parser.getConfigHome(), parser.getInstanceName());
            if (isOc4jAlive) {
                System.out.println(_locHelper.getMessage("oc4j_is_up_cant_remove", parser.getInstanceName()));
            } else {
                User user = remover.getAdminUser(parser);
                remover.registerOpmnConfigMBean(mbeanServer, parser.getOracleHome(), parser.getConfigHome());
                ObjectName compOc4jGroupMBean = remover.getCompOc4jGroupMBean(mbeanServer, parser.getInstanceName());
                remover.removeOC4J(parser, mbeanServer, compOc4jGroupMBean);
                remover.removeEmptyGroup(mbeanServer, compOc4jGroupMBean);
                remover.syncLocalOpmnMBeans(parser, user);
                System.out.println(_locHelper.getMessage("oc4j_removed", parser.getInstanceName(), compOc4jGroupMBean.getKeyProperty("name")));
            }
        }
        catch (CreationException ce) {
            ConfigUtils.log(ce);
            System.out.println(ce.getMessage());
            System.exit(1);
        }
        catch (MBeanException e) {
            ConfigUtils.log(e);
            ConfigMBeanException cme = (ConfigMBeanException)e.getCause();
            System.out.println(e.getMessage() + ": " + cme.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            ConfigUtils.log(e);
            System.out.println(e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    private User getAdminUser(CommandParser parser) {
        User user = null;
        try {
            user = ConfigUtils.getAdminUser(parser.getConfigHome(), parser.getInstanceName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return user;
    }

    private void removeOC4J(CommandParser parser, MBeanServer mbeanServer, ObjectName compOc4jGroupMBean) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object[] params = new Object[]{new String(parser.getInstanceName())};
        String[] signatures = new String[]{new String("java.lang.String")};
        mbeanServer.invoke(compOc4jGroupMBean, "removeOc4j", params, signatures);
    }

    private void syncLocalOpmnMBeans(CommandParser parser, User user) throws CreationException {
        if (ConfigUtils.pingOPMN(parser.getConfigHome())) {
            ConfigUtils.reloadOPMN(parser.getConfigHome());
            if (user == null) {
                user = ConfigUtils.getAdminUser(parser.getConfigHome(), "home");
            }
            ConfigUtils.syncLocalOpmnMBeans(parser.getConfigHome(), user);
        }
    }

    public static String getUsage() {
        return "\nUsage: \nremoveinstance -instanceName <instance name> [-configHome <dir>] \n";
    }

    private void checkReservedInstance(String oc4jName, String oracleHome, String configHome) throws CreationException {
        if (oracleHome.equals(configHome)) {
            String[] instances = new String[]{"home", "HTTP_Server"};
            for (int i = 0; i < instances.length; ++i) {
                if (!oc4jName.equalsIgnoreCase(instances[i])) continue;
                throw new CreationException(_locHelper.getMessage("not_remove_reserved_instance", instances[i]));
            }
        }
    }

    private boolean checkOc4jAlive(String configHome, String oc4jName) throws CreationException {
        boolean isAlive = false;
        if (ConfigUtils.pingOPMN(configHome)) {
            isAlive = this.isAlive(configHome, oc4jName);
        }
        return isAlive;
    }

    private boolean isAlive(String configHome, String instanceName) throws CreationException {
        String host = null;
        int port = 0;
        OpmnHostPort type = OpmnHostPort.LOCAL;
        String query = OpmnQuery.buildDmsQuery(null, null, null);
        OpmnQuery oq = new OpmnQuery(host, port, type, configHome);
        List procList = null;
        try {
            procList = OpmnQuery.getProc((String)configHome, (String)query);
        }
        catch (OpticException oe) {
            throw new CreationException(oe.getMessage());
        }
        for (int i = 0; i < procList.size(); ++i) {
            OpmnProcess p = (OpmnProcess)procList.get(i);
            if (!p.getProcessTypeName().equals(instanceName) || !p.getStatus().equals("Alive")) continue;
            return true;
        }
        return false;
    }

    private ObjectName getCompOc4jGroupMBean(MBeanServer mbeanServer, String oc4jName) throws CreationException {
        try {
            ObjectName procOc4jName = new ObjectName("*:type=OpmnProcOc4j,OpmnConfig=" + CONFIG_MBEAN_NAME + ",name=" + oc4jName + ",*");
            Object[] procOc4jMBeans = mbeanServer.queryNames(procOc4jName, null).toArray();
            String groupName = null;
            if (procOc4jMBeans.length == 0) {
                throw new CreationException(_locHelper.getMessage("oc4j_not_exist", oc4jName));
            }
            if (procOc4jMBeans.length >= 1) {
                for (int i = 0; i < procOc4jMBeans.length; ++i) {
                    if (!((ObjectName)procOc4jMBeans[i]).getDomain().equals(DEFAULT_DOMAIN)) continue;
                    groupName = ((ObjectName)procOc4jMBeans[i]).getKeyProperty("OpmnCompOc4jGroup");
                }
            }
            if (groupName == null) {
                throw new CreationException(_locHelper.getMessage("not_find_group", oc4jName));
            }
            ObjectName compOc4jGroupName = new ObjectName("*:type=OpmnCompOc4jGroup,OpmnConfig=" + CONFIG_MBEAN_NAME + ",name=" + groupName);
            Object[] compOc4jGroupMBeans = mbeanServer.queryNames(compOc4jGroupName, null).toArray();
            if (compOc4jGroupMBeans.length == 0) {
                throw new CreationException(_locHelper.getMessage("group_not_exist", groupName));
            }
            if (compOc4jGroupMBeans.length >= 1) {
                for (int i = 0; i < compOc4jGroupMBeans.length; ++i) {
                    if (!((ObjectName)compOc4jGroupMBeans[i]).getDomain().equals(DEFAULT_DOMAIN)) continue;
                    return (ObjectName)compOc4jGroupMBeans[i];
                }
            }
        }
        catch (Exception e) {
            throw new CreationException(e, e.getMessage());
        }
        return null;
    }

    private OpmnConfig registerOpmnConfigMBean(MBeanServer mbeanServer, String oracleHome, String configHome) throws CreationException {
        OpmnConfig opmnConfigMBean = null;
        try {
            opmnConfigMBean = new OpmnConfig(new OpmnConfigCallBack(CONFIG_MBEAN_NAME, oracleHome, configHome));
            ObjectName opmnConfigMBeanObjectName = opmnConfigMBean.getObjectName();
            if (mbeanServer.isRegistered(opmnConfigMBeanObjectName)) {
                throw new CreationException(_locHelper.getMessage("opmnconfmbean_already_registered", opmnConfigMBeanObjectName.toString()));
            }
            mbeanServer.registerMBean(ModelMBeanFactory.getModelMBean(opmnConfigMBean), opmnConfigMBeanObjectName);
        }
        catch (Exception e) {
            ConfigUtils.log(e);
            throw new CreationException(e, e.getMessage());
        }
        return opmnConfigMBean;
    }

    private void removeEmptyGroup(MBeanServer mbeanServer, ObjectName oc4jGroupObjectName) throws CreationException {
        try {
            Object[] params = new Object[]{};
            String[] signatures = new String[]{};
            ObjectName[] oc4jProcs = (ObjectName[])mbeanServer.invoke(oc4jGroupObjectName, "getOc4jProcs", params, signatures);
            if (oc4jProcs != null && oc4jProcs.length != 0) {
                return;
            }
            ObjectName configObjectName = new ObjectName(DEFAULT_DOMAIN + ":type=OpmnConfig,name=" + CONFIG_MBEAN_NAME);
            Object[] configMBeans = mbeanServer.queryNames(configObjectName, null).toArray();
            if (configMBeans.length != 1) {
                throw new CreationException(_locHelper.getMessage("only_one_config_mbean", configObjectName.toString()));
            }
            String groupName = oc4jGroupObjectName.getKeyProperty("name");
            params = new Object[]{groupName};
            signatures = new String[]{new String("java.lang.String")};
            mbeanServer.invoke(configObjectName, "removeOc4jGroup", params, signatures);
        }
        catch (CreationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CreationException(e, e.getMessage());
        }
    }
}

